﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backup/model/MalwareScanner.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Backup {
namespace Model {
namespace MalwareScannerMapper {

static const int GUARDDUTY_HASH = HashingUtils::HashString("GUARDDUTY");

MalwareScanner GetMalwareScannerForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == GUARDDUTY_HASH) {
    return MalwareScanner::GUARDDUTY;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<MalwareScanner>(hashCode);
  }

  return MalwareScanner::NOT_SET;
}

Aws::String GetNameForMalwareScanner(MalwareScanner enumValue) {
  switch (enumValue) {
    case MalwareScanner::NOT_SET:
      return {};
    case MalwareScanner::GUARDDUTY:
      return "GUARDDUTY";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace MalwareScannerMapper
}  // namespace Model
}  // namespace Backup
}  // namespace Aws
