﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/CodeInterpreterInvocationInput.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BedrockAgentRuntime {
namespace Model {

CodeInterpreterInvocationInput::CodeInterpreterInvocationInput(JsonView jsonValue) { *this = jsonValue; }

CodeInterpreterInvocationInput& CodeInterpreterInvocationInput::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("code")) {
    m_code = jsonValue.GetString("code");
    m_codeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("files")) {
    Aws::Utils::Array<JsonView> filesJsonList = jsonValue.GetArray("files");
    for (unsigned filesIndex = 0; filesIndex < filesJsonList.GetLength(); ++filesIndex) {
      m_files.push_back(filesJsonList[filesIndex].AsString());
    }
    m_filesHasBeenSet = true;
  }
  return *this;
}

JsonValue CodeInterpreterInvocationInput::Jsonize() const {
  JsonValue payload;

  if (m_codeHasBeenSet) {
    payload.WithString("code", m_code);
  }

  if (m_filesHasBeenSet) {
    Aws::Utils::Array<JsonValue> filesJsonList(m_files.size());
    for (unsigned filesIndex = 0; filesIndex < filesJsonList.GetLength(); ++filesIndex) {
      filesJsonList[filesIndex].AsString(m_files[filesIndex]);
    }
    payload.WithArray("files", std::move(filesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
