﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agentcore-control/model/ListPolicyGenerationAssetsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BedrockAgentCoreControl::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListPolicyGenerationAssetsResult::ListPolicyGenerationAssetsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListPolicyGenerationAssetsResult& ListPolicyGenerationAssetsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("policyGenerationAssets")) {
    Aws::Utils::Array<JsonView> policyGenerationAssetsJsonList = jsonValue.GetArray("policyGenerationAssets");
    for (unsigned policyGenerationAssetsIndex = 0; policyGenerationAssetsIndex < policyGenerationAssetsJsonList.GetLength();
         ++policyGenerationAssetsIndex) {
      m_policyGenerationAssets.push_back(policyGenerationAssetsJsonList[policyGenerationAssetsIndex].AsObject());
    }
    m_policyGenerationAssetsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
