﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/budgets/model/DeleteSubscriberRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Budgets::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteSubscriberRequest::SerializePayload() const {
  JsonValue payload;

  if (m_accountIdHasBeenSet) {
    payload.WithString("AccountId", m_accountId);
  }

  if (m_budgetNameHasBeenSet) {
    payload.WithString("BudgetName", m_budgetName);
  }

  if (m_notificationHasBeenSet) {
    payload.WithObject("Notification", m_notification.Jsonize());
  }

  if (m_subscriberHasBeenSet) {
    payload.WithObject("Subscriber", m_subscriber.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteSubscriberRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSBudgetServiceGateway.DeleteSubscriber"));
  return headers;
}
