/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

class SQLQueryTreeMapper<T, C> {
    @NotNull
    private final Class<T> mappingResultType;
    @NotNull
    private final Set<String> transparentNodeNames;
    @NotNull
    private final Map<String, TreeMapperCallback<T, C>> translations;
    @NotNull
    private final Stack<MapperFrame> stack = new Stack();
    @NotNull
    private final C context;

    public SQLQueryTreeMapper(@NotNull Class<T> mappingResultType, @NotNull Set<String> transparentNodeNames, @NotNull Map<String, TreeMapperCallback<T, C>> translations, @NotNull C context) {
        this.mappingResultType = mappingResultType;
        this.transparentNodeNames = transparentNodeNames;
        this.translations = translations;
        this.context = context;
    }

    @NotNull
    public T translate(@NotNull STMTreeNode root) {
        MapperRootFrame rootFrame = new MapperRootFrame(root);
        this.stack.push(rootFrame);
        while (!this.stack.isEmpty()) {
            this.stack.pop().doWork();
        }
        return rootFrame.result;
    }

    private class MapperDataPendingNodeFrame
    extends MapperNodeFrame
    implements MapperResultFrame<T> {
        @NotNull
        public final List<T> childrenData;
        @NotNull
        public final TreeMapperCallback<T, C> translation;

        public MapperDataPendingNodeFrame(@NotNull STMTreeNode node, @NotNull MapperResultFrame<T> parent, TreeMapperCallback<T, C> translation) {
            super(node, parent);
            this.childrenData = new LinkedList();
            this.translation = translation;
        }

        @Override
        public void aggregate(@NotNull T result) {
            this.childrenData.add(result);
        }

        @Override
        public void doWork() {
            this.parent.aggregate(this.translation.apply(this.node, this.childrenData, SQLQueryTreeMapper.this.context));
        }
    }

    private static interface MapperFrame {
        public void doWork();
    }

    private abstract class MapperNodeFrame
    implements MapperFrame {
        @NotNull
        public final STMTreeNode node;
        @NotNull
        public final MapperResultFrame<T> parent;

        public MapperNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    private class MapperQueuedNodeFrame
    extends MapperNodeFrame {
        public MapperQueuedNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
            super(node, parent);
        }

        @Override
        public void doWork() {
            MapperResultFrame aggregator;
            TreeMapperCallback translation = SQLQueryTreeMapper.this.translations.get(this.node.getNodeName());
            MapperResultFrame mapperResultFrame = aggregator = translation == null ? this.parent : new MapperDataPendingNodeFrame(this.node, this.parent, translation);
            if (translation != null) {
                SQLQueryTreeMapper.this.stack.push(aggregator);
            }
            List children = this.node.findNonErrorChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                if (SQLQueryTreeMapper.this.transparentNodeNames.contains(this.node.getNodeName())) {
                    SQLQueryTreeMapper.this.stack.push(new MapperQueuedNodeFrame((STMTreeNode)children.get(i), aggregator));
                }
                --i;
            }
        }
    }

    private static interface MapperResultFrame<T>
    extends MapperFrame {
        public void aggregate(@NotNull T var1);
    }

    private class MapperRootFrame
    implements MapperResultFrame<T> {
        @NotNull
        public final STMTreeNode node;
        @Nullable
        public T result = null;

        public MapperRootFrame(STMTreeNode node) {
            this.node = node;
        }

        @Override
        public void aggregate(@NotNull T result) {
            this.result = result;
        }

        @Override
        public void doWork() {
            SQLQueryTreeMapper.this.stack.push(new MapperQueuedNodeFrame(this.node, this));
        }
    }

    @FunctionalInterface
    protected static interface TreeMapperCallback<T, C> {
        public T apply(STMTreeNode var1, List<T> var2, C var3);
    }
}

