/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.sqlworkbench;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.sqlworkbench.ConfigImportWizardSqlWorkbench;
import org.jkiss.dbeaver.ui.config.migration.wizards.sqlworkbench.SqlWorkbenchImportConfigurationService;

public class ConfigImportWizardPageSqlWorkbenchConnections
extends ConfigImportWizardPage {
    private static final Log log = Log.getLog(ConfigImportWizardPageSqlWorkbenchConnections.class);
    private final SqlWorkbenchImportConfigurationService sqlWorkbenchImportConfigurationService = SqlWorkbenchImportConfigurationService.INSTANCE;

    protected ConfigImportWizardPageSqlWorkbenchConnections() {
        super(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setTitle(ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.setDescription(ImportConfigMessages.config_import_wizard_header_import_configuration);
    }

    @Override
    protected void loadConnections(@NotNull ImportData importData) throws DBException {
        this.setErrorMessage(null);
        ConfigImportWizardSqlWorkbench wizard = (ConfigImportWizardSqlWorkbench)this.getWizard();
        File inputFile = wizard.getInputFile();
        try (FileInputStream is = new FileInputStream(inputFile);
             InputStreamReader reader = new InputStreamReader(is);){
            this.sqlWorkbenchImportConfigurationService.importXML(importData, reader);
        }
        catch (Exception e) {
            log.warn((Object)"Exception during loading connections", (Throwable)e);
            this.setErrorMessage(e.getMessage());
        }
    }
}

