/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.internal.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerExecutePlan;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerLongOp;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerSession;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSessionDetails;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetails;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetailsProvider;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class OracleServerSessionManager
implements DBAServerSessionManager<OracleServerSession>,
DBAServerSessionManagerSQL,
DBAServerSessionDetailsProvider {
    public static final String PROP_KILL_SESSION = "killSession";
    public static final String PROP_IMMEDIATE = "immediate";
    public static final String OPTION_SHOW_BACKGROUND = "showBackground";
    public static final String OPTION_SHOW_INACTIVE = "showInactive";
    private final OracleDataSource dataSource;

    public OracleServerSessionManager(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<OracleServerSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
            ArrayList<OracleServerSession> arrayList;
            block15: {
                JDBCResultSet dbResult = dbStat.executeQuery();
                try {
                    ArrayList<OracleServerSession> sessions = new ArrayList<OracleServerSession>();
                    while (dbResult.next()) {
                        sessions.add(new OracleServerSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block15;
                }
                catch (Throwable throwable) {
                    if (dbResult != null) {
                        try {
                            dbResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbResult.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String sessionId, @NotNull Map<String, Object> options) throws DBException {
        boolean toKill = Boolean.TRUE.equals(options.get(PROP_KILL_SESSION));
        boolean immediate = Boolean.TRUE.equals(options.get(PROP_IMMEDIATE));
        try {
            StringBuilder sql = new StringBuilder("ALTER SYSTEM ");
            if (toKill) {
                sql.append("KILL SESSION ");
            } else {
                sql.append("DISCONNECT SESSION ");
            }
            sql.append("'").append(sessionId).append("'");
            if (immediate) {
                sql.append(" IMMEDIATE");
            } else if (!toKill) {
                sql.append(" POST_TRANSACTION");
            }
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql.toString());){
                dbStat.execute();
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of(PROP_KILL_SESSION, true);
    }

    @NotNull
    public List<DBAServerSessionDetails> getSessionDetails() {
        ArrayList<DBAServerSessionDetails> extDetails = new ArrayList<DBAServerSessionDetails>();
        extDetails.add((DBAServerSessionDetails)new AbstractServerSessionDetails(this, OracleMessages.oracle_server_session_manager_details_name, OracleMessages.oracle_server_session_manager_details_description, (DBPImage)DBIcon.TYPE_DATETIME){

            /*
             * Enabled aggressive exception aggregation
             */
            public List<OracleServerLongOp> getSessionDetails(@NotNull DBCSession session, @NotNull DBAServerSession serverSession) throws DBException {
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT * FROM GV$SESSION_LONGOPS WHERE INST_ID=? AND SID=? AND SERIAL#=?");){
                    ArrayList<OracleServerLongOp> arrayList;
                    block15: {
                        dbStat.setLong(1, ((OracleServerSession)serverSession).getInstId());
                        dbStat.setLong(2, ((OracleServerSession)serverSession).getSid());
                        dbStat.setLong(3, ((OracleServerSession)serverSession).getSerial());
                        JDBCResultSet dbResult = dbStat.executeQuery();
                        try {
                            ArrayList<OracleServerLongOp> longOps = new ArrayList<OracleServerLongOp>();
                            while (dbResult.next()) {
                                longOps.add(new OracleServerLongOp((ResultSet)dbResult));
                            }
                            arrayList = longOps;
                            if (dbResult == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (dbResult != null) {
                                try {
                                    dbResult.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        dbResult.close();
                    }
                    return arrayList;
                }
                catch (SQLException e) {
                    throw new DBDatabaseException((Throwable)e, session.getDataSource());
                }
            }

            public Class<? extends DBPObject> getDetailsType() {
                return OracleServerLongOp.class;
            }
        });
        extDetails.add((DBAServerSessionDetails)new AbstractServerSessionDetails(this, OracleMessages.oracle_server_session_manager_display_exec_plan_name, OracleMessages.oracle_server_session_manager_display_exec_plan_description, (DBPImage)DBIcon.TYPE_TEXT){

            /*
             * Enabled aggressive exception aggregation
             */
            public List<OracleServerExecutePlan> getSessionDetails(@NotNull DBCSession session, @NotNull DBAServerSession serverSession) throws DBException {
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT PLAN_TABLE_OUTPUT FROM TABLE(dbms_xplan.display_cursor(sql_id => ?, cursor_child_no => ?))");){
                    ArrayList<OracleServerExecutePlan> arrayList;
                    block15: {
                        dbStat.setString(1, ((OracleServerSession)serverSession).getSqlId());
                        dbStat.setLong(2, ((OracleServerSession)serverSession).getSqlChildNumber());
                        JDBCResultSet dbResult = dbStat.executeQuery();
                        try {
                            ArrayList<OracleServerExecutePlan> planItems = new ArrayList<OracleServerExecutePlan>();
                            while (dbResult.next()) {
                                planItems.add(new OracleServerExecutePlan((ResultSet)dbResult));
                            }
                            arrayList = planItems;
                            if (dbResult == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (dbResult != null) {
                                try {
                                    dbResult.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        dbResult.close();
                    }
                    return arrayList;
                }
                catch (SQLException e) {
                    throw new DBDatabaseException((Throwable)e, session.getDataSource());
                }
            }

            public Class<? extends DBPObject> getDetailsType() {
                return OracleServerExecutePlan.class;
            }
        });
        return extDetails;
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        boolean atLeastV11 = this.dataSource.isAtLeastV11();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT s.*, ");
        if (atLeastV11) {
            sql.append("(SELECT SQL_FULLTEXT FROM gv$sql vsql\nWHERE s.sql_address = vsql.address(+) AND s.sql_hash_value = vsql.hash_value(+)\nAND s.sql_child_number = vsql.child_number (+)) as  SQL_FULLTEXT, ");
        } else {
            sql.append("sq.SQL_TEXT AS SQL_FULLTEXT, ");
        }
        sql.append("io.*\nFROM GV$SESSION s, gv$sql sq, gv$sess_io io\nWHERE s.sql_address = sq.address(+)\n AND s.sql_hash_value = sq.hash_value(+) AND s.sid = io.sid(+) AND s.inst_id = io.inst_id(+)");
        if (atLeastV11) {
            sql.append(" AND s.sql_child_number = sq.child_number (+)");
        }
        if (!CommonUtils.getOption(options, (String)OPTION_SHOW_BACKGROUND)) {
            sql.append(" AND s.TYPE = 'USER'");
        }
        if (!CommonUtils.getOption(options, (String)OPTION_SHOW_INACTIVE)) {
            sql.append(" AND s.STATUS <> 'INACTIVE'");
        }
        return sql.toString();
    }
}

