/* foundry-language.h
 *
 * Copyright 2025 Christian Hergert
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gio/gio.h>

#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_LANGUAGE (foundry_language_get_type())

FOUNDRY_AVAILABLE_IN_ALL
G_DECLARE_FINAL_TYPE (FoundryLanguage, foundry_language, FOUNDRY, LANGUAGE, GObject)

FOUNDRY_AVAILABLE_IN_ALL
GListModel      *foundry_language_list_all     (void);
FOUNDRY_AVAILABLE_IN_ALL
FoundryLanguage *foundry_language_find         (const char            *id);
FOUNDRY_AVAILABLE_IN_ALL
FoundryLanguage *foundry_language_new          (const char            *id,
                                                const char            *name,
                                                const char            *meson_id);
FOUNDRY_AVAILABLE_IN_ALL
const char      *foundry_language_get_id       (FoundryLanguage       *self);
FOUNDRY_AVAILABLE_IN_ALL
const char      *foundry_language_get_meson_id (FoundryLanguage       *self);
FOUNDRY_AVAILABLE_IN_ALL
const char      *foundry_language_get_name     (FoundryLanguage       *self);
FOUNDRY_AVAILABLE_IN_ALL
gboolean         foundry_language_equal        (const FoundryLanguage *self,
                                                const FoundryLanguage *other);
FOUNDRY_AVAILABLE_IN_ALL
guint            foundry_language_hash         (const FoundryLanguage *self);

G_END_DECLS
