/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.jit.JitConfiguration;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.PcodeOp;

public class JitAnalysisContext {
    private final JitConfiguration config;
    private final JitPassage passage;
    private final SleighLanguage language;
    private final Endian endian;

    public JitAnalysisContext(JitConfiguration config, JitPassage passage) {
        this.config = config;
        this.passage = passage;
        this.language = passage.getLanguage();
        this.endian = this.language.isBigEndian() ? Endian.BIG : Endian.LITTLE;
    }

    public JitConfiguration getConfiguration() {
        return this.config;
    }

    public JitPassage getPassage() {
        return this.passage;
    }

    public SleighLanguage getLanguage() {
        return this.language;
    }

    public Endian getEndian() {
        return this.endian;
    }

    public JitPassage.AddrCtx getOpEntry(PcodeOp op) {
        return this.passage.getOpEntry(op);
    }

    public String getErrorMessage(PcodeOp op) {
        return this.passage.getErrorMessage(op);
    }
}

