/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.IntWriteGen;
import ghidra.pcode.emu.jit.gen.type.MpTypedAccessGen;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.MethodVisitor;

public enum MpIntWriteGen implements MpTypedAccessGen
{
    BE{

        @Override
        public IntWriteGen getLegGen() {
            return IntWriteGen.BE;
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            IntWriteGen legGen = this.getLegGen();
            AddressSpace space = vn.getAddress().getAddressSpace();
            int countFull = vn.getSize() / 4;
            int remSize = vn.getSize() % 4;
            long offset = vn.getOffset() + (long)vn.getSize();
            for (int i = 0; i < countFull; ++i) {
                long block = (offset -= 4L) / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, 4, rv);
            }
            if (remSize > 0) {
                long block = (offset -= (long)remSize) / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, remSize, rv);
            }
        }
    }
    ,
    LE{

        @Override
        public IntWriteGen getLegGen() {
            return IntWriteGen.LE;
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            IntWriteGen legGen = this.getLegGen();
            AddressSpace space = vn.getAddress().getAddressSpace();
            int countFull = vn.getSize() / 4;
            int remSize = vn.getSize() % 4;
            long offset = vn.getOffset();
            for (int i = 0; i < countFull; ++i) {
                long block = offset / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, 4, rv);
                offset += 4L;
            }
            if (remSize > 0) {
                long block = offset / 4096L * 4096L;
                int off = (int)(offset - block);
                legGen.generateMpCodeLeg(gen, space, block, off, remSize, rv);
                offset += (long)remSize;
            }
        }
    };


    @Override
    public abstract IntWriteGen getLegGen();
}

