/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.app.plugin.core.progmgr.AbstractUndoRedoAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.List;

public class UndoAction
extends AbstractUndoRedoAction {
    public static final String SUBGROUP = "1Undo";

    public UndoAction(ProgramManagerPlugin plugin, PluginTool tool) {
        super(tool, plugin, "Undo", "icon.undo", "ctrl Z", SUBGROUP);
    }

    @Override
    protected void doAction(Program program, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            program.undo();
        }
    }

    @Override
    protected boolean canPerformAction(Program program) {
        return program != null && program.canUndo();
    }

    @Override
    protected String getUndoRedoDescription(Program program) {
        return program.getUndoName();
    }

    @Override
    protected List<String> getDescriptions(Program program) {
        return program.getAllUndoNames();
    }
}

