/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.asd;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.MacException;
import ghidra.app.util.bin.format.macos.asd.EntryDescriptor;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AppleSingleDouble
implements StructConverter {
    public static final int SINGLE_MAGIC_NUMBER = 333312;
    public static final int DOUBLE_MAGIC_NUMBER = 333319;
    private static final int FILLER_LEN = 16;
    private int magicNumber;
    private int versionNumber;
    private byte[] filler;
    private short numberOfEntries;
    private List<EntryDescriptor> entryList = new ArrayList<EntryDescriptor>();

    public AppleSingleDouble(ByteProvider provider) throws IOException, MacException {
        BinaryReader reader = new BinaryReader(provider, false);
        this.magicNumber = reader.readNextInt();
        if (this.magicNumber != 333312 && this.magicNumber != 333319) {
            throw new MacException("Invalid Apple Single/Double file");
        }
        this.versionNumber = reader.readNextInt();
        this.filler = reader.readNextByteArray(16);
        this.numberOfEntries = reader.readNextShort();
        for (int i = 0; i < this.numberOfEntries; ++i) {
            this.entryList.add(new EntryDescriptor(reader));
        }
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public byte[] getFiller() {
        return this.filler;
    }

    public short getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public List<EntryDescriptor> getEntryList() {
        return this.entryList;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(AppleSingleDouble.class);
        StructureDataType struct = new StructureDataType(name, 0);
        struct.add(DWORD, "magicNumber", null);
        struct.add(DWORD, "versionNumber", null);
        struct.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "filler", null);
        struct.add(WORD, "numberOfEntries", null);
        return struct;
    }
}

