/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.LayoutLockedFieldPanelCoordinator;
import docking.widgets.fieldpanel.internal.LineLockedFieldPanelCoordinator;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.util.viewer.listingpanel.ProgramLocationTranslator;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.features.base.codecompare.listing.ListingDisplay;
import ghidra.program.model.address.Address;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Duo;
import java.math.BigInteger;

public class ListingCoordinator {
    private Duo<ListingDisplay> displays;
    private Duo<Address> lockLineAddresses = new Duo();
    private ProgramLocationTranslator locationTranslator;
    private LineLockedFieldPanelCoordinator viewCoordinator;

    ListingCoordinator(Duo<ListingDisplay> displays, ListingAddressCorrelation correlator) {
        this.displays = displays;
        this.locationTranslator = new ProgramLocationTranslator(correlator);
        FieldPanel left = ((ListingDisplay)displays.get(Duo.Side.LEFT)).getListingPanel().getFieldPanel();
        FieldPanel right = ((ListingDisplay)displays.get(Duo.Side.RIGHT)).getListingPanel().getFieldPanel();
        this.viewCoordinator = new LayoutLockedFieldPanelCoordinator(new FieldPanel[]{left, right});
    }

    void setLocation(Duo.Side side, ProgramLocation location) {
        Duo.Side otherSide = side.otherSide();
        ProgramLocation otherLocation = this.locationTranslator.getProgramLocation(otherSide, location);
        if (otherLocation != null) {
            this.updateViewCoordinator(side, location, otherLocation);
            ((ListingDisplay)this.displays.get(otherSide)).goTo(otherLocation);
            ((ListingDisplay)this.displays.get(side.otherSide())).updateCursorMarkers(otherLocation);
        }
    }

    void dispose() {
        this.viewCoordinator.dispose();
    }

    void sync(Duo.Side side) {
        this.adjustFieldPanel(((ListingDisplay)this.displays.get(side)).getListingPanel().getFieldPanel());
        ProgramLocation programLocation = ((ListingDisplay)this.displays.get(side)).getProgramLocation();
        if (programLocation != null) {
            this.setLocation(side, programLocation);
        }
    }

    private void adjustFieldPanel(FieldPanel fieldPanel) {
        ViewerPosition viewerPosition = fieldPanel.getViewerPosition();
        BigInteger topIndex = viewerPosition.getIndex();
        int topXOffset = viewerPosition.getXOffset();
        int topYOffset = viewerPosition.getYOffset();
        this.viewCoordinator.viewChanged(fieldPanel, topIndex, topXOffset, topYOffset);
    }

    private void setLockedAddresses(Address leftAddress, Address rightAddress) {
        if (leftAddress == null || rightAddress == null) {
            return;
        }
        this.lockLineAddresses = new Duo((Object)leftAddress, (Object)rightAddress);
        AddressIndexMap leftMap = ((ListingDisplay)this.displays.get(Duo.Side.LEFT)).getListingPanel().getAddressIndexMap();
        AddressIndexMap rightMap = ((ListingDisplay)this.displays.get(Duo.Side.RIGHT)).getListingPanel().getAddressIndexMap();
        BigInteger leftIndex = leftMap.getIndex(leftAddress);
        BigInteger rightIndex = rightMap.getIndex(rightAddress);
        this.viewCoordinator.lockLines(new BigInteger[]{leftIndex, rightIndex});
    }

    private void updateViewCoordinator(Duo.Side side, ProgramLocation location, ProgramLocation otherLocation) {
        Address leftAddress = side == Duo.Side.LEFT ? location.getAddress() : otherLocation.getAddress();
        Address rightAddress = side == Duo.Side.LEFT ? otherLocation.getAddress() : location.getAddress();
        this.setLockedAddresses(leftAddress, rightAddress);
        FieldPanel fp = ((ListingDisplay)this.displays.get(side)).getListingPanel().getFieldPanel();
        this.adjustFieldPanel(fp);
    }
}

