/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.math.BigInteger;

public class OffsetShiftSettingsDefinition
implements NumberSettingsDefinition,
TypeDefSettingsDefinition {
    private static final String OFFSET_SHIFT_SETTING_NAME = "offset_shift";
    private static final String DESCRIPTION = "Identifies bit-shift to be applied to a stored pointer offset (+left/-right)";
    private static final String DISPLAY_NAME = "Offset Shift";
    private static BigInteger MAX_VALUE = BigInteger.valueOf(64L);
    private static final int DEFAULT = 0;
    public static final OffsetShiftSettingsDefinition DEF = new OffsetShiftSettingsDefinition();

    private OffsetShiftSettingsDefinition() {
    }

    public BigInteger getMaxValue() {
        return MAX_VALUE;
    }

    public boolean allowNegativeValue() {
        return true;
    }

    public boolean isHexModePreferred() {
        return false;
    }

    public long getValue(Settings settings) {
        if (settings == null) {
            return 0L;
        }
        Long value = settings.getLong(OFFSET_SHIFT_SETTING_NAME);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void setValue(Settings settings, long value) {
        if (value == 0L) {
            settings.clearSetting(OFFSET_SHIFT_SETTING_NAME);
        } else {
            settings.setLong(OFFSET_SHIFT_SETTING_NAME, value);
        }
    }

    public boolean hasValue(Settings settings) {
        return this.getValue(settings) != 0L;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return OFFSET_SHIFT_SETTING_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void clear(Settings settings) {
        settings.clearSetting(OFFSET_SHIFT_SETTING_NAME);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        Long value = srcSettings.getLong(OFFSET_SHIFT_SETTING_NAME);
        if (value == null) {
            destSettings.clearSetting(OFFSET_SHIFT_SETTING_NAME);
        } else {
            destSettings.setLong(OFFSET_SHIFT_SETTING_NAME, value.longValue());
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        if (this.hasValue(settings)) {
            long shift = this.getValue(settings);
            return "shift(" + Long.toString(shift) + ")";
        }
        return null;
    }
}

