/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.ArchitectureBSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.features.bsim.gui.filters.BlankBSimFilterType;
import ghidra.features.bsim.gui.filters.CompilerBSimFilterType;
import ghidra.features.bsim.gui.filters.DateEarlierBSimFilterType;
import ghidra.features.bsim.gui.filters.DateLaterBSimFilterType;
import ghidra.features.bsim.gui.filters.ExecutableCategoryBSimFilterType;
import ghidra.features.bsim.gui.filters.ExecutableNameBSimFilterType;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.gui.filters.HasNamedChildBSimFilterType;
import ghidra.features.bsim.gui.filters.Md5BSimFilterType;
import ghidra.features.bsim.gui.filters.NotArchitectureBSimFilterType;
import ghidra.features.bsim.gui.filters.NotCompilerBSimFilterType;
import ghidra.features.bsim.gui.filters.NotExecutableCategoryBSimFilterType;
import ghidra.features.bsim.gui.filters.NotExecutableNameBSimFilterType;
import ghidra.features.bsim.gui.filters.NotMd5BSimFilterType;
import ghidra.features.bsim.gui.filters.PathStartsBSimFilterType;
import ghidra.features.bsim.gui.filters.StringBSimValueEditor;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.xml.XmlElement;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import utility.function.Callback;

public abstract class BSimFilterType
implements Comparable<BSimFilterType> {
    private static List<BSimFilterType> basis = null;
    public static BSimFilterType BLANK = new BlankBSimFilterType();
    protected String label;
    protected String xmlval;
    protected String hint;

    public BSimFilterType(String label, String xmlval, String hint) {
        this.label = label;
        this.xmlval = xmlval;
        this.hint = hint;
    }

    public String toString() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BSimFilterType other = (BSimFilterType)obj;
        return Objects.equals(this.hint, other.hint) && Objects.equals(this.label, other.label) && Objects.equals(this.xmlval, other.xmlval);
    }

    @Override
    public int compareTo(BSimFilterType op2) {
        return this.label.compareTo(op2.label);
    }

    public String getXmlValue() {
        return this.xmlval;
    }

    public String getHint() {
        return this.hint;
    }

    public boolean isChildFilter() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isMultipleEntryAllowed() {
        return true;
    }

    public boolean orMultipleEntries() {
        return true;
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append(" type=\"").append(this.xmlval).append('\"');
    }

    public abstract IDSQLResolution generateIDSQLResolution(FilterAtom var1);

    public IDElasticResolution generateIDElasticResolution(FilterAtom atom) {
        return null;
    }

    public abstract void gatherSQLEffect(SQLEffects var1, FilterAtom var2, IDSQLResolution var3) throws SQLException;

    public abstract void gatherElasticEffect(ElasticEffects var1, FilterAtom var2, IDElasticResolution var3) throws ElasticException;

    public String buildSQLCombinedClause(List<String> subClauses) {
        String appender = this.orMultipleEntries() ? " OR " : " AND ";
        StringBuilder orClause = new StringBuilder();
        orClause.append('(');
        boolean printAppender = false;
        for (String str : subClauses) {
            if (printAppender) {
                orClause.append(appender);
            }
            orClause.append(str);
            printAppender = true;
        }
        orClause.append(')');
        return orClause.toString();
    }

    public String buildElasticCombinedClause(List<String> subClauses) {
        String appender = this.orMultipleEntries() ? " || " : " && ";
        StringBuilder clause = new StringBuilder();
        clause.append('(');
        boolean printAppender = false;
        for (String str : subClauses) {
            if (printAppender) {
                clause.append(appender);
            }
            clause.append(str);
            printAppender = true;
        }
        clause.append(')');
        return clause.toString();
    }

    public BSimValueEditor getEditor(List<String> initialValues, Callback listener) {
        return new StringBSimValueEditor(this, initialValues, listener);
    }

    public abstract boolean evaluate(ExecutableRecord var1, String var2);

    public boolean isValidValue(String value) {
        return value != null && !value.isBlank();
    }

    public String normalizeValue(String value) {
        return value.trim();
    }

    public static BSimFilterType getBlank() {
        BSimFilterType.buildFilterBasis();
        return basis.get(0);
    }

    public static List<BSimFilterType> getBaseFilters() {
        BSimFilterType.buildFilterBasis();
        return basis;
    }

    public static BSimFilterType nameToType(XmlElement el) {
        String subattr;
        String attr = el.getAttribute("type");
        BSimFilterType.buildFilterBasis();
        for (BSimFilterType cur : basis) {
            if (!cur.xmlval.equals(attr)) continue;
            return cur;
        }
        if (attr.equals("nameequals")) {
            subattr = el.getAttribute("subtype");
            return new ExecutableCategoryBSimFilterType(subattr);
        }
        if (attr.equals("execatnomatch")) {
            subattr = el.getAttribute("subtype");
            return new NotExecutableCategoryBSimFilterType(subattr);
        }
        if (attr.equals("functiontag")) {
            String tagName = el.getAttribute("tagname");
            int flag = Integer.decode(el.getAttribute("flag"));
            return new FunctionTagBSimFilterType(tagName, flag);
        }
        return basis.get(0);
    }

    private static void buildFilterBasis() {
        if (basis != null) {
            return;
        }
        basis = new ArrayList<BSimFilterType>();
        basis.add(new BlankBSimFilterType());
        basis.add(new ExecutableNameBSimFilterType());
        basis.add(new NotExecutableNameBSimFilterType());
        basis.add(new Md5BSimFilterType());
        basis.add(new NotMd5BSimFilterType());
        basis.add(new ArchitectureBSimFilterType());
        basis.add(new NotArchitectureBSimFilterType());
        basis.add(new CompilerBSimFilterType());
        basis.add(new NotCompilerBSimFilterType());
        basis.add(new PathStartsBSimFilterType());
        basis.add(new HasNamedChildBSimFilterType());
    }

    public static List<BSimFilterType> generateBsimFilters(DatabaseInformation info, boolean includeChildFilter) {
        ArrayList<BSimFilterType> resFilters = new ArrayList<BSimFilterType>();
        BSimFilterType.buildFilterBasis();
        for (BSimFilterType template : basis) {
            if (template.isChildFilter() && (!includeChildFilter || info != null && !info.trackcallgraph)) continue;
            resFilters.add(template);
        }
        if (info != null && info.dateColumnName != null && !info.dateColumnName.isEmpty()) {
            DateEarlierBSimFilterType earlierTemplate = new DateEarlierBSimFilterType(info.dateColumnName);
            DateLaterBSimFilterType laterTemplate = new DateLaterBSimFilterType(info.dateColumnName);
            resFilters.add(earlierTemplate);
            resFilters.add(laterTemplate);
        } else {
            DateEarlierBSimFilterType filt = new DateEarlierBSimFilterType("Ingest Date");
            resFilters.add(filt);
            DateLaterBSimFilterType filt2 = new DateLaterBSimFilterType("Ingest Date");
            resFilters.add(filt2);
        }
        if (info != null && info.execats != null) {
            for (String element : info.execats) {
                ExecutableCategoryBSimFilterType filt = new ExecutableCategoryBSimFilterType(element);
                resFilters.add(filt);
                NotExecutableCategoryBSimFilterType filt2 = new NotExecutableCategoryBSimFilterType(element);
                resFilters.add(filt2);
            }
        }
        FunctionTagBSimFilterType filtFuncTag = new FunctionTagBSimFilterType("KNOWN_LIBRARY", FunctionTagBSimFilterType.KNOWN_LIBRARY_MASK);
        resFilters.add(filtFuncTag);
        filtFuncTag = new FunctionTagBSimFilterType("HAS_UNIMPLEMENTED", FunctionTagBSimFilterType.HAS_UNIMPLEMENTED_MASK);
        resFilters.add(filtFuncTag);
        filtFuncTag = new FunctionTagBSimFilterType("HAS_BADDATA", FunctionTagBSimFilterType.HAS_BADDATA_MASK);
        resFilters.add(filtFuncTag);
        if (info != null && info.functionTags != null) {
            int flag = 1;
            flag <<= FunctionTagBSimFilterType.RESERVED_BITS;
            for (String element : info.functionTags) {
                filtFuncTag = new FunctionTagBSimFilterType(element, flag);
                resFilters.add(filtFuncTag);
                flag <<= 1;
            }
        }
        return resFilters;
    }

    public String getLabel() {
        return this.label;
    }
}

