/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticDatabase;
import ghidra.features.bsim.query.elastic.ElasticException;

public abstract class IDElasticResolution {
    public String idString;

    public abstract void resolve(ElasticDatabase var1, ExecutableRecord var2) throws ElasticException;

    public static class ExternalFunction
    extends IDElasticResolution {
        private String exeName;
        private String funcName;

        public ExternalFunction(String exe, String func) {
            this.exeName = exe;
            this.funcName = func;
            this.idString = null;
        }

        @Override
        public void resolve(ElasticDatabase database, ExecutableRecord exe) throws ElasticException {
            if (this.idString == null) {
                this.idString = database.recoverExternalFunctionId(this.exeName, this.funcName, exe.getArchitecture());
            }
        }
    }
}

