/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.v1.FBPKv1;
import ghidra.file.formats.android.fbpk.v2.FBPKv2;
import java.io.IOException;

public class FBPK_Factory {
    public static final FBPK getFBPK(BinaryReader reader) throws IOException {
        if (reader.length() > 8L) {
            int magic = reader.readInt(0L);
            int version = reader.readInt(4L);
            if (magic == 1263551046) {
                switch (version) {
                    case 1: {
                        return new FBPKv1(reader);
                    }
                    case 2: {
                        return new FBPKv2(reader);
                    }
                }
            }
            throw new IOException("Unsupported FBPK version: " + version);
        }
        throw new IOException("Invalid FBPK file");
    }
}

