/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import java.util.Arrays;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class Asm2Dex {
    public static Object convertConstantValue(Object ele) {
        if (ele instanceof Type) {
            Type type = (Type)ele;
            if (type.getSort() == 11) {
                return new Proto(Asm2Dex.toDescArray(type.getArgumentTypes()), type.getReturnType().getDescriptor());
            }
            return new DexType(type.getDescriptor());
        }
        if (ele instanceof Handle) {
            return Asm2Dex.toMethodHandle((Handle)ele);
        }
        return ele;
    }

    public static Object[] convertConstObjects(Object[] bsmArgs) {
        if (bsmArgs == null) {
            return null;
        }
        Object[] copy = Arrays.copyOf(bsmArgs, bsmArgs.length);
        for (int i = 0; i < copy.length; ++i) {
            Object ele = copy[i];
            copy[i] = ele = Asm2Dex.convertConstantValue(ele);
        }
        return copy;
    }

    public static Proto toMethodType(String desc) {
        return new Proto(Asm2Dex.toDescArray(Type.getArgumentTypes((String)desc)), Type.getReturnType((String)desc).getDescriptor());
    }

    public static MethodHandle toMethodHandle(Handle bsm) {
        switch (bsm.getTag()) {
            case 1: {
                return new MethodHandle(3, Asm2Dex.toField(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 2: {
                return new MethodHandle(1, Asm2Dex.toField(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 3: {
                return new MethodHandle(2, Asm2Dex.toField(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 4: {
                return new MethodHandle(0, Asm2Dex.toField(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 5: {
                return new MethodHandle(5, Asm2Dex.toMethod(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 6: {
                return new MethodHandle(4, Asm2Dex.toMethod(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 7: {
                return new MethodHandle(7, Asm2Dex.toMethod(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 8: {
                return new MethodHandle(6, Asm2Dex.toMethod(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
            case 9: {
                return new MethodHandle(8, Asm2Dex.toMethod(bsm.getOwner(), bsm.getName(), bsm.getDesc()));
            }
        }
        throw new RuntimeException("Not supported yet.");
    }

    private static Method toMethod(String internalName, String name, String desc) {
        return new Method("L" + internalName + ";", name, Asm2Dex.toMethodType(desc));
    }

    private static Field toField(String internalName, String name, String desc) {
        return new Field("L" + internalName + ";", name, desc);
    }

    public static String[] toDescArray(Type[] ts) {
        String[] ds = new String[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            ds[i] = ts[i].getDescriptor();
        }
        return ds;
    }
}

