/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.debug.api.modules.MapEntry;
import ghidra.debug.api.modules.MapProposal;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractMapProposal<T, P, E extends MapEntry<T, P>>
implements MapProposal<T, P, E> {
    protected final Trace trace;
    protected final Program program;

    public AbstractMapProposal(Trace trace, Program program) {
        this.trace = trace;
        this.program = program;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Program getProgram() {
        return this.program;
    }

    protected static abstract class MatcherMap<K, T, P, M extends Matcher<T, P>> {
        protected final long snap;
        protected Map<K, Set<T>> fromsByJoin = new LinkedHashMap<K, Set<T>>();
        protected Map<T, M> map = new LinkedHashMap<T, M>();

        public MatcherMap(long snap) {
            this.snap = snap;
        }

        protected abstract M newMatcher(T var1, P var2);

        protected abstract K getFromJoinKey(T var1);

        protected abstract K getToJoinKey(P var1);

        protected void processFromObject(T fromObject) {
            this.fromsByJoin.computeIfAbsent(this.getFromJoinKey(fromObject), k -> new LinkedHashSet()).add(fromObject);
        }

        protected void processToObject(P toObject) {
            Set<T> froms = this.fromsByJoin.get(this.getToJoinKey(toObject));
            if (froms == null) {
                return;
            }
            for (T f : froms) {
                Matcher bestM = (Matcher)this.map.get(f);
                M candM = this.newMatcher(f, toObject);
                if (bestM != null && !(((Matcher)candM).score > bestM.score)) continue;
                this.map.put(f, candM);
            }
        }

        protected double averageScore() {
            return this.map.values().stream().reduce(0.0, (s, m) -> s + m.score, Double::sum) / (double)this.map.size();
        }

        protected <E> Map<T, E> computeMap(Function<M, E> newEntry) {
            return this.map.values().stream().filter(m -> m.fromObject != null && m.toObject != null).collect(Collectors.toMap(m -> m.fromObject, newEntry));
        }

        protected P getToObject(T fromObject) {
            Matcher m = (Matcher)this.map.get(fromObject);
            return m == null ? null : (P)m.toObject;
        }
    }

    protected static abstract class Matcher<T, P> {
        protected final T fromObject;
        protected final long snap;
        protected final P toObject;
        protected final AddressRange fromRange;
        protected final AddressRange toRange;
        protected final double score;

        protected Matcher(T fromObject, long snap, P toObject) {
            this.fromObject = fromObject;
            this.snap = snap;
            this.toObject = toObject;
            this.fromRange = fromObject == null ? null : this.getFromRange();
            this.toRange = toObject == null ? null : this.getToRange();
            this.score = fromObject == null || toObject == null ? 0.0 : this.computeScore();
        }

        protected abstract AddressRange getFromRange();

        protected abstract AddressRange getToRange();

        protected double computeScore() {
            return (double)this.computeKeyMatchScore() + this.computeLengthScore();
        }

        protected int computeKeyMatchScore() {
            return 3;
        }

        protected long shiftRight1RoundUp(long val) {
            if ((val & 1L) == 1L) {
                return (val >>> 1) + 1L;
            }
            return val >>> 1;
        }

        protected double computeLengthScore() {
            if (this.fromRange == null) {
                return 0.0;
            }
            long fLen = this.fromRange.getLength();
            long tLen = this.toRange.getLength();
            for (int bitsmatched = 64; bitsmatched > 0; --bitsmatched) {
                if (fLen == tLen) {
                    return (double)bitsmatched / 6.4;
                }
                fLen = this.shiftRight1RoundUp(fLen);
                tLen = this.shiftRight1RoundUp(tLen);
            }
            return 0.0;
        }
    }
}

