// Base URL for easier maintenance
const DOCS_BASE_URL = 'https://grafana.com/docs/grafana/latest';

// Alerting Rules
export const DOCS_URL_ALERT_RULE_TYPES = `${DOCS_BASE_URL}/alerting/fundamentals/alert-rules/alert-rule-types/`;
export const DOCS_URL_RULE_EVALUATION = `${DOCS_BASE_URL}/alerting/fundamentals/alert-rules/rule-evaluation/`;
export const DOCS_URL_STALE_ALERT_INSTANCES = `${DOCS_BASE_URL}/alerting/fundamentals/alert-rule-evaluation/stale-alert-instances/`;
export const DOCS_URL_NO_DATA_ERROR_HANDLING = `${DOCS_BASE_URL}/alerting/alerting-rules/create-grafana-managed-rule/#configure-no-data-and-error-handling`;
export const DOCS_URL_RECORDING_RULES = `${DOCS_BASE_URL}/alerting/alerting-rules/create-recording-rules/`;

// Labels and Annotations
export const DOCS_URL_ANNOTATION_LABEL = `${DOCS_BASE_URL}/alerting/fundamentals/alert-rules/annotation-label/`;
export const DOCS_URL_ANNOTATIONS = `${DOCS_BASE_URL}/alerting/fundamentals/alert-rules/annotation-label/#annotations`;

// Notifications
export const DOCS_URL_NOTIFICATIONS = `${DOCS_BASE_URL}/alerting/fundamentals/notifications/`;
export const DOCS_URL_NOTIFICATION_POLICIES = `${DOCS_BASE_URL}/alerting/fundamentals/notifications/notification-policies/`;
export const DOCS_URL_GROUP_ALERT_NOTIFICATIONS = `${DOCS_BASE_URL}/alerting/fundamentals/notifications/group-alert-notifications/`;
export const DOCS_URL_INHIBITION_RULES = `${DOCS_BASE_URL}/alerting/configure-notifications/create-silence/#inhibition-rules`;

// Templates
export const DOCS_URL_TEMPLATE_NOTIFICATIONS = `${DOCS_BASE_URL}/alerting/manage-notifications/template-notifications/`;
export const DOCS_URL_TEMPLATE_EXAMPLES = `${DOCS_BASE_URL}/alerting/configure-notifications/template-notifications/examples/`;

// Provisioning
export const DOCS_URL_PROVISION_ALERTING = `${DOCS_BASE_URL}/alerting/set-up/provision-alerting-resources/`;
export const DOCS_URL_FILE_PROVISIONING = `${DOCS_BASE_URL}/alerting/set-up/provision-alerting-resources/file-provisioning/`;
export const DOCS_URL_HTTP_API_PROVISIONING = `${DOCS_BASE_URL}/alerting/set-up/provision-alerting-resources/http-api-provisioning/`;
export const DOCS_URL_TERRAFORM_PROVISIONING = `${DOCS_BASE_URL}/alerting/set-up/provision-alerting-resources/terraform-provisioning/`;

// Migration
export const DOCS_URL_ALERTING_MIGRATION = `${DOCS_BASE_URL}/alerting/alerting-rules/alerting-migration/`;

// Data Sources
export const DOCS_URL_DATA_SOURCE_ALERTING = `${DOCS_BASE_URL}/alerting/fundamentals/data-source-alerting/`;

// Query and Transform
export const DOCS_URL_QUERY_TRANSFORM_DATA = `${DOCS_BASE_URL}/panels-visualizations/query-transform-data/`;

// Tutorials
export const TUTORIAL_URL_ALERTING_GET_STARTED = 'https://grafana.com/tutorials/alerting-get-started/';

// External (Mimir/Metrics Enterprise)
export const DOCS_URL_FEDERATED_RULES =
  'https://grafana.com/docs/metrics-enterprise/latest/tenant-management/tenant-federation/#cross-tenant-alerting-and-recording-rule-federation';

// External (Prometheus)
export const EXTERNAL_URL_PROMETHEUS_ALERTING_RULES =
  'https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/';
