/* SPDX-FileCopyrightText: 2003 - Paolo Maggi <paolo.maggi@polito.it>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <glib-object.h>
#include <gmodule.h>
#include <gtksourceview/gtksourcelanguage.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_LANGUAGE_MANAGER		(gtk_source_language_manager_get_type ())
#define GTK_SOURCE_LANGUAGE_MANAGER(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_SOURCE_TYPE_LANGUAGE_MANAGER, GtkSourceLanguageManager))
#define GTK_SOURCE_LANGUAGE_MANAGER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GTK_SOURCE_TYPE_LANGUAGE_MANAGER, GtkSourceLanguageManagerClass))
#define GTK_SOURCE_IS_LANGUAGE_MANAGER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_SOURCE_TYPE_LANGUAGE_MANAGER))
#define GTK_SOURCE_IS_LANGUAGE_MANAGER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_LANGUAGE_MANAGER))
#define GTK_SOURCE_LANGUAGE_MANAGER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GTK_SOURCE_TYPE_LANGUAGE_MANAGER, GtkSourceLanguageManagerClass))

typedef struct _GtkSourceLanguageManager         GtkSourceLanguageManager;
typedef struct _GtkSourceLanguageManagerClass    GtkSourceLanguageManagerClass;
typedef struct _GtkSourceLanguageManagerPrivate  GtkSourceLanguageManagerPrivate;

struct _GtkSourceLanguageManager
{
	GObject parent_instance;

	GtkSourceLanguageManagerPrivate *priv;
};

struct _GtkSourceLanguageManagerClass
{
	GObjectClass parent_class;

	/* Padding for future expansion */
	gpointer padding[1];
};

G_MODULE_EXPORT
GType			  gtk_source_language_manager_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceLanguageManager *gtk_source_language_manager_new			(void);

G_MODULE_EXPORT
GtkSourceLanguageManager *gtk_source_language_manager_get_default		(void);

G_MODULE_EXPORT
const gchar * const *	  gtk_source_language_manager_get_search_path		(GtkSourceLanguageManager *lm);

G_MODULE_EXPORT
void			  gtk_source_language_manager_set_search_path		(GtkSourceLanguageManager *lm,
										 gchar                   **dirs);

G_MODULE_EXPORT
const gchar * const *	  gtk_source_language_manager_get_language_ids		(GtkSourceLanguageManager *lm);

G_MODULE_EXPORT
GtkSourceLanguage	 *gtk_source_language_manager_get_language		(GtkSourceLanguageManager *lm,
										 const gchar              *id);

G_MODULE_EXPORT
GtkSourceLanguage	 *gtk_source_language_manager_guess_language		(GtkSourceLanguageManager *lm,
										 const gchar		  *filename,
										 const gchar		  *content_type);

G_GNUC_INTERNAL
GtkSourceLanguageManager *_gtk_source_language_manager_peek_default		(void);

G_END_DECLS
