"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3c_21--4079df"],{75724:(t,e,n)=>{n.d(e,{A:()=>l});var o=n(71354),a=n.n(o),r=n(76314),s=n.n(r)()(a());s.push([t.id,"\n#modal-inner[data-v-59cf91b8] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-59cf91b8] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-59cf91b8] {\n\tmin-height: 100px;\n}\nli[data-v-59cf91b8] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-59cf91b8]:hover, li[data-v-59cf91b8]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-59cf91b8] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-59cf91b8] {\n\tfloat: right;\n}\n.card-selector[data-v-59cf91b8] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AA+JA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<template>\n\t<NcModal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<NcSelect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@option:selected=\"fetchCardsFromBoard\">\n\t\t\t\t<template #selected-option=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template #option=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</NcSelect>\n\n\t\t\t<NcSelect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { NcModal, NcSelect } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t\tNcSelect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector:deep(.modal-container) {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},4417:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},96562:(e,n,o)=>{o.r(n),o.d(n,{default:()=>x});var a=o(63814),r=o(76333),s=o(66802);const l={name:"CardSelector",components:{NcModal:r.FH,NcSelect:r.EQ},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:()=>({boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}),computed:{isBoardAndStackChoosen(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount(){this.fetchBoards()},methods:{fetchBoards(){s.Ay.get((0,a.Jv)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},async fetchCardsFromBoard(t){try{this.cardsFromBoard=[];const e=(0,a.Jv)("/apps/deck/stacks/"+t.id);(await s.Ay.get(e)).data.forEach((t=>{this.cardsFromBoard.push(...t.cards)}))}catch(t){return t}},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedCard.id)}}};var d=o(85072),c=o.n(d),i=o(97825),A=o.n(i),p=o(77659),h=o.n(p),g=o(55056),N=o.n(g),u=o(10540),m=o.n(u),b=o(41113),C=o.n(b),v=o(75724),f={};f.styleTagTransform=C(),f.setAttributes=N(),f.insert=h().bind(null,"head"),f.domAPI=A(),f.insertStyleElement=m();c()(v.A,f);v.A&&v.A.locals&&v.A.locals;const x=(0,o(14486).A)(l,(function(){var t=this,e=t._self._c;return e("NcModal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{"option:selected":t.fetchCardsFromBoard},scopedSlots:t._u([{key:"selected-option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])]}}]),model:{value:t.selectedBoard,callback:function(e){t.selectedBoard=e},expression:"selectedBoard"}}),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(e){t.selectedCard=e},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"59cf91b8",null).exports},27518:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},27514:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},79722:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},86886:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},76333:(t,e,n)=>{n.d(e,{B6:()=>A.N,Bx:()=>T.N,EQ:()=>Lt.N,FH:()=>Ct.A,Ki:()=>d.A,Ko:()=>o.N,c:()=>O.A,g4:()=>Ht.g,ne:()=>bt.A,x1:()=>U.N,yI:()=>nt.A,z:()=>p.A});var o=n(950),a=n(85023),r=n(3877),s=n(66626),l=n(66078),d=n(57908),c=n(17728),i=n(59915),A=n(38583),p=n(24070),h=n(71711),g=n(13682),N=n(34014),u=n(47611),m=n(10363),b=n(38851),C=n(79138),v=n(66229),f=n(38282),x=n(80522),k=n(91658),S=n(58369),B=n(16932),w=n(87178),_=n(13214),y=n(38166),F=n(61154),L=n(65425),M=n(92630),E=n(50017),P=n(57229),I=n(748),D=n(70588),X=n(92324),T=n(91027),$=n(67409),G=n(14788),z=n(52275),U=n(94294),Y=n(1846),j=n(65377),H=n(97596),J=n(11692),Q=n(21913),W=n(45078),K=n(59364),q=n(44025),R=n(19303),O=n(48198),V=n(22925),Z=n(36631),tt=n(83194),et=n(63913),nt=n(42507),ot=n(83398),at=n(90578),rt=n(12486),st=n(13085),lt=n(64821),dt=n(79704),ct=n(30424),it=n(40468),At=n(51550),pt=n(30710),ht=n(44896),gt=n(48191),Nt=n(94157),ut=n(86095),mt=n(19607),bt=n(88289),Ct=n(99759),vt=n(371),ft=n(84810),xt=n(71912),kt=n(71797),St=n(2381),Bt=n(56002),wt=n(26065),_t=n(36079),yt=n(18725),Ft=(n(21777),n(66802),n(62044),n(52781),n(3168),n(38959)),Lt=n(55816),Mt=n(52697),Et=(n(61338),n(71639)),Pt=n(51018),It=n(24705),Dt=n(37047),Xt=n(93281),Tt=n(81507),$t=n(65114),Gt=n(8256),zt=n(17655),Ut=n(26631),Yt=n(7797),jt=n(23610),Ht=(n(55581),n(94205),n(95462),n(23020),n(53429),n(23739),n(16343),n(29928)),Jt=(n(12311),n(18547),n(42892)),Qt=n(65842),Wt=(n(77965),n(75105),n(92471),n(16406),n(33884));o.N,a.N,r.A,s.N,l.N,d.A,c.N,i.A,p.A,h.A,g.N,A.N,N.N,u.A,m.A,b.N,C.N,v.A,f.N,x.A,k.N,S.N,B.N,w.N,_.A,y.N,F.N,L.N,L.N,M.N,E.N,P.A,I.N,D.A,X.N,yt.N,T.N,$.N,G.N,z.N,U.N,Y.N,j.N,H.N,J.N,Q.N,W.N,K.N,q.N,R.default,O.A,V.N,Z.N,tt.A,et.N,nt.A,ot.N,at.N,rt.N,st.N,lt.N,dt.A,ct.N,it.N,At.N,pt.N,ht.N,gt.N,Nt.N,ut.N,mt.N,bt.A,_t.N,Ct.A,vt.A,ft.N,xt.N,kt.N,St.N,Bt.N,wt.N,yt.a,Ft.N,Et.N,Lt.N,Pt.N,It.N,Dt.N,Xt.N,Tt.N,$t.N,Mt.N,Gt.N,zt.N,Ut.N,Yt.N,jt.A,Symbol.toStringTag,Jt.A,Qt.A,Wt.yw,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3c_21--4079df.js.map?v=8e0fb92eab682e7a2e6f