/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.opensearch.sql.ast.analysis.FieldResolutionResult;
import org.opensearch.sql.ast.analysis.FieldResolutionVisitor;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.ExtendedRexBuilder;
import org.opensearch.sql.calcite.SysLimit;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.FunctionProperties;

public class CalcitePlanContext {
    public FrameworkConfig config;
    public final Connection connection;
    public final CalciteToolsHelper.OpenSearchRelBuilder relBuilder;
    public final ExtendedRexBuilder rexBuilder;
    public final FunctionProperties functionProperties;
    public final QueryType queryType;
    public final SysLimit sysLimit;
    public static final ThreadLocal<Boolean> skipEncoding = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Boolean> legacyPreferredFlag = ThreadLocal.withInitial(() -> true);
    private boolean isResolvingJoinCondition = false;
    private boolean isResolvingSubquery = false;
    private boolean inCoalesceFunction = false;
    private boolean isProjectVisited = false;
    private final Stack<RexCorrelVariable> correlVar = new Stack();
    private final Stack<List<RexNode>> windowPartitions = new Stack();
    public Map<String, RexLambdaRef> rexLambdaRefMap;
    private List<RexNode> capturedVariables;
    private boolean inLambdaContext = false;
    private UnresolvedPlan rootNode;

    private CalcitePlanContext(FrameworkConfig config, SysLimit sysLimit, QueryType queryType) {
        this.config = config;
        this.sysLimit = sysLimit;
        this.queryType = queryType;
        this.connection = CalciteToolsHelper.connect(config, (JavaTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY);
        this.relBuilder = CalciteToolsHelper.create(config, (JavaTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, this.connection);
        this.rexBuilder = new ExtendedRexBuilder(this.relBuilder.getRexBuilder());
        this.functionProperties = new FunctionProperties(QueryType.PPL);
        this.rexLambdaRefMap = new HashMap<String, RexLambdaRef>();
        this.capturedVariables = new ArrayList<RexNode>();
    }

    private CalcitePlanContext(CalcitePlanContext parent) {
        this.config = parent.config;
        this.sysLimit = parent.sysLimit;
        this.queryType = parent.queryType;
        this.connection = parent.connection;
        this.relBuilder = parent.relBuilder;
        this.rexBuilder = parent.rexBuilder;
        this.functionProperties = parent.functionProperties;
        this.rexLambdaRefMap = new HashMap<String, RexLambdaRef>();
        this.capturedVariables = new ArrayList<RexNode>();
        this.inLambdaContext = true;
    }

    public RexNode resolveJoinCondition(UnresolvedExpression expr, BiFunction<UnresolvedExpression, CalcitePlanContext, RexNode> transformFunction) {
        this.isResolvingJoinCondition = true;
        RexNode result = transformFunction.apply(expr, this);
        this.isResolvingJoinCondition = false;
        return result;
    }

    public Optional<RexCorrelVariable> popCorrelVar() {
        if (!this.correlVar.empty()) {
            return Optional.of(this.correlVar.pop());
        }
        return Optional.empty();
    }

    public void pushCorrelVar(RexCorrelVariable v) {
        this.correlVar.push(v);
    }

    public Optional<RexCorrelVariable> peekCorrelVar() {
        if (!this.correlVar.empty()) {
            return Optional.of(this.correlVar.peek());
        }
        return Optional.empty();
    }

    public CalcitePlanContext clone() {
        return new CalcitePlanContext(this);
    }

    public static CalcitePlanContext create(FrameworkConfig config, SysLimit sysLimit, QueryType queryType) {
        return new CalcitePlanContext(config, sysLimit, queryType);
    }

    public static void run(Runnable action, Settings settings) {
        Boolean preferred = (Boolean)settings.getSettingValue(Settings.Key.PPL_SYNTAX_LEGACY_PREFERRED);
        legacyPreferredFlag.set(preferred);
        try {
            action.run();
        }
        finally {
            legacyPreferredFlag.remove();
        }
    }

    public static boolean isLegacyPreferred() {
        return legacyPreferredFlag.get();
    }

    public void putRexLambdaRefMap(Map<String, RexLambdaRef> candidateMap) {
        this.rexLambdaRefMap.putAll(candidateMap);
    }

    public RexLambdaRef captureVariable(RexNode fieldRef, String fieldName) {
        for (int i = 0; i < this.capturedVariables.size(); ++i) {
            if (!this.capturedVariables.get(i).equals((Object)fieldRef)) continue;
            return this.rexLambdaRefMap.get("__captured_" + i);
        }
        int captureIndex = this.capturedVariables.size();
        this.capturedVariables.add(fieldRef);
        int lambdaParamCount = (int)this.rexLambdaRefMap.keySet().stream().filter(key -> !key.startsWith("__captured_")).count();
        RexLambdaRef lambdaRef = new RexLambdaRef(lambdaParamCount + captureIndex, fieldName, fieldRef.getType());
        this.rexLambdaRefMap.put("__captured_" + captureIndex, lambdaRef);
        return lambdaRef;
    }

    public FieldResolutionResult resolveFields(UnresolvedPlan target) {
        if (this.rootNode == null) {
            throw new IllegalStateException("Failed to resolve fields. Root node is not set.");
        }
        FieldResolutionVisitor visitor = new FieldResolutionVisitor();
        Map<UnresolvedPlan, FieldResolutionResult> result = visitor.analyze(this.rootNode);
        if (!result.containsKey(target)) {
            throw new IllegalStateException("Failed to resolve fields for node: " + target.toString());
        }
        return result.get(target);
    }

    @Generated
    public boolean isResolvingJoinCondition() {
        return this.isResolvingJoinCondition;
    }

    @Generated
    public void setResolvingJoinCondition(boolean isResolvingJoinCondition) {
        this.isResolvingJoinCondition = isResolvingJoinCondition;
    }

    @Generated
    public boolean isResolvingSubquery() {
        return this.isResolvingSubquery;
    }

    @Generated
    public void setResolvingSubquery(boolean isResolvingSubquery) {
        this.isResolvingSubquery = isResolvingSubquery;
    }

    @Generated
    public boolean isInCoalesceFunction() {
        return this.inCoalesceFunction;
    }

    @Generated
    public void setInCoalesceFunction(boolean inCoalesceFunction) {
        this.inCoalesceFunction = inCoalesceFunction;
    }

    @Generated
    public boolean isProjectVisited() {
        return this.isProjectVisited;
    }

    @Generated
    public void setProjectVisited(boolean isProjectVisited) {
        this.isProjectVisited = isProjectVisited;
    }

    @Generated
    public Map<String, RexLambdaRef> getRexLambdaRefMap() {
        return this.rexLambdaRefMap;
    }

    @Generated
    public List<RexNode> getCapturedVariables() {
        return this.capturedVariables;
    }

    @Generated
    public boolean isInLambdaContext() {
        return this.inLambdaContext;
    }

    @Generated
    public void setInLambdaContext(boolean inLambdaContext) {
        this.inLambdaContext = inLambdaContext;
    }

    @Generated
    public void setRootNode(UnresolvedPlan rootNode) {
        this.rootNode = rootNode;
    }
}

