/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.DelegatingMap;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultRegistry<K, V>
extends DelegatingMap<K, V, Map<K, V>>
implements Registry<K, V>,
Function<K, V> {
    private final String qualifiedKeyName;

    private static <K, V> Map<K, V> toMap(Collection<? extends V> values, Function<V, K> keyFn) {
        Assert.notNull(values, (String)"Collection of values may not be null.");
        Assert.notNull(keyFn, (String)"Key function cannot be null.");
        LinkedHashMap<Object, V> m = new LinkedHashMap<Object, V>(Collections.size(values));
        for (V value : values) {
            Object key = Assert.notNull(keyFn.apply(value), (String)"Key function cannot return a null value.");
            m.put(key, value);
        }
        return Collections.immutable(m);
    }

    public DefaultRegistry(String name, String keyName, Collection<? extends V> values, Function<V, K> keyFn) {
        super(DefaultRegistry.toMap(values, keyFn));
        name = (String)Assert.hasText((CharSequence)Strings.clean((String)name), (String)"name cannot be null or empty.");
        keyName = (String)Assert.hasText((CharSequence)Strings.clean((String)keyName), (String)"keyName cannot be null or empty.");
        this.qualifiedKeyName = name + " " + keyName;
    }

    @Override
    public V apply(K k) {
        return this.get(k);
    }

    public V forKey(K key) {
        Object value = this.get(key);
        if (value == null) {
            String msg = "Unrecognized " + this.qualifiedKeyName + ": " + key;
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    static <T> T immutable() {
        throw new UnsupportedOperationException("Registries are immutable and cannot be modified.");
    }

    @Override
    public V put(K key, V value) {
        return (V)DefaultRegistry.immutable();
    }

    @Override
    public V remove(Object key) {
        return (V)DefaultRegistry.immutable();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        DefaultRegistry.immutable();
    }

    @Override
    public void clear() {
        DefaultRegistry.immutable();
    }

    @Override
    public int hashCode() {
        return this.DELEGATE.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultRegistry) {
            DefaultRegistry other = (DefaultRegistry)obj;
            return this.qualifiedKeyName.equals(other.qualifiedKeyName) && this.DELEGATE.equals(other.DELEGATE);
        }
        return false;
    }

    public String toString() {
        return this.DELEGATE.toString();
    }
}

