/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstArgumentList;
import com.jetbrains.python.ast.PyAstDictLiteralExpression;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstListLiteralExpression;
import com.jetbrains.python.ast.PyAstParameter;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstRecursiveElementVisitor;
import com.jetbrains.python.ast.PyAstSequenceExpression;
import com.jetbrains.python.ast.PyAstSetLiteralExpression;
import com.jetbrains.python.ast.PyAstSubscriptionExpression;
import com.jetbrains.python.ast.PyAstTupleExpression;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.PyAstElementGenerator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/formatter/PyTrailingCommasPostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "processTextRange", "Lcom/intellij/openapi/util/TextRange;", "psiElement", "Lcom/intellij/psi/PsiElement;", "range", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processElement", "source", "processText", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "TrailingCommaInsertVisitor", "intellij.python.syntax.core"})
public final class PyTrailingCommasPostFormatProcessor
implements PostFormatProcessor {
    private final TextRange processTextRange(PsiElement psiElement, TextRange range, CodeStyleSettings settings) {
        PsiFile psiFile;
        if (!Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)((Object)PythonLanguage.getInstance()))) {
            return range;
        }
        PyPsiUtilsCore.assertValid(psiElement);
        PsiFile psiFile2 = psiFile = psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (psiFile == null) {
            return range;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        TrailingCommaInsertVisitor visitor2 = new TrailingCommaInsertVisitor(settings, range, project2);
        psiElement.accept((PsiElementVisitor)visitor2);
        return visitor2.getResultTextRange();
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TextRange textRange = source.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.processTextRange(source, textRange, settings);
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.processTextRange((PsiElement)source, rangeToReformat, settings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\"H\u0016J\u0014\u0010#\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020&H\u0002J\u001e\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u0014\u0010-\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u00020)H\u0002J\f\u00100\u001a\u000201*\u00020)H\u0002R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lcom/jetbrains/python/formatter/PyTrailingCommasPostFormatProcessor$TrailingCommaInsertVisitor;", "Lcom/jetbrains/python/ast/PyAstRecursiveElementVisitor;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "range", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/project/Project;)V", "pySettings", "Lcom/jetbrains/python/formatter/PyCodeStyleSettings;", "Lorg/jetbrains/annotations/NotNull;", "pyCommonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "helper", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "codeStyleManager", "Lcom/intellij/psi/codeStyle/CodeStyleManager;", "kotlin.jvm.PlatformType", "resultTextRange", "getResultTextRange", "()Lcom/intellij/openapi/util/TextRange;", "visitPyDictLiteralExpression", "", "node", "Lcom/jetbrains/python/ast/PyAstDictLiteralExpression;", "visitPyListLiteralExpression", "Lcom/jetbrains/python/ast/PyAstListLiteralExpression;", "visitPySetLiteralExpression", "Lcom/jetbrains/python/ast/PyAstSetLiteralExpression;", "visitPyParameterList", "Lcom/jetbrains/python/ast/PyAstParameterList;", "visitPyArgumentList", "Lcom/jetbrains/python/ast/PyAstArgumentList;", "visitPyTupleExpression", "Lcom/jetbrains/python/ast/PyAstTupleExpression;", "processCollectionLiteral", "Lcom/jetbrains/python/ast/PyAstSequenceExpression;", "processContainer", "container", "Lcom/intellij/psi/PsiElement;", "elements", "", "Lcom/jetbrains/python/ast/PyAstElement;", "processTupleExpression", "insertComma", "after", "isMultiLine", "", "intellij.python.syntax.core"})
    @SourceDebugExtension(value={"SMAP\nPyTrailingCommasPostFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTrailingCommasPostFormatProcessor.kt\ncom/jetbrains/python/formatter/PyTrailingCommasPostFormatProcessor$TrailingCommaInsertVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
    private static final class TrailingCommaInsertVisitor
    extends PyAstRecursiveElementVisitor {
        @NotNull
        private final PyCodeStyleSettings pySettings;
        @NotNull
        private final CommonCodeStyleSettings pyCommonSettings;
        @NotNull
        private final PostFormatProcessorHelper helper;
        private final CodeStyleManager codeStyleManager;

        /*
         * WARNING - void declaration
         */
        public TrailingCommaInsertVisitor(@NotNull CodeStyleSettings settings, @NotNull TextRange range, @NotNull Project project) {
            void $this$helper_u24lambda_u240;
            PostFormatProcessorHelper postFormatProcessorHelper;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(PyCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            this.pySettings = (PyCodeStyleSettings)customCodeStyleSettings;
            CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)PythonLanguage.getInstance());
            Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
            this.pyCommonSettings = commonCodeStyleSettings;
            PostFormatProcessorHelper postFormatProcessorHelper2 = postFormatProcessorHelper = new PostFormatProcessorHelper(this.pyCommonSettings);
            TrailingCommaInsertVisitor trailingCommaInsertVisitor = this;
            boolean bl = false;
            $this$helper_u24lambda_u240.setResultTextRange(range);
            trailingCommaInsertVisitor.helper = postFormatProcessorHelper;
            this.codeStyleManager = CodeStyleManager.getInstance((Project)project);
        }

        @NotNull
        public final TextRange getResultTextRange() {
            TextRange textRange = this.helper.getResultTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getResultTextRange(...)");
            return textRange;
        }

        @Override
        public void visitPyDictLiteralExpression(@NotNull PyAstDictLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.processCollectionLiteral(node);
            super.visitPyDictLiteralExpression(node);
        }

        @Override
        public void visitPyListLiteralExpression(@NotNull PyAstListLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.processCollectionLiteral(node);
            super.visitPyListLiteralExpression(node);
        }

        @Override
        public void visitPySetLiteralExpression(@NotNull PyAstSetLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.processCollectionLiteral(node);
            super.visitPySetLiteralExpression(node);
        }

        @Override
        public void visitPyParameterList(@NotNull PyAstParameterList node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.pySettings.USE_TRAILING_COMMA_IN_PARAMETER_LIST) {
                PsiElement psiElement = (PsiElement)node;
                PyAstParameter[] pyAstParameterArray = node.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstParameterArray, (String)"getParameters(...)");
                this.processContainer(psiElement, ArraysKt.asList((Object[])pyAstParameterArray));
            }
            super.visitPyParameterList(node);
        }

        @Override
        public void visitPyArgumentList(@NotNull PyAstArgumentList node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.pySettings.USE_TRAILING_COMMA_IN_ARGUMENTS_LIST) {
                PsiElement psiElement = (PsiElement)node;
                PyAstExpression[] pyAstExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getArguments(...)");
                this.processContainer(psiElement, ArraysKt.asList((Object[])pyAstExpressionArray));
            }
            super.visitPyArgumentList(node);
        }

        @Override
        public void visitPyTupleExpression(@NotNull PyAstTupleExpression<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            if (this.pySettings.USE_TRAILING_COMMA_IN_COLLECTIONS && this.helper.isElementFullyInRange((PsiElement)node)) {
                this.processTupleExpression(node);
            }
            super.visitPyTupleExpression(node);
        }

        private final void processCollectionLiteral(PyAstSequenceExpression node) {
            if (this.pySettings.USE_TRAILING_COMMA_IN_COLLECTIONS) {
                PsiElement psiElement = (PsiElement)node;
                PyAstExpression[] pyAstExpressionArray = node.getElements();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
                this.processContainer(psiElement, ArraysKt.asList((Object[])pyAstExpressionArray));
            }
        }

        private final void processContainer(PsiElement container, List<? extends PyAstElement> elements) {
            block2: {
                if (!this.helper.isElementFullyInRange(container)) {
                    return;
                }
                PyAstElement pyAstElement = (PyAstElement)CollectionsKt.lastOrNull(elements);
                if (pyAstElement == null) break block2;
                PyAstElement lastElement = pyAstElement;
                boolean bl = false;
                if (!this.isMultiLine((PsiElement)lastElement)) {
                    return;
                }
                this.insertComma(container, (PsiElement)lastElement);
            }
        }

        private final void processTupleExpression(PyAstTupleExpression<?> node) {
            block2: {
                if (!(node.getParent() instanceof PyAstParenthesizedExpression) && !(node.getParent() instanceof PyAstSubscriptionExpression) || !this.isMultiLine((PsiElement)node)) {
                    return;
                }
                PyAstExpression[] pyAstExpressionArray = node.getElements();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
                PyAstExpression pyAstExpression = (PyAstExpression)ArraysKt.lastOrNull((Object[])pyAstExpressionArray);
                if (pyAstExpression == null) break block2;
                PyAstExpression lastElement = pyAstExpression;
                boolean bl = false;
                PsiElement psiElement = lastElement.getNextSibling();
                if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)((Object)PyTokenTypes.COMMA))) {
                    this.insertComma((PsiElement)node, (PsiElement)lastElement);
                }
            }
        }

        private final void insertComma(PsiElement container, PsiElement after) {
            int initialLength = container.getTextLength();
            ASTNode comma = PyAstElementGenerator.getInstance(after.getProject()).createComma();
            PsiElement addedComma = container.addAfter(comma.getPsi(), after);
            int n = PsiTreeUtilKt.getEndOffset((PsiElement)after);
            Intrinsics.checkNotNull((Object)addedComma);
            this.codeStyleManager.reformatRange(container, n, PsiTreeUtilKt.getEndOffset((PsiElement)addedComma));
            this.helper.updateResultRange(initialLength, container.getTextLength());
        }

        private final boolean isMultiLine(PsiElement $this$isMultiLine) {
            PsiElement psiElement = PyPsiUtilsCore.getNextNonWhitespaceSiblingOnSameLine($this$isMultiLine);
            PsiComment psiComment = psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
            PsiElement lookForNewLineAfter = psiComment != null ? (PsiElement)psiComment : $this$isMultiLine;
            psiElement = lookForNewLineAfter.getNextSibling();
            PsiWhiteSpace psiWhiteSpace = psiElement instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement : null;
            return psiWhiteSpace != null ? psiWhiteSpace.textContains('\n') : false;
        }
    }
}

