/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstCaseClause;
import com.jetbrains.python.ast.PyAstComprehensionElement;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstForStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstMatchStatement;
import com.jetbrains.python.ast.PyAstPrefixExpression;
import com.jetbrains.python.ast.PyAstTypeAliasStatement;
import com.jetbrains.python.ast.PyAstWithStatement;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.validation.PyAnnotationHolder;
import com.jetbrains.python.validation.PyAnnotatorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyKeywordHighlightingAnnotator
extends PyAnnotatorBase
implements HighlightRangeExtension {
    public boolean isForceHighlightParents(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PyKeywordHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        return psiFile instanceof PyAstFile;
    }

    @Override
    public void annotate(@NotNull PsiElement element, @NotNull PyAnnotationHolder holder) {
        if (element == null) {
            PyKeywordHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PyKeywordHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyKeywordHighlightingAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isForceHighlightParents";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVisitor
    extends PyAstElementVisitor {
        @NotNull
        private final PyAnnotationHolder myHolder;

        private MyVisitor(@NotNull PyAnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitPyFunction(@NotNull PyAstFunction node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (node.isAsyncAllowed()) {
                this.highlightKeyword((PsiElement)node, PyTokenTypes.ASYNC_KEYWORD);
            }
        }

        public void visitPyForStatement(@NotNull PyAstForStatement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.ASYNC_KEYWORD);
        }

        public void visitPyWithStatement(@NotNull PyAstWithStatement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.ASYNC_KEYWORD);
        }

        public void visitPyPrefixExpression(@NotNull PyAstPrefixExpression node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.AWAIT_KEYWORD);
        }

        public void visitPyComprehensionElement(@NotNull PyAstComprehensionElement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            this.highlightKeywords((PsiElement)node, PyTokenTypes.ASYNC_KEYWORD);
        }

        public void visitPyMatchStatement(@NotNull PyAstMatchStatement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.MATCH_KEYWORD);
        }

        public void visitPyCaseClause(@NotNull PyAstCaseClause node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.CASE_KEYWORD);
        }

        public void visitPyTypeAliasStatement(@NotNull PyAstTypeAliasStatement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            this.highlightKeyword((PsiElement)node, PyTokenTypes.TYPE_KEYWORD);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if (PyTokenTypes.EXPRESSION_KEYWORDS.contains(element.getNode().getElementType()) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAstAnnotation.class) != null) {
                this.myHolder.addHighlightingAnnotation(element, PyHighlighter.PY_KEYWORD);
            }
        }

        private void highlightKeyword(@NotNull PsiElement node, @NotNull PyElementType elementType) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if (elementType == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            this.highlightAsKeyword(node.getNode().findChildByType((IElementType)elementType));
        }

        private void highlightKeywords(@NotNull PsiElement node, @NotNull PyElementType elementType) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (elementType == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            for (ASTNode astNode : node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{elementType}))) {
                this.highlightAsKeyword(astNode);
            }
        }

        private void highlightAsKeyword(@Nullable ASTNode astNode) {
            if (astNode != null) {
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(astNode).textAttributes(PyHighlighter.PY_KEYWORD).create();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/validation/PyKeywordHighlightingAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyWithStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyPrefixExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyComprehensionElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyMatchStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCaseClause";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTypeAliasStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightKeyword";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightKeywords";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

