/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePointer;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ChangeLemma(@Nullable String fromLemma, @NotNull String toLemma, PosGenerator posGen) implements NodeCorrector.Relative
{
    private static final PosGenerator SAME_POS = (node, srcPosTags) -> srcPosTags.stream().map(PosMapping::new);

    public static ChangeLemma to(String newLemma) {
        return new ChangeLemma(null, newLemma, SAME_POS);
    }

    public ChangeLemma from(@NotNull String fromLemma) {
        return new ChangeLemma(fromLemma, this.toLemma, this.posGen);
    }

    public ChangeLemma withPos(PosGenerator gen) {
        assert (this.posGen == SAME_POS) : "Don't call withPos or transformPos more than once";
        return new ChangeLemma(this.fromLemma, this.toLemma, gen);
    }

    public ChangeLemma transformPos(Function<String, @Nullable String> posRegex) {
        return this.withPos((node, srcPosTags) -> srcPosTags.stream().map(src -> {
            String target = (String)posRegex.apply((String)src);
            return target == null ? null : new PosMapping((String)src, target);
        }));
    }

    public List<String> suggestions(Node node) {
        List srcPosTags = ((StreamEx)((StreamEx)StreamEx.of(node.tokenReadings()).filter(r -> this.fromLemma == null || this.fromLemma.equals(r.lemma()))).map(r -> r.pos()).nonNull().distinct()).toList();
        List mappings = ((StreamEx)StreamEx.of(this.posGen.getTargetPosTags(node, srcPosTags)).nonNull().distinct()).toList();
        return ((StreamEx)StreamEx.of((Collection)mappings).flatCollection(m -> node.tree().treeSupport().synthesize(node.form(), this.toLemma, m.srcPos, m.targetRegex)).distinct()).toList();
    }

    @Override
    public NodeCorrector eval(NodeMatch match) {
        return this.corrector(match.anchor());
    }

    public NodeCorrector.Relative corrector(NodePointer pointer) {
        return NodeCorrector.replaceNodes(pointer, pointer, m -> this.suggestions(pointer.findNode((NodeMatch)m)));
    }

    public NodeCorrector corrector(Node node) {
        return NodeCorrector.replace(node, this.suggestions(node));
    }

    public static interface PosGenerator {
        public Stream<@Nullable PosMapping> getTargetPosTags(Node var1, List<String> var2);
    }

    public record PosMapping(@NotNull String srcPos, @NotNull String targetRegex) {
        public PosMapping(@NotNull String srcPos) {
            this(srcPos, srcPos);
        }
    }
}

