/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;

public class NullNode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    public static final NullNode instance = new NullNode();

    protected NullNode() {
    }

    public static NullNode getInstance() {
        return instance;
    }

    protected Object readResolve() {
        return instance;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.NULL;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NULL;
    }

    @Override
    public NullNode deepCopy() {
        return this;
    }

    @Override
    protected Boolean _asBoolean() {
        return Boolean.FALSE;
    }

    @Override
    protected String _asString() {
        return "";
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public String stringValue(String defaultValue) {
        return defaultValue;
    }

    @Override
    public Optional<String> stringValueOpt() {
        return Optional.empty();
    }

    @Override
    public short asShort() {
        return 0;
    }

    @Override
    public short asShort(short defaultValue) {
        return 0;
    }

    @Override
    public Optional<Short> asShortOpt() {
        return Optional.of((short)0);
    }

    @Override
    public int asInt() {
        return 0;
    }

    @Override
    public int asInt(int defaultValue) {
        return 0;
    }

    @Override
    public OptionalInt asIntOpt() {
        return OptionalInt.of(0);
    }

    @Override
    public long asLong() {
        return 0L;
    }

    @Override
    public long asLong(long defaultValue) {
        return 0L;
    }

    @Override
    public OptionalLong asLongOpt() {
        return OptionalLong.of(0L);
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.asBigInteger();
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        return Optional.of(this.asBigInteger());
    }

    @Override
    public float asFloat() {
        return 0.0f;
    }

    @Override
    public float asFloat(float defaultValue) {
        return this.asFloat();
    }

    @Override
    public Optional<Float> asFloatOpt() {
        return Optional.of(Float.valueOf(this.asFloat()));
    }

    @Override
    public double asDouble() {
        return 0.0;
    }

    @Override
    public double asDouble(double defaultValue) {
        return this.asDouble();
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        return OptionalDouble.of(this.asDouble());
    }

    @Override
    public BigDecimal asDecimal() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return this.asDecimal();
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        return Optional.of(this.asDecimal());
    }

    @Override
    protected String _valueDesc() {
        return "<null>";
    }

    public JsonNode requireNonNull() {
        return (JsonNode)this._reportRequiredViolation("requireNonNull() called on `NullNode`", new Object[0]);
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        provider.defaultSerializeNullValue(g);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof NullNode;
    }

    @Override
    public int hashCode() {
        return JsonNodeType.NULL.ordinal();
    }
}

