/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.jdbc.metadata.MetadataPattern;

public final class Clause {
    private final String condition;
    private final String value;

    public Clause(String columnName, String pattern) {
        this(columnName, MetadataPattern.compile(pattern));
    }

    private Clause(String columnName, MetadataPattern metadataPattern) {
        this.condition = metadataPattern.renderCondition(columnName);
        this.value = metadataPattern.getConditionValue();
    }

    static Clause equalsClause(String columnName, String value) {
        return new Clause(columnName, MetadataPattern.equalsCondition(value));
    }

    public String getCondition() {
        return this.getCondition(true);
    }

    public String getCondition(boolean includeAnd) {
        if (includeAnd) {
            return this.getCondition("", " and ");
        }
        return this.getPlainCondition();
    }

    public String getCondition(String prefix, String suffix) {
        if (this.emptyCondition()) {
            return "";
        }
        if (Objects.equals("", prefix) && Objects.equals("", suffix)) {
            return this.condition;
        }
        return prefix + this.condition + suffix;
    }

    private String getPlainCondition() {
        if (this.emptyCondition()) {
            return "";
        }
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasCondition() {
        return !this.emptyCondition();
    }

    private boolean emptyCondition() {
        return this.condition.isEmpty();
    }

    public static boolean anyCondition(Clause clause1, Clause clause2) {
        return clause1.hasCondition() || clause2.hasCondition();
    }

    public static boolean anyCondition(Clause ... clauses) {
        for (Clause clause : clauses) {
            if (!clause.hasCondition()) continue;
            return true;
        }
        return false;
    }

    public static List<String> parameters(Clause clause1) {
        if (clause1.hasCondition()) {
            return Collections.singletonList(clause1.getValue());
        }
        return Collections.emptyList();
    }

    public static List<String> parameters(Clause clause1, Clause clause2) {
        if (!Clause.anyCondition(clause1, clause2)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(2);
        if (clause1.hasCondition()) {
            list.add(clause1.getValue());
        }
        if (clause2.hasCondition()) {
            list.add(clause2.getValue());
        }
        return list;
    }

    public static List<String> parameters(Clause ... clauses) {
        ArrayList<String> list = new ArrayList<String>(clauses.length);
        for (Clause clause : clauses) {
            if (!clause.hasCondition()) continue;
            list.add(clause.getValue());
        }
        return list;
    }

    public static List<String> parameters(List<Clause> clauses) {
        ArrayList<String> list = new ArrayList<String>(clauses.size());
        for (Clause clause : clauses) {
            if (!clause.hasCondition()) continue;
            list.add(clause.getValue());
        }
        return list;
    }
}

