/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorRejectNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResolveNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorResumeNextNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callPromiseResolveNode;
    @Node.Child
    private PerformPromiseThenNode performPromiseThenNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private AsyncGeneratorResolveNode asyncGeneratorResolveNode;
    @Node.Child
    private AsyncGeneratorRejectNode asyncGeneratorRejectNode;
    @Node.Child
    private PropertySetNode setGeneratorNode;
    @Node.Child
    private PromiseResolveNode promiseResolveNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    private final ConditionProfile abruptProf = ConditionProfile.create();
    protected final JSContext context;
    static final HiddenKey RETURN_PROCESSOR_GENERATOR = new HiddenKey("Generator");

    protected AsyncGeneratorResumeNextNode(JSContext context) {
        this.context = context;
        this.asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(context);
    }

    public static AsyncGeneratorResumeNextNode create(JSContext context) {
        return new WithCall(context);
    }

    public static AsyncGeneratorResumeNextNode createTailCall(JSContext context) {
        return new AsyncGeneratorResumeNextNode(context);
    }

    public final Object execute(JSAsyncGeneratorObject generator) {
        AsyncGeneratorRequest next;
        JSFunction.AsyncGeneratorState state;
        while (true) {
            state = generator.getAsyncGeneratorState();
            assert (state != JSFunction.AsyncGeneratorState.Executing);
            if (state == JSFunction.AsyncGeneratorState.AwaitingReturn) {
                return Undefined.instance;
            }
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            if (queue.isEmpty()) {
                return Undefined.instance;
            }
            next = queue.peekFirst();
            if (this.abruptProf.profile(next.isAbruptCompletion())) {
                if (state == JSFunction.AsyncGeneratorState.SuspendedStart) {
                    state = JSFunction.AsyncGeneratorState.Completed;
                    generator.setAsyncGeneratorState(state);
                }
                if (state != JSFunction.AsyncGeneratorState.Completed) break;
                if (next.isReturn()) {
                    JSPromiseObject promise;
                    this.enterReturnBranch();
                    generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.AwaitingReturn);
                    try {
                        promise = this.promiseResolve(next.getCompletionValue());
                    }
                    catch (AbstractTruffleException e) {
                        this.asyncGeneratorRejectBrokenPromise(generator, e);
                        continue;
                    }
                    JSFunctionObject onFulfilled = this.createAsyncGeneratorReturnProcessorFulfilledFunction(generator);
                    JSFunctionObject onRejected = this.createAsyncGeneratorReturnProcessorRejectedFunction(generator);
                    PromiseCapabilityRecord throwawayCapability = this.newThrowawayCapability();
                    this.performPromiseThenNode.execute(promise, (Object)onFulfilled, (Object)onRejected, throwawayCapability);
                    return Undefined.instance;
                }
                assert (next.isThrow());
                this.enterThrowBranch();
                this.asyncGeneratorRejectNode.performReject(generator, next.getCompletionValue());
                continue;
            }
            if (state != JSFunction.AsyncGeneratorState.Completed) break;
            this.asyncGeneratorResolveNode.performResolve(generator, (Object)Undefined.instance, true);
        }
        assert (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield);
        generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Executing);
        return this.performResumeNext(generator, next.getCompletion());
    }

    private JSPromiseObject promiseResolve(Object value) {
        if (this.context.usePromiseResolve()) {
            if (this.promiseResolveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.promiseResolveNode = (PromiseResolveNode)this.insert(PromiseResolveNode.create(this.context));
            }
            return (JSPromiseObject)this.promiseResolveNode.execute((Object)this.getRealm().getPromiseConstructor(), value);
        }
        if (this.callPromiseResolveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callPromiseResolveNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callPromiseResolveNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), value));
        return (JSPromiseObject)promiseCapability.getPromise();
    }

    protected Object performResumeNext(JSAsyncGeneratorObject generator, Completion completion) {
        return completion;
    }

    private void enterReturnBranch() {
        if (this.performPromiseThenNode == null || this.setGeneratorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.performPromiseThenNode = (PerformPromiseThenNode)this.insert(PerformPromiseThenNode.create(this.context));
            this.setGeneratorNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(RETURN_PROCESSOR_GENERATOR, this.context));
        }
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private PromiseCapabilityRecord newThrowawayCapability() {
        if (this.context.getEcmaScriptVersion() >= 10) {
            return null;
        }
        PromiseCapabilityRecord throwawayCapability = this.newPromiseCapability();
        ((JSPromiseObject)throwawayCapability.getPromise()).setIsHandled(true);
        return throwawayCapability;
    }

    private void enterThrowBranch() {
        if (this.asyncGeneratorRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorRejectNode = (AsyncGeneratorRejectNode)this.insert(AsyncGeneratorRejectNode.create());
        }
    }

    private void asyncGeneratorRejectBrokenPromise(JSAsyncGeneratorObject generator, AbstractTruffleException exception) {
        if (this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        this.enterThrowBranch();
        generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
        Object error = this.getErrorObjectNode.execute(exception);
        this.asyncGeneratorRejectNode.performReject(generator, error);
    }

    private JSFunctionObject createAsyncGeneratorReturnProcessorFulfilledFunction(JSDynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnFulfilled, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorFulfilledImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue((Object)function, (Object)generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorFulfilledImpl(JSContext context) {
        class AsyncGeneratorReturnFulfilledRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorResolveNode asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(this.val$context);
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnFulfilledRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                JSAsyncGeneratorObject generatorObject = (JSAsyncGeneratorObject)((Object)this.getGenerator.getValue((Object)functionObject));
                generatorObject.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
                Object value = this.valueNode.execute(frame);
                return this.asyncGeneratorResolveNode.execute(generatorObject, value, true);
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new AsyncGeneratorReturnFulfilledRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private JSFunctionObject createAsyncGeneratorReturnProcessorRejectedFunction(JSDynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnRejected, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorRejectedImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue((Object)function, (Object)generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorRejectedImpl(JSContext context) {
        class AsyncGeneratorReturnRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode reasonNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorRejectNode asyncGeneratorRejectNode = AsyncGeneratorRejectNode.create();
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnRejectedRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                JSAsyncGeneratorObject generatorObject = (JSAsyncGeneratorObject)((Object)this.getGenerator.getValue((Object)functionObject));
                generatorObject.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
                Object reason = this.reasonNode.execute(frame);
                return this.asyncGeneratorRejectNode.execute(generatorObject, reason);
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new AsyncGeneratorReturnRejectedRootNode(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static class WithCall
    extends AsyncGeneratorResumeNextNode {
        @Node.Child
        private InternalCallNode callNode = InternalCallNode.create();

        protected WithCall(JSContext context) {
            super(context);
        }

        @Override
        protected Object performResumeNext(JSAsyncGeneratorObject generator, Completion completion) {
            CallTarget generatorTarget = generator.getAsyncGeneratorTarget();
            MaterializedFrame generatorContext = generator.getAsyncGeneratorContext();
            this.callNode.execute(generatorTarget, JSArguments.createResumeArguments(generatorContext, (Object)generator, completion));
            return Undefined.instance;
        }
    }
}

