/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.method.PMethodBase;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.util.Arrays;

public class TpSlotBinaryOp {
    private TpSlotBinaryOp() {
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    protected static abstract class RichCompareCallablesNotEqual
    extends Node {
        protected RichCompareCallablesNotEqual() {
        }

        public abstract boolean execute(VirtualFrame var1, Node var2, Object var3, Object var4);

        @Specialization(guards={"a == b"})
        static boolean areIdenticalFastPath(Object a, Object b) {
            return false;
        }

        @Specialization(guards={"isNone(a) || isNone(b)"})
        static boolean noneFastPath(Object a, Object b) {
            return a != b;
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doBuiltins(PBuiltinFunction a, PBuiltinFunction b) {
            return a != b;
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doFunctions(PFunction a, PFunction b) {
            return a != b;
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doMethods(PMethodBase a, PMethodBase b) {
            return a != b;
        }

        @Fallback
        static boolean doGenericRuntimeObjects(VirtualFrame frame, Node inliningTarget, Object a, Object b, @Cached PyObjectRichCompareBool neNode) {
            return neNode.execute((Frame)frame, inliningTarget, a, b, RichCmpOp.Py_NE);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CallReversiblePythonSlotNode
    extends Node {
        CallReversiblePythonSlotNode() {
        }

        public abstract Object execute(VirtualFrame var1, TpSlotReversiblePython var2, Object var3, Object var4, Object var5, TpSlot var6, Object var7, boolean var8, ReversibleSlot var9);

        @Specialization
        static Object callPython(VirtualFrame frame, TpSlotReversiblePython slot, Object self, Object selfType, Object other, TpSlot otherSlot, Object otherType, boolean sameTypes, ReversibleSlot op, @Bind Node inliningTarget, @Cached IsSubtypeNode isSubtypeNode, @Cached TpSlots.GetCachedTpSlotsNode getSelfSlotsNode, @Cached RichCompareCallablesNotEqual neNode, @Cached InlinedConditionProfile dispatchR1Profile, @Cached InlinedConditionProfile dispatchLProfile, @Cached InlinedConditionProfile dispatchR2Profile, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcherNode) {
            TpSlots selfSlots;
            TpSlot selfSlotValue;
            TpSlotReversiblePython otherSlotValue = null;
            boolean doOther = false;
            if (!sameTypes && CallReversiblePythonSlotNode.isSameReversibleWrapper(otherSlot, op)) {
                otherSlotValue = (TpSlotReversiblePython)otherSlot;
                doOther = true;
            }
            if (CallReversiblePythonSlotNode.isSameReversibleWrapper(selfSlotValue = op.getSlotValue(selfSlots = getSelfSlotsNode.execute(inliningTarget, selfType)), op)) {
                Object result;
                if (doOther && isSubtypeNode.execute(otherType, selfType) && CallReversiblePythonSlotNode.methodIsOverloaded(frame, inliningTarget, slot, otherSlotValue, neNode)) {
                    result = CallReversiblePythonSlotNode.dispatchIfAvailable(frame, inliningTarget, dispatchR1Profile, dispatcherNode, other, self, otherSlotValue.getRight(), otherSlotValue.getType());
                    if (result != PNotImplemented.NOT_IMPLEMENTED) {
                        return result;
                    }
                    doOther = false;
                }
                if ((result = CallReversiblePythonSlotNode.dispatchIfAvailable(frame, inliningTarget, dispatchLProfile, dispatcherNode, self, other, slot.getLeft(), slot.getType())) != PNotImplemented.NOT_IMPLEMENTED || sameTypes) {
                    return result;
                }
            }
            if (doOther) {
                return CallReversiblePythonSlotNode.dispatchIfAvailable(frame, inliningTarget, dispatchR2Profile, dispatcherNode, other, self, otherSlotValue.getRight(), otherSlotValue.getType());
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        private static Object dispatchIfAvailable(VirtualFrame frame, Node inliningTarget, InlinedConditionProfile profile, PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcherNode, Object self, Object other, Object method, Object type) {
            if (profile.profile(inliningTarget, method != null)) {
                return dispatcherNode.execute(frame, inliningTarget, method, type, self, other);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean isSameReversibleWrapper(TpSlot s, ReversibleSlot op) {
            if (!(s instanceof TpSlotReversiblePython)) return false;
            TpSlotReversiblePython p = (TpSlotReversiblePython)s;
            if (p.op != op) return false;
            return true;
        }

        static boolean methodIsOverloaded(VirtualFrame frame, Node inliningTarget, TpSlotReversiblePython leftSlot, TpSlotReversiblePython rightSlot, RichCompareCallablesNotEqual neNode) {
            Object rightMethod = rightSlot.getRight();
            if (rightMethod == null) {
                return false;
            }
            Object leftMethod = leftSlot.getRight();
            if (leftMethod == null) {
                return true;
            }
            return neNode.execute(frame, inliningTarget, leftMethod, rightMethod);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotBinaryOpNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "binaryop");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, Object var6, TpSlot var7, Object var8, boolean var9, ReversibleSlot var10);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotBinaryOpBuiltin<?> slot, Object self, Object selfType, Object other, TpSlot otherSlot, Object otherType, boolean sameTypes, ReversibleSlot op, @Cached(value="slot") TpSlotBinaryOpBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createOpSlotNode()") BinaryOpBuiltinNode slotNode) {
            return slotNode.execute(frame, self, other);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, TpSlotReversiblePython slot, Object self, Object selfType, Object other, TpSlot otherSlot, Object otherType, boolean sameTypes, ReversibleSlot op, @Cached(inline=false) CallReversiblePythonSlotNode callPython) {
            return callPython.execute(frame, slot, self, selfType, other, otherSlot, otherType, sameTypes, op);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, Object selfType, Object arg, TpSlot otherSlot, Object otherType, boolean sameTypes, ReversibleSlot op, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode argToNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, op.name, slot.callable, selfToNativeNode.execute(self), argToNativeNode.execute(arg));
            return checkResultNode.execute(state, op.name, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericComplexBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotBinaryOpBuiltin<?> slot, Object self, Object selfType, Object other, TpSlot otherSlot, Object otherType, boolean sameTypes, ReversibleSlot op, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(2);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, other);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    public static final class TpSlotReversiblePython
    extends TpSlot.TpSlotPython {
        private final ReversibleSlot op;
        private final TruffleWeakReference<Object> left;
        private final TruffleWeakReference<Object> right;
        private final TruffleWeakReference<Object> type;

        public TpSlotReversiblePython(ReversibleSlot op, Object left, Object right, Object type) {
            this.op = op;
            this.left = TpSlotReversiblePython.asWeakRef(left);
            this.right = TpSlotReversiblePython.asWeakRef(right);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotReversiblePython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == 2);
            ReversibleSlot op = ReversibleSlot.fromCallableNames(callableNames);
            assert (op != null) : "Unexpected callable names: " + Arrays.toString(callableNames);
            return new TpSlotReversiblePython(op, callables[0], callables[1], type);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object newLeft = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, this.op.name);
            Object newRight = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, this.op.rname);
            if (newLeft != this.getLeft() || newRight != this.getRight()) {
                return new TpSlotReversiblePython(this.op, newLeft, newRight, this.getType());
            }
            return this;
        }

        public Object getLeft() {
            return this.safeGet(this.left);
        }

        public Object getRight() {
            return this.safeGet(this.right);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class BinaryOpBuiltinNode
    extends PythonBinaryBuiltinNode {
    }

    static final class SwapArgumentsNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private BinaryOpBuiltinNode wrapped;

        SwapArgumentsNode(BinaryOpBuiltinNode wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Object execute(VirtualFrame frame, Object self, Object other) {
            return this.wrapped.execute(frame, other, self);
        }
    }

    public static abstract class TpSlotBinaryIOpBuiltin<T extends PythonBinaryBuiltinNode>
    extends TpSlotBinaryFunc.TpSlotBinaryFuncBuiltin<T> {
        protected TpSlotBinaryIOpBuiltin(NodeFactory<T> nodeFactory, String builtinName) {
            super(nodeFactory, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, builtinName);
        }
    }

    public static abstract class TpSlotBinaryOpBuiltin<T extends BinaryOpBuiltinNode>
    extends TpSlot.TpSlotBuiltin<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();
        private final String builtinName;

        protected TpSlotBinaryOpBuiltin(NodeFactory<T> nodeFactory, String builtinName) {
            super(nodeFactory);
            this.builtinName = builtinName;
        }

        final BinaryOpBuiltinNode createOpSlotNode() {
            return (BinaryOpBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotBinaryOpBuiltin.createSlotCallTarget(language, BuiltinSlotWrapperSignature.BINARY, this.getNodeFactory(), this.builtinName);
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return switch (wrapper) {
                case ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L -> this.createBuiltin(core, type, tsName, BuiltinSlotWrapperSignature.BINARY, wrapper, this.getNodeFactory());
                case ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R -> this.createRBuiltin(core, type, tsName);
                default -> null;
            };
        }

        private PBuiltinFunction createRBuiltin(Python3Core core, Object type, TruffleString tsName) {
            NodeFactoryUtils.WrapperNodeFactory<SwapArgumentsNode, BinaryOpBuiltinNode> factory = NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), SwapArgumentsNode.class, SwapArgumentsNode::new);
            return this.createBuiltin(core, type, tsName, BuiltinSlotWrapperSignature.BINARY, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R, factory);
        }
    }

    public static enum InplaceSlot {
        NB_INPLACE_ADD(ReversibleSlot.NB_ADD),
        NB_INPLACE_SUBTRACT(ReversibleSlot.NB_SUBTRACT),
        NB_INPLACE_MULTIPLY(ReversibleSlot.NB_MULTIPLY),
        NB_INPLACE_REMAINDER(ReversibleSlot.NB_REMAINDER),
        NB_INPLACE_LSHIFT(ReversibleSlot.NB_LSHIFT),
        NB_INPLACE_RSHIFT(ReversibleSlot.NB_RSHIFT),
        NB_INPLACE_AND(ReversibleSlot.NB_AND),
        NB_INPLACE_XOR(ReversibleSlot.NB_XOR),
        NB_INPLACE_OR(ReversibleSlot.NB_OR),
        NB_INPLACE_FLOOR_DIVIDE(ReversibleSlot.NB_FLOOR_DIVIDE),
        NB_INPLACE_TRUE_DIVIDE(ReversibleSlot.NB_TRUE_DIVIDE),
        NB_INPLACE_MATRIX_MULTIPLY(ReversibleSlot.NB_MATRIX_MULTIPLY);

        private final ReversibleSlot reversibleSlot;

        private InplaceSlot(ReversibleSlot reversibleSlot) {
            this.reversibleSlot = reversibleSlot;
        }

        public TpSlot getSlotValue(TpSlots slots) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> slots.nb_inplace_add();
                case 1 -> slots.nb_inplace_subtract();
                case 2 -> slots.nb_inplace_multiply();
                case 3 -> slots.nb_inplace_remainder();
                case 4 -> slots.nb_inplace_lshift();
                case 5 -> slots.nb_inplace_rshift();
                case 6 -> slots.nb_inplace_and();
                case 7 -> slots.nb_inplace_xor();
                case 8 -> slots.nb_inplace_or();
                case 9 -> slots.nb_inplace_floor_divide();
                case 10 -> slots.nb_inplace_true_divide();
                case 11 -> slots.nb_inplace_matrix_multiply();
            };
        }

        public ReversibleSlot getReversibleSlot() {
            return this.reversibleSlot;
        }
    }

    public static enum ReversibleSlot {
        NB_ADD(SpecialMethodNames.T___ADD__, SpecialMethodNames.T___RADD__),
        NB_SUBTRACT(SpecialMethodNames.T___SUB__, SpecialMethodNames.T___RSUB__),
        NB_MULTIPLY(SpecialMethodNames.T___MUL__, SpecialMethodNames.T___RMUL__),
        NB_REMAINDER(SpecialMethodNames.T___MOD__, SpecialMethodNames.T___RMOD__),
        NB_LSHIFT(SpecialMethodNames.T___LSHIFT__, SpecialMethodNames.T___RLSHIFT__),
        NB_RSHIFT(SpecialMethodNames.T___RSHIFT__, SpecialMethodNames.T___RRSHIFT__),
        NB_AND(SpecialMethodNames.T___AND__, SpecialMethodNames.T___RAND__),
        NB_XOR(SpecialMethodNames.T___XOR__, SpecialMethodNames.T___RXOR__),
        NB_OR(SpecialMethodNames.T___OR__, SpecialMethodNames.T___ROR__),
        NB_FLOOR_DIVIDE(SpecialMethodNames.T___FLOORDIV__, SpecialMethodNames.T___RFLOORDIV__),
        NB_TRUE_DIVIDE(SpecialMethodNames.T___TRUEDIV__, SpecialMethodNames.T___RTRUEDIV__),
        NB_DIVMOD(SpecialMethodNames.T___DIVMOD__, SpecialMethodNames.T___RDIVMOD__),
        NB_MATRIX_MULTIPLY(SpecialMethodNames.T___MATMUL__, SpecialMethodNames.T___RMATMUL__),
        NB_POWER_BINARY(SpecialMethodNames.T___POW__, SpecialMethodNames.T___RPOW__);

        private static final ReversibleSlot[] VALUES;
        private final TruffleString name;
        private final TruffleString rname;

        private ReversibleSlot(TruffleString name, TruffleString rname) {
            this.name = name;
            this.rname = rname;
        }

        public TpSlot getSlotValue(TpSlots slots) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> slots.nb_add();
                case 1 -> slots.nb_subtract();
                case 2 -> slots.nb_multiply();
                case 3 -> slots.nb_remainder();
                case 4 -> slots.nb_lshift();
                case 5 -> slots.nb_rshift();
                case 6 -> slots.nb_and();
                case 7 -> slots.nb_xor();
                case 8 -> slots.nb_or();
                case 9 -> slots.nb_floor_divide();
                case 10 -> slots.nb_true_divide();
                case 11 -> slots.nb_divmod();
                case 12 -> slots.nb_matrix_multiply();
                case 13 -> slots.nb_power();
            };
        }

        public static ReversibleSlot fromCallableNames(TruffleString[] names) {
            for (ReversibleSlot op : VALUES) {
                if (!names[0].equals((Object)op.name) || !names[1].equals((Object)op.rname)) continue;
                return op;
            }
            return null;
        }

        static {
            VALUES = ReversibleSlot.values();
        }
    }
}

