/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_firdes = R"doc(Finite Impulse Response (FIR) filter design functions.)doc";


static const char* __doc_gr_filter_firdes_firdes_0 = R"doc()doc";


static const char* __doc_gr_filter_firdes_firdes_1 = R"doc()doc";


static const char* __doc_gr_filter_firdes_window = R"doc()doc";


static const char* __doc_gr_filter_firdes_low_pass = R"doc(Use \"window method\" to design a low-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_low_pass_2 = R"doc(Use \"window method\" to design a low-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. The window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_high_pass = R"doc(Use \"window method\" to design a high-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_high_pass_2 = R"doc(Use \"window method\" to design a high-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. The window determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_band_pass = R"doc(Use \"window method\" to design a band-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_band_pass_2 = R"doc(Use \"window method\" to design a band-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps. More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_complex_band_pass = R"doc(Use the \"window method\" to design a complex band-pass FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_complex_band_pass_2 = R"doc(Use \"window method\" to design a complex band-pass FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_band_reject = R"doc(Use \"window method\" to design a band-reject FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_band_reject_2 = R"doc(Use \"window method\" to design a band-reject FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_complex_band_reject = R"doc(Use the \"window method\" to design a complex band-reject FIR filter. The normalized width of the transition band is what sets the number of taps required. Narrow --> more taps. The window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_complex_band_reject_2 = R"doc(Use \"window method\" to design a complex band-reject FIR filter. The normalized width of the transition band and the required stop band attenuation is what sets the number of taps required. Narrow --> more taps More attenuation --> more taps. Window type determines maximum attenuation and passband ripple.)doc";


static const char* __doc_gr_filter_firdes_hilbert = R"doc(design a Hilbert Transform Filter)doc";


static const char* __doc_gr_filter_firdes_root_raised_cosine = R"doc(design a Root Cosine FIR Filter (do we need a window?))doc";


static const char* __doc_gr_filter_firdes_gaussian = R"doc(design a Gaussian filter)doc";
