#ifndef SBK_KMESSAGEBOXNOTIFYINTERFACEWRAPPER_H
#define SBK_KMESSAGEBOXNOTIFYINTERFACEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kmessageboxnotifyinterface.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KMessageBoxNotifyInterfaceWrapper : public KMessageBoxNotifyInterface
{
public:
    KMessageBoxNotifyInterfaceWrapper();
    KMessageBoxNotifyInterfaceWrapper(const KMessageBoxNotifyInterfaceWrapper &) = delete;
    KMessageBoxNotifyInterfaceWrapper& operator=(const KMessageBoxNotifyInterfaceWrapper &) = delete;
    KMessageBoxNotifyInterfaceWrapper(KMessageBoxNotifyInterfaceWrapper &&) = delete;
    KMessageBoxNotifyInterfaceWrapper& operator=(KMessageBoxNotifyInterfaceWrapper &&) = delete;
    ~KMessageBoxNotifyInterfaceWrapper() override;

    void sendNotification(::QMessageBox::Icon notificationType, const ::QString & message, ::QWidget * parent) override;
    static void sbk_o_sendNotification(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMessageBox::Icon notificationType, const ::QString & message, ::QWidget * parent);
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 1> m_PyMethodCache = {nullptr};
};

#endif // SBK_KMESSAGEBOXNOTIFYINTERFACEWRAPPER_H
