// python wrapper for vtkSMLiveInsituLinkProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMLiveInsituLinkProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMLiveInsituLinkProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMLiveInsituLinkProxy_ClassNew(); }


static PyObject *
PyvtkSMLiveInsituLinkProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMLiveInsituLinkProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMLiveInsituLinkProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMLiveInsituLinkProxy *tempr = vtkSMLiveInsituLinkProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMLiveInsituLinkProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMLiveInsituLinkProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMLiveInsituLinkProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMLiveInsituLinkProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_GetInsituProxyManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInsituProxyManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSessionProxyManager *tempr = (ap.IsBound() ?
      op->GetInsituProxyManager() :
      op->vtkSMLiveInsituLinkProxy::GetInsituProxyManager());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_SetInsituProxyManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInsituProxyManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  vtkSMSessionProxyManager *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSessionProxyManager"))
  {
    if (ap.IsBound())
    {
      op->SetInsituProxyManager(temp0);
    }
    else
    {
      op->vtkSMLiveInsituLinkProxy::SetInsituProxyManager(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_HasExtract(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasExtract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->HasExtract(temp0, temp1, temp2) :
      op->vtkSMLiveInsituLinkProxy::HasExtract(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_CreateExtract(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateExtract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->CreateExtract(temp0, temp1, temp2) :
      op->vtkSMLiveInsituLinkProxy::CreateExtract(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_RemoveExtract(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveExtract");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveExtract(temp0);
    }
    else
    {
      op->vtkSMLiveInsituLinkProxy::RemoveExtract(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_LiveChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LiveChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LiveChanged();
    }
    else
    {
      op->vtkSMLiveInsituLinkProxy::LiveChanged();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_GetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetTimeStep() :
      op->vtkSMLiveInsituLinkProxy::GetTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMLiveInsituLinkProxy_PushUpdatedStates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PushUpdatedStates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMLiveInsituLinkProxy *op = static_cast<vtkSMLiveInsituLinkProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PushUpdatedStates();
    }
    else
    {
      op->vtkSMLiveInsituLinkProxy::PushUpdatedStates();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMLiveInsituLinkProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMLiveInsituLinkProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMLiveInsituLinkProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMLiveInsituLinkProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMLiveInsituLinkProxy\nC++: static vtkSMLiveInsituLinkProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMLiveInsituLinkProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMLiveInsituLinkProxy\nC++: vtkSMLiveInsituLinkProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMLiveInsituLinkProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMLiveInsituLinkProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInsituProxyManager", PyvtkSMLiveInsituLinkProxy_GetInsituProxyManager, METH_VARARGS,
   "GetInsituProxyManager(self) -> vtkSMSessionProxyManager\nC++: vtkSMSessionProxyManager *GetInsituProxyManager()\n\nProvides access to the a dummy proxy manager representing the\ninsitu visualization pipeline.\n"},
  {"SetInsituProxyManager", PyvtkSMLiveInsituLinkProxy_SetInsituProxyManager, METH_VARARGS,
   "SetInsituProxyManager(self, __a:vtkSMSessionProxyManager) -> None\nC++: void SetInsituProxyManager(vtkSMSessionProxyManager *)\n\n"},
  {"HasExtract", PyvtkSMLiveInsituLinkProxy_HasExtract, METH_VARARGS,
   "HasExtract(self, reg_group:str, reg_name:str, port_number:int)\n    -> bool\nC++: bool HasExtract(const char *reg_group, const char *reg_name,\n    int port_number)\n\n"},
  {"CreateExtract", PyvtkSMLiveInsituLinkProxy_CreateExtract, METH_VARARGS,
   "CreateExtract(self, reg_group:str, reg_name:str, port_number:int)\n    -> vtkSMProxy\nC++: vtkSMProxy *CreateExtract(const char *reg_group,\n    const char *reg_name, int port_number)\n\n"},
  {"RemoveExtract", PyvtkSMLiveInsituLinkProxy_RemoveExtract, METH_VARARGS,
   "RemoveExtract(self, __a:vtkSMProxy) -> None\nC++: void RemoveExtract(vtkSMProxy *)\n\n"},
  {"LiveChanged", PyvtkSMLiveInsituLinkProxy_LiveChanged, METH_VARARGS,
   "LiveChanged(self) -> None\nC++: void LiveChanged()\n\nWakes up Insitu side if simulation is paused. Handles correctly\nseveral calls on the LIVE side.\n"},
  {"GetTimeStep", PyvtkSMLiveInsituLinkProxy_GetTimeStep, METH_VARARGS,
   "GetTimeStep(self) -> int\nC++: vtkIdType GetTimeStep()\n\n"},
  {"PushUpdatedStates", PyvtkSMLiveInsituLinkProxy_PushUpdatedStates, METH_VARARGS,
   "PushUpdatedStates(self) -> None\nC++: void PushUpdatedStates()\n\nPush updated states from the client to the server in aggregate\n(originally, when the simulation was paused, multiple partial\nupdates were pushed, resulting in the connection between client\nand server to sever).\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMLiveInsituLinkProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("insitu_proxy_manager"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMLiveInsituLinkProxy_GetInsituProxyManager(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMLiveInsituLinkProxy_SetInsituProxyManager(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMLiveInsituLinkProxy_SetInsituProxyManager(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInsituProxyManager/SetInsituProxyManager\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMLiveInsituLinkProxy_GetTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeStep\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMLiveInsituLinkProxy_Doc =
  "vtkSMLiveInsituLinkProxy - Performs additional operation on the Live\nclient\n\n"
  "Superclass: vtkSMProxy\n\n"
  "Besides setting or getting parameters from its object\n"
  "(vtkSMLiveInsituLink) it receives paraview state from its object and\n"
  "applies it to the InsituProxyManager as well as sending modified\n"
  "paraview state to its object.@ingroup LiveInsitu\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMLiveInsituLinkProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingLive.vtkSMLiveInsituLinkProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMLiveInsituLinkProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMLiveInsituLinkProxy_StaticNew()
{
  return vtkSMLiveInsituLinkProxy::New();
}

PyObject *PyvtkSMLiveInsituLinkProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMLiveInsituLinkProxy_Type, PyvtkSMLiveInsituLinkProxy_Methods,
    "vtkSMLiveInsituLinkProxy",
 &PyvtkSMLiveInsituLinkProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxy");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMLiveInsituLinkProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMLiveInsituLinkProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMLiveInsituLinkProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMLiveInsituLinkProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

