// python wrapper for vtkLogoSourceRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkLogoSourceRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkLogoSourceRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkLogoSourceRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif

static PyObject *
PyvtkLogoSourceRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkLogoSourceRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkLogoSourceRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkLogoSourceRepresentation *tempr = vtkLogoSourceRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkLogoSourceRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkLogoSourceRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkLogoSourceRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkLogoSourceRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetLogoWidgetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLogoWidgetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  vtk3DWidgetRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtk3DWidgetRepresentation"))
  {
    if (ap.IsBound())
    {
      op->SetLogoWidgetRepresentation(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetLogoWidgetRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetLogoWidgetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogoWidgetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtk3DWidgetRepresentation *tempr = (ap.IsBound() ?
      op->GetLogoWidgetRepresentation() :
      op->vtkLogoSourceRepresentation::GetLogoWidgetRepresentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetInteractivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInteractivity(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetInteractivity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacity(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetOpacity() :
      op->vtkLogoSourceRepresentation::GetOpacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetInteractiveScaling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractiveScaling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInteractiveScaling(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetInteractiveScaling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetInteractiveScaling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractiveScaling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInteractiveScaling() :
      op->vtkLogoSourceRepresentation::GetInteractiveScaling());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_InteractiveScalingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveScalingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InteractiveScalingOn();
    }
    else
    {
      op->vtkLogoSourceRepresentation::InteractiveScalingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_InteractiveScalingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveScalingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InteractiveScalingOff();
    }
    else
    {
      op->vtkLogoSourceRepresentation::InteractiveScalingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_SetImageScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageScale(temp0);
    }
    else
    {
      op->vtkLogoSourceRepresentation::SetImageScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetImageScaleMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageScaleMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImageScaleMinValue() :
      op->vtkLogoSourceRepresentation::GetImageScaleMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetImageScaleMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageScaleMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImageScaleMaxValue() :
      op->vtkLogoSourceRepresentation::GetImageScaleMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_GetImageScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImageScale() :
      op->vtkLogoSourceRepresentation::GetImageScale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkLogoSourceRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkLogoSourceRepresentation *op = static_cast<vtkLogoSourceRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkLogoSourceRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkLogoSourceRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkLogoSourceRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkLogoSourceRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkLogoSourceRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkLogoSourceRepresentation\nC++: static vtkLogoSourceRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkLogoSourceRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkLogoSourceRepresentation\nC++: vtkLogoSourceRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkLogoSourceRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkLogoSourceRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLogoWidgetRepresentation", PyvtkLogoSourceRepresentation_SetLogoWidgetRepresentation, METH_VARARGS,
   "SetLogoWidgetRepresentation(self,\n    widget:vtk3DWidgetRepresentation) -> None\nC++: void SetLogoWidgetRepresentation(\n    vtk3DWidgetRepresentation *widget)\n\nSet the Logo widget.\n"},
  {"GetLogoWidgetRepresentation", PyvtkLogoSourceRepresentation_GetLogoWidgetRepresentation, METH_VARARGS,
   "GetLogoWidgetRepresentation(self) -> vtk3DWidgetRepresentation\nC++: virtual vtk3DWidgetRepresentation *GetLogoWidgetRepresentation(\n    )\n\n"},
  {"SetVisibility", PyvtkLogoSourceRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, __a:bool) -> None\nC++: void SetVisibility(bool) override;\n\nSet the visibility.\n"},
  {"SetInteractivity", PyvtkLogoSourceRepresentation_SetInteractivity, METH_VARARGS,
   "SetInteractivity(self, __a:bool) -> None\nC++: void SetInteractivity(bool)\n\nSet the interactivity.\n"},
  {"SetOpacity", PyvtkLogoSourceRepresentation_SetOpacity, METH_VARARGS,
   "SetOpacity(self, _arg:float) -> None\nC++: virtual void SetOpacity(double _arg)\n\nSet the opacity of the logo\n"},
  {"GetOpacity", PyvtkLogoSourceRepresentation_GetOpacity, METH_VARARGS,
   "GetOpacity(self) -> float\nC++: virtual double GetOpacity()\n\n"},
  {"SetInteractiveScaling", PyvtkLogoSourceRepresentation_SetInteractiveScaling, METH_VARARGS,
   "SetInteractiveScaling(self, _arg:bool) -> None\nC++: virtual void SetInteractiveScaling(bool _arg)\n\nSet/Get the scaling interactivity.\n"},
  {"GetInteractiveScaling", PyvtkLogoSourceRepresentation_GetInteractiveScaling, METH_VARARGS,
   "GetInteractiveScaling(self) -> bool\nC++: virtual bool GetInteractiveScaling()\n\n"},
  {"InteractiveScalingOn", PyvtkLogoSourceRepresentation_InteractiveScalingOn, METH_VARARGS,
   "InteractiveScalingOn(self) -> None\nC++: virtual void InteractiveScalingOn()\n\n"},
  {"InteractiveScalingOff", PyvtkLogoSourceRepresentation_InteractiveScalingOff, METH_VARARGS,
   "InteractiveScalingOff(self) -> None\nC++: virtual void InteractiveScalingOff()\n\n"},
  {"SetImageScale", PyvtkLogoSourceRepresentation_SetImageScale, METH_VARARGS,
   "SetImageScale(self, _arg:float) -> None\nC++: virtual void SetImageScale(double _arg)\n\nSet/Get the scale of the image relatively to screen height.\n"},
  {"GetImageScaleMinValue", PyvtkLogoSourceRepresentation_GetImageScaleMinValue, METH_VARARGS,
   "GetImageScaleMinValue(self) -> float\nC++: virtual double GetImageScaleMinValue()\n\n"},
  {"GetImageScaleMaxValue", PyvtkLogoSourceRepresentation_GetImageScaleMaxValue, METH_VARARGS,
   "GetImageScaleMaxValue(self) -> float\nC++: virtual double GetImageScaleMaxValue()\n\n"},
  {"GetImageScale", PyvtkLogoSourceRepresentation_GetImageScale, METH_VARARGS,
   "GetImageScale(self) -> float\nC++: virtual double GetImageScale()\n\n"},
  {"ProcessViewRequest", PyvtkLogoSourceRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkLogoSourceRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("logo_widget_representation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogoSourceRepresentation_GetLogoWidgetRepresentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetLogoWidgetRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetLogoWidgetRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLogoWidgetRepresentation/SetLogoWidgetRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactivity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetInteractivity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetInteractivity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInteractivity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogoSourceRepresentation_GetOpacity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOpacity/SetOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactive_scaling"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogoSourceRepresentation_GetInteractiveScaling(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetInteractiveScaling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetInteractiveScaling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInteractiveScaling/SetInteractiveScaling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkLogoSourceRepresentation_GetImageScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkLogoSourceRepresentation_SetImageScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkLogoSourceRepresentation_SetImageScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageScale/SetImageScale\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkLogoSourceRepresentation_Doc =
  "vtkLogoSourceRepresentation - vtkLogoSourceRepresentation is a\nrepresentation to show a Logo.\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
  "The input is expected to a be a vtkImageData that can be passed to a\n"
  "vtkLogoRepresentation.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkLogoSourceRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkLogoSourceRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkLogoSourceRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkLogoSourceRepresentation_StaticNew()
{
  return vtkLogoSourceRepresentation::New();
}

PyObject *PyvtkLogoSourceRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkLogoSourceRepresentation_Type, PyvtkLogoSourceRepresentation_Methods,
    "vtkLogoSourceRepresentation",
 &PyvtkLogoSourceRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkLogoSourceRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkLogoSourceRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkLogoSourceRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkLogoSourceRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

