// python wrapper for vtkSMPVRepresentationProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMPVRepresentationProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMPVRepresentationProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMPVRepresentationProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMRepresentationProxy_ClassNew
extern "C" { PyObject *PyvtkSMRepresentationProxy_ClassNew(); }
#define DECLARED_PyvtkSMRepresentationProxy_ClassNew
#endif

static PyObject *
PyvtkSMPVRepresentationProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMPVRepresentationProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMPVRepresentationProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMPVRepresentationProxy *tempr = vtkSMPVRepresentationProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMPVRepresentationProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMPVRepresentationProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMPVRepresentationProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMPVRepresentationProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetLastLUTProxy(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetLastLUTProxy."
    " (" "Use SetLastLookupTable instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetLastLUTProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetLastLUTProxy(temp0);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetLastLUTProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetLastLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetLastLookupTable(temp0);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetLastLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetLastLUTProxy(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method GetLastLUTProxy."
    " (" "Use GetLastLookupTable instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "GetLastLUTProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLastLUTProxy() :
      op->vtkSMPVRepresentationProxy::GetLastLUTProxy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetLastLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLastLookupTable() :
      op->vtkSMPVRepresentationProxy::GetLastLookupTable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetLastBlockLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastBlockLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetLastBlockLookupTable(temp0, temp1);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetLastBlockLookupTable(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetLastBlocksLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastBlocksLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetLastBlocksLookupTable(temp0, temp1);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetLastBlocksLookupTable(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetLastBlockLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastBlockLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLastBlockLookupTable(temp0) :
      op->vtkSMPVRepresentationProxy::GetLastBlockLookupTable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetUsingScalarColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUsingScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUsingScalarColoring() :
      op->vtkSMPVRepresentationProxy::GetUsingScalarColoring());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockUsingScalarColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockUsingScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBlockUsingScalarColoring(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlockUsingScalarColoring(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlocksUsingScalarColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlocksUsingScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetBlocksUsingScalarColoring(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlocksUsingScalarColoring(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetAnyBlockUsingScalarColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAnyBlockUsingScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAnyBlockUsingScalarColoring() :
      op->vtkSMPVRepresentationProxy::GetAnyBlockUsingScalarColoring());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetLUTProxy(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method GetLUTProxy."
    " (" "Use GetLookupTable instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "GetLUTProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLUTProxy(temp0) :
      op->vtkSMPVRepresentationProxy::GetLUTProxy(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetLookupTable(temp0) :
      op->vtkSMPVRepresentationProxy::GetLookupTable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetBlockLookupTable(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::GetBlockLookupTable(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_UpdateScalarBarRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateScalarBarRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->UpdateScalarBarRange(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::UpdateScalarBarRange(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_UpdateBlocksScalarBarRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateBlocksScalarBarRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->UpdateBlocksScalarBarRange(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::UpdateBlocksScalarBarRange(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetScalarColoring_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->SetScalarColoring(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::SetScalarColoring(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetScalarColoring_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->SetScalarColoring(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::SetScalarColoring(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMPVRepresentationProxy_SetScalarColoring_s1(self, args);
    case 3:
      return PyvtkSMPVRepresentationProxy_SetScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlockScalarColoring_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->SetBlockScalarColoring(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::SetBlockScalarColoring(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetBlockScalarColoring_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  const char *temp1 = nullptr;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    bool tempr = (ap.IsBound() ?
      op->SetBlockScalarColoring(temp0, temp1, temp2, temp3) :
      op->vtkSMPVRepresentationProxy::SetBlockScalarColoring(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetBlockScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMPVRepresentationProxy_SetBlockScalarColoring_s1(self, args);
    case 4:
      return PyvtkSMPVRepresentationProxy_SetBlockScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBlockScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlocksScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetBlocksScalarColoring(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::SetBlocksScalarColoring(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlocksScalarColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  const char *temp1 = nullptr;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetBlocksScalarColoring(temp0, temp1, temp2, temp3) :
      op->vtkSMPVRepresentationProxy::SetBlocksScalarColoring(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring_s1(self, args);
    case 4:
      return PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBlocksScalarColoring");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  bool temp0 = false;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToDataRange(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToDataRange(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  bool temp2 = false;
  bool temp3 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToDataRange(temp0, temp1, temp2, temp3) :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToDataRange(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_Methods[] = {
  {"RescaleTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s1, METH_VARARGS,
   "@|qq"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s2, METH_VARARGS,
   "@zi|qq"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
    case 1:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s1(self, args);
    case 3:
    case 4:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange_s2(self, args);
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlockTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  bool temp1 = false;
  bool temp2 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlockTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4) :
      op->vtkSMPVRepresentationProxy::RescaleBlockTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_Methods[] = {
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s1, METH_VARARGS,
   "@s|qq"},
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s2, METH_VARARGS,
   "@szi|qq"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s1(self, args);
    case 4:
    case 5:
      return PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlockTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlocksTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  bool temp1 = false;
  bool temp2 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlocksTransferFunctionToDataRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 5) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4) :
      op->vtkSMPVRepresentationProxy::RescaleBlocksTransferFunctionToDataRange(temp0, temp1, temp2, temp3, temp4));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_Methods[] = {
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s1, METH_VARARGS,
   "@T|qq s"},
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s2, METH_VARARGS,
   "@Tzi|qq s"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s1(self, args);
    case 4:
    case 5:
      return PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlocksTransferFunctionToDataRange");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToDataRangeOverTime() :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToDataRangeOverTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToDataRangeOverTime(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToDataRangeOverTime(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime_s1(self, args);
    case 2:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlockTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleBlockTransferFunctionToDataRangeOverTime(temp0) :
      op->vtkSMPVRepresentationProxy::RescaleBlockTransferFunctionToDataRangeOverTime(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlockTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleBlockTransferFunctionToDataRangeOverTime(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::RescaleBlockTransferFunctionToDataRangeOverTime(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime_s1(self, args);
    case 3:
      return PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlockTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlocksTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleBlocksTransferFunctionToDataRangeOverTime(temp0) :
      op->vtkSMPVRepresentationProxy::RescaleBlocksTransferFunctionToDataRangeOverTime(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleBlocksTransferFunctionToDataRangeOverTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->RescaleBlocksTransferFunctionToDataRangeOverTime(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::RescaleBlocksTransferFunctionToDataRangeOverTime(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime_s1(self, args);
    case 3:
      return PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleBlocksTransferFunctionToDataRangeOverTime");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToVisibleRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToVisibleRange(temp0) :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToVisibleRange(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RescaleTransferFunctionToVisibleRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->RescaleTransferFunctionToVisibleRange(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::RescaleTransferFunctionToVisibleRange(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange_s1(self, args);
    case 3:
      return PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RescaleTransferFunctionToVisibleRange");
  return nullptr;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetScalarBarVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarBarVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->SetScalarBarVisibility(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::SetScalarBarVisibility(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlockScalarBarVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockScalarBarVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->SetBlockScalarBarVisibility(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::SetBlockScalarBarVisibility(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlocksScalarBarVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlocksScalarBarVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()) &&
      ap.GetValue(temp2))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->SetBlocksScalarBarVisibility(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::SetBlocksScalarBarVisibility(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_HideScalarBarIfNotNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideScalarBarIfNotNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->HideScalarBarIfNotNeeded(temp0) :
      op->vtkSMPVRepresentationProxy::HideScalarBarIfNotNeeded(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_HideBlocksScalarBarIfNotNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideBlocksScalarBarIfNotNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->HideBlocksScalarBarIfNotNeeded(temp0) :
      op->vtkSMPVRepresentationProxy::HideBlocksScalarBarIfNotNeeded(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsScalarBarVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsScalarBarVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsScalarBarVisible(temp0) :
      op->vtkSMPVRepresentationProxy::IsScalarBarVisible(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsBlockScalarBarVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsBlockScalarBarVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->IsBlockScalarBarVisible(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::IsBlockScalarBarVisible(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsBlocksScalarBarVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsBlocksScalarBarVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->IsBlocksScalarBarVisible(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::IsBlocksScalarBarVisible(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetArrayInformationForColorArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayInformationForColorArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  bool temp0 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    vtkPVArrayInformation *tempr = (ap.IsBound() ?
      op->GetArrayInformationForColorArray(temp0) :
      op->vtkSMPVRepresentationProxy::GetArrayInformationForColorArray(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockArrayInformationForColorArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockArrayInformationForColorArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVArrayInformation *tempr = (ap.IsBound() ?
      op->GetBlockArrayInformationForColorArray(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlockArrayInformationForColorArray(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetProminentValuesInformationForColorArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProminentValuesInformationForColorArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  double temp0 = 1e-6;
  double temp1 = 1e-3;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPVProminentValuesInformation *tempr = (ap.IsBound() ?
      op->GetProminentValuesInformationForColorArray(temp0, temp1, temp2) :
      op->vtkSMPVRepresentationProxy::GetProminentValuesInformationForColorArray(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockProminentValuesInformationForColorArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockProminentValuesInformationForColorArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  double temp1 = 1e-6;
  double temp2 = 1e-3;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 4) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPVProminentValuesInformation *tempr = (ap.IsBound() ?
      op->GetBlockProminentValuesInformationForColorArray(temp0, temp1, temp2, temp3) :
      op->vtkSMPVRepresentationProxy::GetBlockProminentValuesInformationForColorArray(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetEstimatedNumberOfAnnotationsOnScalarBar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEstimatedNumberOfAnnotationsOnScalarBar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    int tempr = (ap.IsBound() ?
      op->GetEstimatedNumberOfAnnotationsOnScalarBar(temp0) :
      op->vtkSMPVRepresentationProxy::GetEstimatedNumberOfAnnotationsOnScalarBar(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockEstimatedNumberOfAnnotationsOnScalarBar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockEstimatedNumberOfAnnotationsOnScalarBar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlockEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::GetBlockEstimatedNumberOfAnnotationsOnScalarBar(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlocksEstimatedNumberOfAnnotationsOnScalarBars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetRepresentationType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentationType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->SetRepresentationType(temp0) :
      op->vtkSMPVRepresentationProxy::SetRepresentationType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetVolumeIndependentRanges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVolumeIndependentRanges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVolumeIndependentRanges() :
      op->vtkSMPVRepresentationProxy::GetVolumeIndependentRanges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsScalarBarStickyVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsScalarBarStickyVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    int tempr = (ap.IsBound() ?
      op->IsScalarBarStickyVisible(temp0) :
      op->vtkSMPVRepresentationProxy::IsScalarBarStickyVisible(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsBlockScalarBarStickyVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsBlockScalarBarStickyVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->IsBlockScalarBarStickyVisible(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::IsBlockScalarBarStickyVisible(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_IsBlocksScalarBarStickyVisible(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsBlocksScalarBarStickyVisible");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  std::vector<std::string> temp1(ap.GetArgSize(1));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetArray(temp1.data(), temp1.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->IsBlocksScalarBarStickyVisible(temp0, temp1) :
      op->vtkSMPVRepresentationProxy::IsBlocksScalarBarStickyVisible(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_ViewUpdated(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ViewUpdated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->ViewUpdated(temp0);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::ViewUpdated(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockColorArrayAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockColorArrayAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlockColorArrayAssociation(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlockColorArrayAssociation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockColorArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockColorArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetBlockColorArrayName(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlockColorArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlockUseSeparateColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockUseSeparateColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetBlockUseSeparateColorMap(temp0, temp1);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetBlockUseSeparateColorMap(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_SetBlocksUseSeparateColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlocksUseSeparateColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetBlocksUseSeparateColorMap(temp0, temp1);
    }
    else
    {
      op->vtkSMPVRepresentationProxy::SetBlocksUseSeparateColorMap(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlockUseSeparateColorMap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockUseSeparateColorMap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBlockUseSeparateColorMap(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlockUseSeparateColorMap(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMPVRepresentationProxy_GetBlocksUseSeparateColorMaps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlocksUseSeparateColorMaps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMPVRepresentationProxy *op = static_cast<vtkSMPVRepresentationProxy *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetBlocksUseSeparateColorMaps(temp0) :
      op->vtkSMPVRepresentationProxy::GetBlocksUseSeparateColorMaps(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyMethodDef PyvtkSMPVRepresentationProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMPVRepresentationProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMPVRepresentationProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMPVRepresentationProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMPVRepresentationProxy\nC++: static vtkSMPVRepresentationProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMPVRepresentationProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMPVRepresentationProxy\nC++: vtkSMPVRepresentationProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMPVRepresentationProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMPVRepresentationProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLastLUTProxy", PyvtkSMPVRepresentationProxy_SetLastLUTProxy, METH_VARARGS,
   "SetLastLUTProxy(self, proxy:vtkSMProxy) -> None\nC++: void SetLastLUTProxy(vtkSMProxy *proxy)\n\nSet/get last LUT proxy. Used as a memory of what was the last LUT\nproxy linked to this representation.\n"},
  {"SetLastLookupTable", PyvtkSMPVRepresentationProxy_SetLastLookupTable, METH_VARARGS,
   "SetLastLookupTable(self, proxy:vtkSMProxy) -> None\nC++: void SetLastLookupTable(vtkSMProxy *proxy)\n\n"},
  {"GetLastLUTProxy", PyvtkSMPVRepresentationProxy_GetLastLUTProxy, METH_VARARGS,
   "GetLastLUTProxy(self) -> vtkSMProxy\nC++: vtkSMProxy *GetLastLUTProxy()\n\n"},
  {"GetLastLookupTable", PyvtkSMPVRepresentationProxy_GetLastLookupTable, METH_VARARGS,
   "GetLastLookupTable(self) -> vtkSMProxy\nC++: vtkSMProxy *GetLastLookupTable()\n\n"},
  {"SetLastBlockLookupTable", PyvtkSMPVRepresentationProxy_SetLastBlockLookupTable, METH_VARARGS,
   "SetLastBlockLookupTable(self, blockSelector:str, proxy:vtkSMProxy)\n     -> None\nC++: void SetLastBlockLookupTable(\n    const std::string &blockSelector, vtkSMProxy *proxy)\n\n"},
  {"SetLastBlocksLookupTable", PyvtkSMPVRepresentationProxy_SetLastBlocksLookupTable, METH_VARARGS,
   "SetLastBlocksLookupTable(self, blockSelectors:(str, ...),\n    proxy:vtkSMProxy) -> None\nC++: void SetLastBlocksLookupTable(\n    const std::vector<std::string> &blockSelectors,\n    vtkSMProxy *proxy)\n\n"},
  {"GetLastBlockLookupTable", PyvtkSMPVRepresentationProxy_GetLastBlockLookupTable, METH_VARARGS,
   "GetLastBlockLookupTable(self, blockSelector:str) -> vtkSMProxy\nC++: vtkSMProxy *GetLastBlockLookupTable(\n    const std::string &blockSelector)\n\n"},
  {"GetUsingScalarColoring", PyvtkSMPVRepresentationProxy_GetUsingScalarColoring, METH_VARARGS,
   "GetUsingScalarColoring(self) -> bool\nC++: virtual bool GetUsingScalarColoring()\n\nReturns true if scalar coloring is enabled. This checks whether a\nproperty named \"ColorArrayName\" exists and has a non-empty\nstring. This does not check for the validity of the array.\n"},
  {"GetBlockUsingScalarColoring", PyvtkSMPVRepresentationProxy_GetBlockUsingScalarColoring, METH_VARARGS,
   "GetBlockUsingScalarColoring(self, blockSelector:str) -> bool\nC++: virtual bool GetBlockUsingScalarColoring(\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksUsingScalarColoring", PyvtkSMPVRepresentationProxy_GetBlocksUsingScalarColoring, METH_VARARGS,
   "GetBlocksUsingScalarColoring(self, blockSelectors:(str, ...)) -> (\n    int, ...)\nC++: virtual std::vector<vtkTypeBool> GetBlocksUsingScalarColoring(\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetAnyBlockUsingScalarColoring", PyvtkSMPVRepresentationProxy_GetAnyBlockUsingScalarColoring, METH_VARARGS,
   "GetAnyBlockUsingScalarColoring(self) -> bool\nC++: virtual bool GetAnyBlockUsingScalarColoring()\n\n"},
  {"GetLUTProxy", PyvtkSMPVRepresentationProxy_GetLUTProxy, METH_VARARGS,
   "GetLUTProxy(self, view:vtkSMProxy) -> vtkSMProxy\nC++: vtkSMProxy *GetLUTProxy(vtkSMProxy *view)\n\nReturns the lut proxy of this representation in the given view.\nThis method will return `nullptr` if no lut proxy exists in this\nview.\n"},
  {"GetLookupTable", PyvtkSMPVRepresentationProxy_GetLookupTable, METH_VARARGS,
   "GetLookupTable(self, view:vtkSMProxy) -> vtkSMProxy\nC++: vtkSMProxy *GetLookupTable(vtkSMProxy *view)\n\n"},
  {"GetBlockLookupTable", PyvtkSMPVRepresentationProxy_GetBlockLookupTable, METH_VARARGS,
   "GetBlockLookupTable(self, view:vtkSMProxy, blockSelector:str)\n    -> vtkSMProxy\nC++: vtkSMProxy *GetBlockLookupTable(vtkSMProxy *view,\n    const std::string &blockSelector)\n\n"},
  {"UpdateScalarBarRange", PyvtkSMPVRepresentationProxy_UpdateScalarBarRange, METH_VARARGS,
   "UpdateScalarBarRange(self, view:vtkSMProxy, deleteRange:bool)\n    -> bool\nC++: bool UpdateScalarBarRange(vtkSMProxy *view, bool deleteRange)\n\nUpdates the ranges shown in the scalar bar. If deleteRange is\ntrue, then the range stored for current representation proxy is\ndeleted. This should be done when the scalar bar gets separated\nor becomes not visible. If deleteRange is false, then the range\nstored for current representation proxy is updated with the new\nrange value.\n"},
  {"UpdateBlocksScalarBarRange", PyvtkSMPVRepresentationProxy_UpdateBlocksScalarBarRange, METH_VARARGS,
   "UpdateBlocksScalarBarRange(self, view:vtkSMProxy,\n    deleteRange:bool) -> (int, ...)\nC++: std::vector<vtkTypeBool> UpdateBlocksScalarBarRange(\n    vtkSMProxy *view, bool deleteRange)\n\n"},
  {"SetScalarColoring", PyvtkSMPVRepresentationProxy_SetScalarColoring, METH_VARARGS,
   "SetScalarColoring(self, arrayName:str, attributeType:int) -> bool\nC++: virtual bool SetScalarColoring(const char *arrayName,\n    int attributeType)\nSetScalarColoring(self, arrayName:str, attributeType:int,\n    component:int) -> bool\nC++: virtual bool SetScalarColoring(const char *arrayName,\n    int attributeType, int component)\n\nEnable/disable scalar coloring using the specified array. This\nwill set up a color and opacity transfer functions using\nvtkSMTransferFunctionProxy instance. If arrayName is nullptr,\nthen scalar coloring is turned off.attributeType must be one of\nvtkDataObject::AttributeTypes.\n"},
  {"SetBlockScalarColoring", PyvtkSMPVRepresentationProxy_SetBlockScalarColoring, METH_VARARGS,
   "SetBlockScalarColoring(self, blockSelector:str, arrayName:str,\n    attributeType:int) -> bool\nC++: virtual bool SetBlockScalarColoring(\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType)\nSetBlockScalarColoring(self, blockSelector:str, arrayName:str,\n    attributeType:int, component:int) -> bool\nC++: virtual bool SetBlockScalarColoring(\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType, int component)\n\n"},
  {"SetBlocksScalarColoring", PyvtkSMPVRepresentationProxy_SetBlocksScalarColoring, METH_VARARGS,
   "SetBlocksScalarColoring(self, blockSelectors:(str, ...),\n    arrayName:str, attributeType:int) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> SetBlocksScalarColoring(\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType)\nSetBlocksScalarColoring(self, blockSelectors:(str, ...),\n    arrayName:str, attributeType:int, component:int) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> SetBlocksScalarColoring(\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType, int component)\n\n"},
  {"RescaleTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRange, METH_VARARGS,
   "RescaleTransferFunctionToDataRange(self, extend:bool=False,\n    force:bool=True) -> bool\nC++: virtual bool RescaleTransferFunctionToDataRange(\n    bool extend=false, bool force=true)\nRescaleTransferFunctionToDataRange(self, arrayName:str,\n    attributeType:int, extend:bool=False, force:bool=True) -> bool\nC++: virtual bool RescaleTransferFunctionToDataRange(\n    const char *arrayName, int attributeType, bool extend=false,\n    bool force=true)\n\nRescales the color transfer function and opacity transfer\nfunction using the current data range. Returns true if rescale\nwas successful. If extend is true (false by default), the\ntransfer function range will only be extended as needed to fit\nthe data range. If force is false (true by default), then the\ntransfer function range is not changed if locked.\n\nblockSelector the block selector. extend Extend existing range\ninstead of clamping to the new range (default: false). force\nUpdate transfer function even if the range is locked (default:\ntrue).\n"},
  {"RescaleBlockTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRange, METH_VARARGS,
   "RescaleBlockTransferFunctionToDataRange(self, blockSelector:str,\n    extend:bool=False, force:bool=True) -> bool\nC++: virtual bool RescaleBlockTransferFunctionToDataRange(\n    const std::string &blockSelector, bool extend=false,\n    bool force=true)\nRescaleBlockTransferFunctionToDataRange(self, blockSelector:str,\n    arrayName:str, attributeType:int, extend:bool=False,\n    force:bool=True) -> bool\nC++: virtual bool RescaleBlockTransferFunctionToDataRange(\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType, bool extend=false, bool force=true)\n\n"},
  {"RescaleBlocksTransferFunctionToDataRange", PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRange, METH_VARARGS,
   "RescaleBlocksTransferFunctionToDataRange(self, blockSelectors:(\n    str, ...), extend:bool=False, force:bool=True) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRange(\n    const std::vector<std::string> &blockSelectors,\n    bool extend=false, bool force=true)\nRescaleBlocksTransferFunctionToDataRange(self, blockSelectors:(\n    str, ...), arrayName:str, attributeType:int,\n    extend:bool=False, force:bool=True) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRange(\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType, bool extend=false,\n    bool force=true)\n\n"},
  {"RescaleTransferFunctionToDataRangeOverTime", PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleTransferFunctionToDataRangeOverTime(self) -> bool\nC++: virtual bool RescaleTransferFunctionToDataRangeOverTime()\nRescaleTransferFunctionToDataRangeOverTime(self, arrayName:str,\n    attributeType:int) -> bool\nC++: virtual bool RescaleTransferFunctionToDataRangeOverTime(\n    const char *arrayName, int attributeType)\n\nRescales the color transfer function and opacity transfer\nfunction using the current data range over time. Returns true if\nrescale was successful.\n"},
  {"RescaleBlockTransferFunctionToDataRangeOverTime", PyvtkSMPVRepresentationProxy_RescaleBlockTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleBlockTransferFunctionToDataRangeOverTime(self,\n    blockSelector:str) -> bool\nC++: virtual bool RescaleBlockTransferFunctionToDataRangeOverTime(\n    const std::string &blockSelector)\nRescaleBlockTransferFunctionToDataRangeOverTime(self,\n    blockSelector:str, arrayName:str, attributeType:int) -> bool\nC++: virtual bool RescaleBlockTransferFunctionToDataRangeOverTime(\n    const std::string &blockSelector, const char *arrayName,\n    int attributeType)\n\n"},
  {"RescaleBlocksTransferFunctionToDataRangeOverTime", PyvtkSMPVRepresentationProxy_RescaleBlocksTransferFunctionToDataRangeOverTime, METH_VARARGS,
   "RescaleBlocksTransferFunctionToDataRangeOverTime(self,\n    blockSelectors:(str, ...)) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRangeOverTime(\n    const std::vector<std::string> &blockSelectors)\nRescaleBlocksTransferFunctionToDataRangeOverTime(self,\n    blockSelectors:(str, ...), arrayName:str, attributeType:int)\n    -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> RescaleBlocksTransferFunctionToDataRangeOverTime(\n    const std::vector<std::string> &blockSelectors,\n    const char *arrayName, int attributeType)\n\n"},
  {"RescaleTransferFunctionToVisibleRange", PyvtkSMPVRepresentationProxy_RescaleTransferFunctionToVisibleRange, METH_VARARGS,
   "RescaleTransferFunctionToVisibleRange(self, view:vtkSMProxy)\n    -> bool\nC++: virtual bool RescaleTransferFunctionToVisibleRange(\n    vtkSMProxy *view)\nRescaleTransferFunctionToVisibleRange(self, view:vtkSMProxy,\n    arrayName:str, attributeType:int) -> bool\nC++: virtual bool RescaleTransferFunctionToVisibleRange(\n    vtkSMProxy *view, const char *arrayName, int attributeType)\n\nRescales the color transfer function and the opacity transfer\nfunction using the current data range, limited to the currernt\nvisible elements.\n"},
  {"SetScalarBarVisibility", PyvtkSMPVRepresentationProxy_SetScalarBarVisibility, METH_VARARGS,
   "SetScalarBarVisibility(self, view:vtkSMProxy, visible:bool)\n    -> bool\nC++: virtual bool SetScalarBarVisibility(vtkSMProxy *view,\n    bool visible)\n\nSet the scalar bar visibility. This will create a new scalar bar\nas needed. Scalar bar is only shown if scalar coloring is indeed\nbeing used.\n"},
  {"SetBlockScalarBarVisibility", PyvtkSMPVRepresentationProxy_SetBlockScalarBarVisibility, METH_VARARGS,
   "SetBlockScalarBarVisibility(self, view:vtkSMProxy,\n    blockSelector:str, visible:bool) -> bool\nC++: virtual bool SetBlockScalarBarVisibility(vtkSMProxy *view,\n    const std::string &blockSelector, bool visible)\n\n"},
  {"SetBlocksScalarBarVisibility", PyvtkSMPVRepresentationProxy_SetBlocksScalarBarVisibility, METH_VARARGS,
   "SetBlocksScalarBarVisibility(self, view:vtkSMProxy,\n    blockSelectors:(str, ...), visible:bool) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> SetBlocksScalarBarVisibility(\n    vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors, bool visible)\n\n"},
  {"HideScalarBarIfNotNeeded", PyvtkSMPVRepresentationProxy_HideScalarBarIfNotNeeded, METH_VARARGS,
   "HideScalarBarIfNotNeeded(self, view:vtkSMProxy) -> bool\nC++: virtual bool HideScalarBarIfNotNeeded(vtkSMProxy *view)\n\nWhile SetScalarBarVisibility can be used to hide a scalar bar, it\nwill always simply hide the scalar bar even if its being used by\nsome other representation. Use this method instead to only hide\nthe scalar/color bar if no other visible representation in the\nview is mapping data using the scalar bar.\n"},
  {"HideBlocksScalarBarIfNotNeeded", PyvtkSMPVRepresentationProxy_HideBlocksScalarBarIfNotNeeded, METH_VARARGS,
   "HideBlocksScalarBarIfNotNeeded(self, view:vtkSMProxy) -> bool\nC++: virtual bool HideBlocksScalarBarIfNotNeeded(vtkSMProxy *view)\n\n"},
  {"IsScalarBarVisible", PyvtkSMPVRepresentationProxy_IsScalarBarVisible, METH_VARARGS,
   "IsScalarBarVisible(self, view:vtkSMProxy) -> bool\nC++: virtual bool IsScalarBarVisible(vtkSMProxy *view)\n\nCheck scalar bar visibility.  Return true if the scalar bar for\nthis representation and view is visible, return false otherwise.\n"},
  {"IsBlockScalarBarVisible", PyvtkSMPVRepresentationProxy_IsBlockScalarBarVisible, METH_VARARGS,
   "IsBlockScalarBarVisible(self, view:vtkSMProxy, blockSelector:str)\n    -> bool\nC++: virtual bool IsBlockScalarBarVisible(vtkSMProxy *view,\n    const std::string &blockSelector)\n\n"},
  {"IsBlocksScalarBarVisible", PyvtkSMPVRepresentationProxy_IsBlocksScalarBarVisible, METH_VARARGS,
   "IsBlocksScalarBarVisible(self, view:vtkSMProxy, blockSelectors:(\n    str, ...)) -> (int, ...)\nC++: virtual std::vector<vtkTypeBool> IsBlocksScalarBarVisible(\n    vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"GetArrayInformationForColorArray", PyvtkSMPVRepresentationProxy_GetArrayInformationForColorArray, METH_VARARGS,
   "GetArrayInformationForColorArray(self,\n    checkRepresentedData:bool=True) -> vtkPVArrayInformation\nC++: virtual vtkPVArrayInformation *GetArrayInformationForColorArray(\n    bool checkRepresentedData=true)\n\nReturns the array information for the data array used for scalar\ncoloring, from input data. If checkRepresentedData is true, it\nwill also check in the represented data. Default is true. If none\nis found, returns nullptr.\n"},
  {"GetBlockArrayInformationForColorArray", PyvtkSMPVRepresentationProxy_GetBlockArrayInformationForColorArray, METH_VARARGS,
   "GetBlockArrayInformationForColorArray(self, blockSelector:str)\n    -> vtkPVArrayInformation\nC++: virtual vtkPVArrayInformation *GetBlockArrayInformationForColorArray(\n    const std::string &blockSelector)\n\n"},
  {"GetProminentValuesInformationForColorArray", PyvtkSMPVRepresentationProxy_GetProminentValuesInformationForColorArray, METH_VARARGS,
   "GetProminentValuesInformationForColorArray(self,\n    uncertaintyAllowed:float=1e-6, fraction:float=1e-3,\n    force:bool=False) -> vtkPVProminentValuesInformation\nC++: virtual vtkPVProminentValuesInformation *GetProminentValuesInformationForColorArray(\n    double uncertaintyAllowed=1e-6, double fraction=1e-3,\n    bool force=false)\n\nCall vtkSMRepresentationProxy::GetProminentValuesInformation()\nfor the array used for scalar color, if any. Otherwise returns\nnullptr.\n"},
  {"GetBlockProminentValuesInformationForColorArray", PyvtkSMPVRepresentationProxy_GetBlockProminentValuesInformationForColorArray, METH_VARARGS,
   "GetBlockProminentValuesInformationForColorArray(self,\n    blockSelector:str, uncertaintyAllowed:float=1e-6,\n    fraction:float=1e-3, force:bool=False)\n    -> vtkPVProminentValuesInformation\nC++: virtual vtkPVProminentValuesInformation *GetBlockProminentValuesInformationForColorArray(\n    const std::string &blockSelector,\n    double uncertaintyAllowed=1e-6, double fraction=1e-3,\n    bool force=false)\n\n"},
  {"GetEstimatedNumberOfAnnotationsOnScalarBar", PyvtkSMPVRepresentationProxy_GetEstimatedNumberOfAnnotationsOnScalarBar, METH_VARARGS,
   "GetEstimatedNumberOfAnnotationsOnScalarBar(self, view:vtkSMProxy)\n    -> int\nC++: int GetEstimatedNumberOfAnnotationsOnScalarBar(\n    vtkSMProxy *view)\n\nGet an estimated number of annotation shown on this\nrepresentation scalar bar\n"},
  {"GetBlockEstimatedNumberOfAnnotationsOnScalarBar", PyvtkSMPVRepresentationProxy_GetBlockEstimatedNumberOfAnnotationsOnScalarBar, METH_VARARGS,
   "GetBlockEstimatedNumberOfAnnotationsOnScalarBar(self,\n    view:vtkSMProxy, blockSelector:str) -> int\nC++: int GetBlockEstimatedNumberOfAnnotationsOnScalarBar(\n    vtkSMProxy *view, const std::string &blockSelector)\n\n"},
  {"GetBlocksEstimatedNumberOfAnnotationsOnScalarBars", PyvtkSMPVRepresentationProxy_GetBlocksEstimatedNumberOfAnnotationsOnScalarBars, METH_VARARGS,
   "GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(self,\n    view:vtkSMProxy, blockSelectors:(str, ...)) -> (int, ...)\nC++: std::vector<int> GetBlocksEstimatedNumberOfAnnotationsOnScalarBars(\n    vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"SetRepresentationType", PyvtkSMPVRepresentationProxy_SetRepresentationType, METH_VARARGS,
   "SetRepresentationType(self, type:str) -> bool\nC++: bool SetRepresentationType(const char *type) override;\n\nOverridden to ensure when picking representation types that\nrequire scalar colors, scalar coloring it setup properly.\nCurrently this is hard-coded for Volume and Slice representation\ntypes.\n"},
  {"GetVolumeIndependentRanges", PyvtkSMPVRepresentationProxy_GetVolumeIndependentRanges, METH_VARARGS,
   "GetVolumeIndependentRanges(self) -> bool\nC++: bool GetVolumeIndependentRanges()\n\nTrue if ranges have to be computed independently on component 0\nfor the color and 1 for the opacity on the Volume representation.\n"},
  {"IsScalarBarStickyVisible", PyvtkSMPVRepresentationProxy_IsScalarBarStickyVisible, METH_VARARGS,
   "IsScalarBarStickyVisible(self, view:vtkSMProxy) -> int\nC++: int IsScalarBarStickyVisible(vtkSMProxy *view)\n\nChecks if the scalar bar of this representation in view is sticky\nvisible, i.e. should be visible whenever this representation is\nalso visible. It returns 1 if the scalar bar is sticky visible, 0\nother wise. If any problem is encountered, for example if view ==\nnullptr, or if the scalar bar representation is not instanciated\n/ found, it returns -1.\n"},
  {"IsBlockScalarBarStickyVisible", PyvtkSMPVRepresentationProxy_IsBlockScalarBarStickyVisible, METH_VARARGS,
   "IsBlockScalarBarStickyVisible(self, view:vtkSMProxy,\n    blockSelector:str) -> int\nC++: int IsBlockScalarBarStickyVisible(vtkSMProxy *view,\n    const std::string &blockSelector)\n\n"},
  {"IsBlocksScalarBarStickyVisible", PyvtkSMPVRepresentationProxy_IsBlocksScalarBarStickyVisible, METH_VARARGS,
   "IsBlocksScalarBarStickyVisible(self, view:vtkSMProxy,\n    blockSelectors:(str, ...)) -> (int, ...)\nC++: std::vector<int> IsBlocksScalarBarStickyVisible(\n    vtkSMProxy *view,\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {"ViewUpdated", PyvtkSMPVRepresentationProxy_ViewUpdated, METH_VARARGS,
   "ViewUpdated(self, view:vtkSMProxy) -> None\nC++: void ViewUpdated(vtkSMProxy *view) override;\n\nCalled after the view updates.\n"},
  {"GetBlockColorArrayAssociation", PyvtkSMPVRepresentationProxy_GetBlockColorArrayAssociation, METH_VARARGS,
   "GetBlockColorArrayAssociation(self, blockSelector:str) -> int\nC++: int GetBlockColorArrayAssociation(\n    const std::string &blockSelector)\n\n"},
  {"GetBlockColorArrayName", PyvtkSMPVRepresentationProxy_GetBlockColorArrayName, METH_VARARGS,
   "GetBlockColorArrayName(self, blockSelector:str) -> str\nC++: std::string GetBlockColorArrayName(\n    const std::string &blockSelector)\n\n"},
  {"SetBlockUseSeparateColorMap", PyvtkSMPVRepresentationProxy_SetBlockUseSeparateColorMap, METH_VARARGS,
   "SetBlockUseSeparateColorMap(self, blockSelector:str, use:bool)\n    -> None\nC++: void SetBlockUseSeparateColorMap(\n    const std::string &blockSelector, bool use)\n\nSet/Get if we should use a separate color map for this block.\n"},
  {"SetBlocksUseSeparateColorMap", PyvtkSMPVRepresentationProxy_SetBlocksUseSeparateColorMap, METH_VARARGS,
   "SetBlocksUseSeparateColorMap(self, blockSelectors:(str, ...),\n    use:bool) -> None\nC++: void SetBlocksUseSeparateColorMap(\n    const std::vector<std::string> &blockSelectors, bool use)\n\n"},
  {"GetBlockUseSeparateColorMap", PyvtkSMPVRepresentationProxy_GetBlockUseSeparateColorMap, METH_VARARGS,
   "GetBlockUseSeparateColorMap(self, blockSelector:str) -> bool\nC++: bool GetBlockUseSeparateColorMap(\n    const std::string &blockSelector)\n\n"},
  {"GetBlocksUseSeparateColorMaps", PyvtkSMPVRepresentationProxy_GetBlocksUseSeparateColorMaps, METH_VARARGS,
   "GetBlocksUseSeparateColorMaps(self, blockSelectors:(str, ...))\n    -> (int, ...)\nC++: std::vector<vtkTypeBool> GetBlocksUseSeparateColorMaps(\n    const std::vector<std::string> &blockSelectors)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMPVRepresentationProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("last_lut_proxy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPVRepresentationProxy_GetLastLUTProxy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPVRepresentationProxy_SetLastLUTProxy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPVRepresentationProxy_SetLastLUTProxy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLastLUTProxy/SetLastLUTProxy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_lookup_table"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPVRepresentationProxy_GetLastLookupTable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMPVRepresentationProxy_SetLastLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMPVRepresentationProxy_SetLastLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLastLookupTable/SetLastLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("using_scalar_coloring"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPVRepresentationProxy_GetUsingScalarColoring(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUsingScalarColoring\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("any_block_using_scalar_coloring"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPVRepresentationProxy_GetAnyBlockUsingScalarColoring(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAnyBlockUsingScalarColoring\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("volume_independent_ranges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMPVRepresentationProxy_GetVolumeIndependentRanges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVolumeIndependentRanges\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMPVRepresentationProxy_Doc =
  "vtkSMPVRepresentationProxy - representation for \"Render View\" like\nviews in ParaView.\n\n"
  "Superclass: vtkSMRepresentationProxy\n\n"
  "vtkSMPVRepresentationProxy combines surface representation and volume\n"
  "representation proxies typically used for displaying data. This class\n"
  "also takes over the selection obligations for all the internal\n"
  "representations, i.e. is disables showing of selection in all the\n"
  "internal representations, and manages it. This avoids duplicate\n"
  "execution of extract selection filter for each of the internal\n"
  "representations.\n\n"
  "vtkSMPVRepresentationProxy is used for pretty much all of the\n"
  "data-representations (i.e. representations showing input data) in the\n"
  "render views. It provides helper functions redirecting to\n"
  "vtkSMColorMapEditorHelper for controlling transfer functions, scalar\n"
  "coloring, etc.\n\n"
  "@sa vtkSMColorMapEditorHelper\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMPVRepresentationProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMPVRepresentationProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMPVRepresentationProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMPVRepresentationProxy_StaticNew()
{
  return vtkSMPVRepresentationProxy::New();
}

PyObject *PyvtkSMPVRepresentationProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMPVRepresentationProxy_Type, PyvtkSMPVRepresentationProxy_Methods,
    "vtkSMPVRepresentationProxy",
 &PyvtkSMPVRepresentationProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMRepresentationProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMPVRepresentationProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMPVRepresentationProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMPVRepresentationProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMPVRepresentationProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

