/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtBluetooth/qbluetoothdeviceinfo.sip"
#include <qbluetoothdeviceinfo.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"

#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtBluetooth/qbluetoothaddress.sip"
#include <qbluetoothaddress.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtBluetooth/qbluetoothuuid.sip"
#include <qbluetoothuuid.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 109 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtBluetooth/qpybluetooth_qmultihash.sip"
#include <QMultiHash>
#line 45 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtBluetooth/qpybluetooth_qmultihash.sip"
#include <QMultiHash>
#line 51 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 991 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 54 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 57 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 60 "/build/pyqt6/src/pyqt6-6.10.2/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_isValid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_isValid, doc_QBluetoothDeviceInfo_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_isCached, "isCached(self) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_isCached(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_isCached(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isCached();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_isCached, doc_QBluetoothDeviceInfo_isCached);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setCached, "setCached(self, cached: bool)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setCached(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setCached(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            sipCpp->setCached(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setCached, doc_QBluetoothDeviceInfo_setCached);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_address, "address(self) -> QBluetoothAddress");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_address(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_address(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothAddress*sipRes;

            sipRes = new ::QBluetoothAddress(sipCpp->address());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_address, doc_QBluetoothDeviceInfo_address);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_name, "name(self) -> str");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_name(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_name, doc_QBluetoothDeviceInfo_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceClasses, "serviceClasses(self) -> QBluetoothDeviceInfo.ServiceClass");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceClasses(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceClasses(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::ServiceClasses*sipRes;

            sipRes = new ::QBluetoothDeviceInfo::ServiceClasses(sipCpp->serviceClasses());

            return sipConvertFromNewType(sipRes, sipType_QFlags_0100QBluetoothDeviceInfo_ServiceClass, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceClasses, doc_QBluetoothDeviceInfo_serviceClasses);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_majorDeviceClass, "majorDeviceClass(self) -> QBluetoothDeviceInfo.MajorDeviceClass");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_majorDeviceClass(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_majorDeviceClass(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::MajorDeviceClass sipRes;

            sipRes = sipCpp->majorDeviceClass();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QBluetoothDeviceInfo_MajorDeviceClass);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_majorDeviceClass, doc_QBluetoothDeviceInfo_majorDeviceClass);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_minorDeviceClass, "minorDeviceClass(self) -> int");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_minorDeviceClass(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_minorDeviceClass(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::quint8 sipRes;

            sipRes = sipCpp->minorDeviceClass();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_minorDeviceClass, doc_QBluetoothDeviceInfo_minorDeviceClass);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_rssi, "rssi(self) -> int");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_rssi(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_rssi(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::qint16 sipRes;

            sipRes = sipCpp->rssi();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_rssi, doc_QBluetoothDeviceInfo_rssi);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setRssi, "setRssi(self, signal: int)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setRssi(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setRssi(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint16 a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bh", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            sipCpp->setRssi(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setRssi, doc_QBluetoothDeviceInfo_setRssi);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setServiceUuids, "setServiceUuids(self, uuids: Iterable[QBluetoothUuid])");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setServiceUuids(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setServiceUuids(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QList< ::QBluetoothUuid>* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QList_0100QBluetoothUuid, &a0, &a0State))
        {
            sipCpp->setServiceUuids(*a0);
            sipReleaseType(const_cast<QList< ::QBluetoothUuid> *>(a0), sipType_QList_0100QBluetoothUuid, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setServiceUuids, doc_QBluetoothDeviceInfo_setServiceUuids);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceUuids, "serviceUuids(self) -> list[QBluetoothUuid]");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceUuids(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceUuids(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QList< ::QBluetoothUuid>*sipRes;

            sipRes = new QList< ::QBluetoothUuid>(sipCpp->serviceUuids());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceUuids, doc_QBluetoothDeviceInfo_serviceUuids);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setCoreConfigurations, "setCoreConfigurations(self, coreConfigs: QBluetoothDeviceInfo.CoreConfiguration)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setCoreConfigurations(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setCoreConfigurations(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothDeviceInfo::CoreConfigurations* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QFlags_0100QBluetoothDeviceInfo_CoreConfiguration, &a0, &a0State))
        {
            sipCpp->setCoreConfigurations(*a0);
            sipReleaseType(a0, sipType_QFlags_0100QBluetoothDeviceInfo_CoreConfiguration, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setCoreConfigurations, doc_QBluetoothDeviceInfo_setCoreConfigurations);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_coreConfigurations, "coreConfigurations(self) -> QBluetoothDeviceInfo.CoreConfiguration");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_coreConfigurations(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_coreConfigurations(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::CoreConfigurations*sipRes;

            sipRes = new ::QBluetoothDeviceInfo::CoreConfigurations(sipCpp->coreConfigurations());

            return sipConvertFromNewType(sipRes, sipType_QFlags_0100QBluetoothDeviceInfo_CoreConfiguration, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_coreConfigurations, doc_QBluetoothDeviceInfo_coreConfigurations);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setDeviceUuid, "setDeviceUuid(self, uuid: QBluetoothUuid)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setDeviceUuid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setDeviceUuid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QBluetoothUuid, &a0))
        {
            sipCpp->setDeviceUuid(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setDeviceUuid, doc_QBluetoothDeviceInfo_setDeviceUuid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_deviceUuid, "deviceUuid(self) -> QBluetoothUuid");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_deviceUuid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_deviceUuid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothUuid*sipRes;

            sipRes = new ::QBluetoothUuid(sipCpp->deviceUuid());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_deviceUuid, doc_QBluetoothDeviceInfo_deviceUuid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_manufacturerIds, "manufacturerIds(self) -> list[int]");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_manufacturerIds(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_manufacturerIds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QList<unsigned short>*sipRes;

            sipRes = new ::QList<unsigned short>(sipCpp->manufacturerIds());

            return sipConvertFromNewType(sipRes, sipType_QList_1600, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_manufacturerIds, doc_QBluetoothDeviceInfo_manufacturerIds);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_manufacturerData, "manufacturerData(self) -> dict[int, QByteArray]\n"
"manufacturerData(self, manufacturerId: int) -> QByteArray");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_manufacturerData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_manufacturerData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QMultiHash< ::quint16, QByteArray>*sipRes;

            sipRes = new QMultiHash< ::quint16, QByteArray>(sipCpp->manufacturerData());

            return sipConvertFromNewType(sipRes, sipType_QMultiHash_1600_0100QByteArray, SIP_NULLPTR);
        }
    }

    {
        ::quint16 a0;
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bt", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->manufacturerData(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_manufacturerData, doc_QBluetoothDeviceInfo_manufacturerData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setManufacturerData, "setManufacturerData(self, manufacturerId: int, data: QByteArray|bytes|bytearray|memoryview) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setManufacturerData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setManufacturerData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::quint16 a0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BtJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0, sipType_QByteArray, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->setManufacturerData(a0, *a1);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setManufacturerData, doc_QBluetoothDeviceInfo_setManufacturerData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setName, "setName(self, name: str|None)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setName(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setName, doc_QBluetoothDeviceInfo_setName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceIds, "serviceIds(self) -> list[QBluetoothUuid]");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceIds(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceIds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QList< ::QBluetoothUuid>*sipRes;

            sipRes = new QList< ::QBluetoothUuid>(sipCpp->serviceIds());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceIds, doc_QBluetoothDeviceInfo_serviceIds);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceData, "serviceData(self) -> dict[QBluetoothUuid, QByteArray]\n"
"serviceData(self, serviceId: QBluetoothUuid) -> QByteArray");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QMultiHash< ::QBluetoothUuid, ::QByteArray>*sipRes;

            sipRes = new QMultiHash< ::QBluetoothUuid, ::QByteArray>(sipCpp->serviceData());

            return sipConvertFromNewType(sipRes, sipType_QMultiHash_0100QBluetoothUuid_0100QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QBluetoothUuid* a0;
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QBluetoothUuid, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->serviceData(*a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceData, doc_QBluetoothDeviceInfo_serviceData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setServiceData, "setServiceData(self, serviceId: QBluetoothUuid, data: QByteArray|bytes|bytearray|memoryview) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setServiceData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setServiceData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QBluetoothUuid, &a0, sipType_QByteArray, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->setServiceData(*a0, *a1);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setServiceData, doc_QBluetoothDeviceInfo_setServiceData);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBluetoothDeviceInfo___eq__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothDeviceInfo___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothDeviceInfo *sipCpp = reinterpret_cast< ::QBluetoothDeviceInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothDeviceInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, eq_slot, sipType_QBluetoothDeviceInfo, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBluetoothDeviceInfo___ne__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothDeviceInfo___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothDeviceInfo *sipCpp = reinterpret_cast< ::QBluetoothDeviceInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothDeviceInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, ne_slot, sipType_QBluetoothDeviceInfo, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QBluetoothDeviceInfo(void *, int);}
static void release_QBluetoothDeviceInfo(void *sipCppV, int)
{
    delete reinterpret_cast< ::QBluetoothDeviceInfo *>(sipCppV);
}


extern "C" {static void *array_QBluetoothDeviceInfo(Py_ssize_t);}
static void *array_QBluetoothDeviceInfo(Py_ssize_t sipNrElem)
{
    return new ::QBluetoothDeviceInfo[sipNrElem];
}


extern "C" {static void array_delete_QBluetoothDeviceInfo(void *);}
static void array_delete_QBluetoothDeviceInfo(void *sipCpp)
{
    delete[] reinterpret_cast< ::QBluetoothDeviceInfo *>(sipCpp);
}


extern "C" {static void assign_QBluetoothDeviceInfo(void *, Py_ssize_t, void *);}
static void assign_QBluetoothDeviceInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QBluetoothDeviceInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QBluetoothDeviceInfo *>(sipSrc);
}


extern "C" {static void *copy_QBluetoothDeviceInfo(const void *, Py_ssize_t);}
static void *copy_QBluetoothDeviceInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QBluetoothDeviceInfo(reinterpret_cast<const ::QBluetoothDeviceInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QBluetoothDeviceInfo(sipSimpleWrapper *);}
static void dealloc_QBluetoothDeviceInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QBluetoothDeviceInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QBluetoothDeviceInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QBluetoothDeviceInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QBluetoothDeviceInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QBluetoothDeviceInfo();

            return sipCpp;
        }
    }

    {
        const ::QBluetoothAddress* a0;
        const ::QString* a1;
        int a1State = 0;
        ::quint32 a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J1u", sipType_QBluetoothAddress, &a0, sipType_QString, &a1, &a1State, &a2))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0, *a1, a2);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothUuid* a0;
        const ::QString* a1;
        int a1State = 0;
        ::quint32 a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J1u", sipType_QBluetoothUuid, &a0, sipType_QString, &a1, &a1State, &a2))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0, *a1, a2);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QBluetoothDeviceInfo[] = {
    {(void *)slot_QBluetoothDeviceInfo___eq__, eq_slot},
    {(void *)slot_QBluetoothDeviceInfo___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QBluetoothDeviceInfo[] = {
    {sipName_address, meth_QBluetoothDeviceInfo_address, METH_VARARGS, doc_QBluetoothDeviceInfo_address},
    {sipName_coreConfigurations, meth_QBluetoothDeviceInfo_coreConfigurations, METH_VARARGS, doc_QBluetoothDeviceInfo_coreConfigurations},
    {sipName_deviceUuid, meth_QBluetoothDeviceInfo_deviceUuid, METH_VARARGS, doc_QBluetoothDeviceInfo_deviceUuid},
    {sipName_isCached, meth_QBluetoothDeviceInfo_isCached, METH_VARARGS, doc_QBluetoothDeviceInfo_isCached},
    {sipName_isValid, meth_QBluetoothDeviceInfo_isValid, METH_VARARGS, doc_QBluetoothDeviceInfo_isValid},
    {sipName_majorDeviceClass, meth_QBluetoothDeviceInfo_majorDeviceClass, METH_VARARGS, doc_QBluetoothDeviceInfo_majorDeviceClass},
    {sipName_manufacturerData, meth_QBluetoothDeviceInfo_manufacturerData, METH_VARARGS, doc_QBluetoothDeviceInfo_manufacturerData},
    {sipName_manufacturerIds, meth_QBluetoothDeviceInfo_manufacturerIds, METH_VARARGS, doc_QBluetoothDeviceInfo_manufacturerIds},
    {sipName_minorDeviceClass, meth_QBluetoothDeviceInfo_minorDeviceClass, METH_VARARGS, doc_QBluetoothDeviceInfo_minorDeviceClass},
    {sipName_name, meth_QBluetoothDeviceInfo_name, METH_VARARGS, doc_QBluetoothDeviceInfo_name},
    {sipName_rssi, meth_QBluetoothDeviceInfo_rssi, METH_VARARGS, doc_QBluetoothDeviceInfo_rssi},
    {sipName_serviceClasses, meth_QBluetoothDeviceInfo_serviceClasses, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceClasses},
    {sipName_serviceData, meth_QBluetoothDeviceInfo_serviceData, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceData},
    {sipName_serviceIds, meth_QBluetoothDeviceInfo_serviceIds, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceIds},
    {sipName_serviceUuids, meth_QBluetoothDeviceInfo_serviceUuids, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceUuids},
    {sipName_setCached, meth_QBluetoothDeviceInfo_setCached, METH_VARARGS, doc_QBluetoothDeviceInfo_setCached},
    {sipName_setCoreConfigurations, meth_QBluetoothDeviceInfo_setCoreConfigurations, METH_VARARGS, doc_QBluetoothDeviceInfo_setCoreConfigurations},
    {sipName_setDeviceUuid, meth_QBluetoothDeviceInfo_setDeviceUuid, METH_VARARGS, doc_QBluetoothDeviceInfo_setDeviceUuid},
    {sipName_setManufacturerData, meth_QBluetoothDeviceInfo_setManufacturerData, METH_VARARGS, doc_QBluetoothDeviceInfo_setManufacturerData},
    {sipName_setName, meth_QBluetoothDeviceInfo_setName, METH_VARARGS, doc_QBluetoothDeviceInfo_setName},
    {sipName_setRssi, meth_QBluetoothDeviceInfo_setRssi, METH_VARARGS, doc_QBluetoothDeviceInfo_setRssi},
    {sipName_setServiceData, meth_QBluetoothDeviceInfo_setServiceData, METH_VARARGS, doc_QBluetoothDeviceInfo_setServiceData},
    {sipName_setServiceUuids, meth_QBluetoothDeviceInfo_setServiceUuids, METH_VARARGS, doc_QBluetoothDeviceInfo_setServiceUuids}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QBluetoothDeviceInfo[] = {
    {sipName_UnknownCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::UnknownCoreConfiguration)},
    {sipName_LowEnergyCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::LowEnergyCoreConfiguration)},
    {sipName_BaseRateCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::BaseRateCoreConfiguration)},
    {sipName_BaseRateAndLowEnergyCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::BaseRateAndLowEnergyCoreConfiguration)},
    {sipName_None_, static_cast<int>(::QBluetoothDeviceInfo::Field::None)},
    {sipName_RSSI, static_cast<int>(::QBluetoothDeviceInfo::Field::RSSI)},
    {sipName_ManufacturerData, static_cast<int>(::QBluetoothDeviceInfo::Field::ManufacturerData)},
    {sipName_ServiceData, static_cast<int>(::QBluetoothDeviceInfo::Field::ServiceData)},
    {sipName_All, static_cast<int>(::QBluetoothDeviceInfo::Field::All)},
    {sipName_MiscellaneousDevice, static_cast<int>(::QBluetoothDeviceInfo::MiscellaneousDevice)},
    {sipName_ComputerDevice, static_cast<int>(::QBluetoothDeviceInfo::ComputerDevice)},
    {sipName_PhoneDevice, static_cast<int>(::QBluetoothDeviceInfo::PhoneDevice)},
    {sipName_NetworkDevice, static_cast<int>(::QBluetoothDeviceInfo::NetworkDevice)},
    {sipName_AudioVideoDevice, static_cast<int>(::QBluetoothDeviceInfo::AudioVideoDevice)},
    {sipName_PeripheralDevice, static_cast<int>(::QBluetoothDeviceInfo::PeripheralDevice)},
    {sipName_ImagingDevice, static_cast<int>(::QBluetoothDeviceInfo::ImagingDevice)},
    {sipName_WearableDevice, static_cast<int>(::QBluetoothDeviceInfo::WearableDevice)},
    {sipName_ToyDevice, static_cast<int>(::QBluetoothDeviceInfo::ToyDevice)},
    {sipName_HealthDevice, static_cast<int>(::QBluetoothDeviceInfo::HealthDevice)},
    {sipName_UncategorizedDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedDevice)},
    {sipName_UncategorizedAudioVideoDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedAudioVideoDevice)},
    {sipName_WearableHeadsetDevice, static_cast<int>(::QBluetoothDeviceInfo::WearableHeadsetDevice)},
    {sipName_HandsFreeDevice, static_cast<int>(::QBluetoothDeviceInfo::HandsFreeDevice)},
    {sipName_Microphone, static_cast<int>(::QBluetoothDeviceInfo::Microphone)},
    {sipName_Loudspeaker, static_cast<int>(::QBluetoothDeviceInfo::Loudspeaker)},
    {sipName_Headphones, static_cast<int>(::QBluetoothDeviceInfo::Headphones)},
    {sipName_PortableAudioDevice, static_cast<int>(::QBluetoothDeviceInfo::PortableAudioDevice)},
    {sipName_CarAudio, static_cast<int>(::QBluetoothDeviceInfo::CarAudio)},
    {sipName_SetTopBox, static_cast<int>(::QBluetoothDeviceInfo::SetTopBox)},
    {sipName_HiFiAudioDevice, static_cast<int>(::QBluetoothDeviceInfo::HiFiAudioDevice)},
    {sipName_Vcr, static_cast<int>(::QBluetoothDeviceInfo::Vcr)},
    {sipName_VideoCamera, static_cast<int>(::QBluetoothDeviceInfo::VideoCamera)},
    {sipName_Camcorder, static_cast<int>(::QBluetoothDeviceInfo::Camcorder)},
    {sipName_VideoMonitor, static_cast<int>(::QBluetoothDeviceInfo::VideoMonitor)},
    {sipName_VideoDisplayAndLoudspeaker, static_cast<int>(::QBluetoothDeviceInfo::VideoDisplayAndLoudspeaker)},
    {sipName_VideoConferencing, static_cast<int>(::QBluetoothDeviceInfo::VideoConferencing)},
    {sipName_GamingDevice, static_cast<int>(::QBluetoothDeviceInfo::GamingDevice)},
    {sipName_UncategorizedComputer, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedComputer)},
    {sipName_DesktopComputer, static_cast<int>(::QBluetoothDeviceInfo::DesktopComputer)},
    {sipName_ServerComputer, static_cast<int>(::QBluetoothDeviceInfo::ServerComputer)},
    {sipName_LaptopComputer, static_cast<int>(::QBluetoothDeviceInfo::LaptopComputer)},
    {sipName_HandheldClamShellComputer, static_cast<int>(::QBluetoothDeviceInfo::HandheldClamShellComputer)},
    {sipName_HandheldComputer, static_cast<int>(::QBluetoothDeviceInfo::HandheldComputer)},
    {sipName_WearableComputer, static_cast<int>(::QBluetoothDeviceInfo::WearableComputer)},
    {sipName_UncategorizedHealthDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedHealthDevice)},
    {sipName_HealthBloodPressureMonitor, static_cast<int>(::QBluetoothDeviceInfo::HealthBloodPressureMonitor)},
    {sipName_HealthThermometer, static_cast<int>(::QBluetoothDeviceInfo::HealthThermometer)},
    {sipName_HealthWeightScale, static_cast<int>(::QBluetoothDeviceInfo::HealthWeightScale)},
    {sipName_HealthGlucoseMeter, static_cast<int>(::QBluetoothDeviceInfo::HealthGlucoseMeter)},
    {sipName_HealthPulseOximeter, static_cast<int>(::QBluetoothDeviceInfo::HealthPulseOximeter)},
    {sipName_HealthDataDisplay, static_cast<int>(::QBluetoothDeviceInfo::HealthDataDisplay)},
    {sipName_HealthStepCounter, static_cast<int>(::QBluetoothDeviceInfo::HealthStepCounter)},
    {sipName_UncategorizedImagingDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedImagingDevice)},
    {sipName_ImageDisplay, static_cast<int>(::QBluetoothDeviceInfo::ImageDisplay)},
    {sipName_ImageCamera, static_cast<int>(::QBluetoothDeviceInfo::ImageCamera)},
    {sipName_ImageScanner, static_cast<int>(::QBluetoothDeviceInfo::ImageScanner)},
    {sipName_ImagePrinter, static_cast<int>(::QBluetoothDeviceInfo::ImagePrinter)},
    {sipName_UncategorizedMiscellaneous, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedMiscellaneous)},
    {sipName_NetworkFullService, static_cast<int>(::QBluetoothDeviceInfo::NetworkFullService)},
    {sipName_NetworkLoadFactorOne, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorOne)},
    {sipName_NetworkLoadFactorTwo, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorTwo)},
    {sipName_NetworkLoadFactorThree, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorThree)},
    {sipName_NetworkLoadFactorFour, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorFour)},
    {sipName_NetworkLoadFactorFive, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorFive)},
    {sipName_NetworkLoadFactorSix, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorSix)},
    {sipName_NetworkNoService, static_cast<int>(::QBluetoothDeviceInfo::NetworkNoService)},
    {sipName_UncategorizedPeripheral, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedPeripheral)},
    {sipName_KeyboardPeripheral, static_cast<int>(::QBluetoothDeviceInfo::KeyboardPeripheral)},
    {sipName_PointingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::PointingDevicePeripheral)},
    {sipName_KeyboardWithPointingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::KeyboardWithPointingDevicePeripheral)},
    {sipName_JoystickPeripheral, static_cast<int>(::QBluetoothDeviceInfo::JoystickPeripheral)},
    {sipName_GamepadPeripheral, static_cast<int>(::QBluetoothDeviceInfo::GamepadPeripheral)},
    {sipName_RemoteControlPeripheral, static_cast<int>(::QBluetoothDeviceInfo::RemoteControlPeripheral)},
    {sipName_SensingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::SensingDevicePeripheral)},
    {sipName_DigitizerTabletPeripheral, static_cast<int>(::QBluetoothDeviceInfo::DigitizerTabletPeripheral)},
    {sipName_CardReaderPeripheral, static_cast<int>(::QBluetoothDeviceInfo::CardReaderPeripheral)},
    {sipName_UncategorizedPhone, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedPhone)},
    {sipName_CellularPhone, static_cast<int>(::QBluetoothDeviceInfo::CellularPhone)},
    {sipName_CordlessPhone, static_cast<int>(::QBluetoothDeviceInfo::CordlessPhone)},
    {sipName_SmartPhone, static_cast<int>(::QBluetoothDeviceInfo::SmartPhone)},
    {sipName_WiredModemOrVoiceGatewayPhone, static_cast<int>(::QBluetoothDeviceInfo::WiredModemOrVoiceGatewayPhone)},
    {sipName_CommonIsdnAccessPhone, static_cast<int>(::QBluetoothDeviceInfo::CommonIsdnAccessPhone)},
    {sipName_UncategorizedToy, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedToy)},
    {sipName_ToyRobot, static_cast<int>(::QBluetoothDeviceInfo::ToyRobot)},
    {sipName_ToyVehicle, static_cast<int>(::QBluetoothDeviceInfo::ToyVehicle)},
    {sipName_ToyDoll, static_cast<int>(::QBluetoothDeviceInfo::ToyDoll)},
    {sipName_ToyController, static_cast<int>(::QBluetoothDeviceInfo::ToyController)},
    {sipName_ToyGame, static_cast<int>(::QBluetoothDeviceInfo::ToyGame)},
    {sipName_UncategorizedWearableDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedWearableDevice)},
    {sipName_WearableWristWatch, static_cast<int>(::QBluetoothDeviceInfo::WearableWristWatch)},
    {sipName_WearablePager, static_cast<int>(::QBluetoothDeviceInfo::WearablePager)},
    {sipName_WearableJacket, static_cast<int>(::QBluetoothDeviceInfo::WearableJacket)},
    {sipName_WearableHelmet, static_cast<int>(::QBluetoothDeviceInfo::WearableHelmet)},
    {sipName_WearableGlasses, static_cast<int>(::QBluetoothDeviceInfo::WearableGlasses)},
    {sipName_NoService, static_cast<int>(::QBluetoothDeviceInfo::NoService)},
    {sipName_PositioningService, static_cast<int>(::QBluetoothDeviceInfo::PositioningService)},
    {sipName_NetworkingService, static_cast<int>(::QBluetoothDeviceInfo::NetworkingService)},
    {sipName_RenderingService, static_cast<int>(::QBluetoothDeviceInfo::RenderingService)},
    {sipName_CapturingService, static_cast<int>(::QBluetoothDeviceInfo::CapturingService)},
    {sipName_ObjectTransferService, static_cast<int>(::QBluetoothDeviceInfo::ObjectTransferService)},
    {sipName_AudioService, static_cast<int>(::QBluetoothDeviceInfo::AudioService)},
    {sipName_TelephonyService, static_cast<int>(::QBluetoothDeviceInfo::TelephonyService)},
    {sipName_InformationService, static_cast<int>(::QBluetoothDeviceInfo::InformationService)},
    {sipName_AllServices, static_cast<int>(::QBluetoothDeviceInfo::AllServices)},
    {0, 0}
};

PyDoc_STRVAR(doc_QBluetoothDeviceInfo, "\1QBluetoothDeviceInfo()\n"
"QBluetoothDeviceInfo(address: QBluetoothAddress, name: str|None, classOfDevice: int)\n"
"QBluetoothDeviceInfo(uuid: QBluetoothUuid, name: str|None, classOfDevice: int)\n"
"QBluetoothDeviceInfo(other: QBluetoothDeviceInfo)");


sipClassTypeDef sipTypeDef_QtBluetooth_QBluetoothDeviceInfo = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QBluetoothDeviceInfo,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QBluetoothDeviceInfo,
        {0, 0, 1},
        23, methods_QBluetoothDeviceInfo,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QBluetoothDeviceInfo, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QBluetoothDeviceInfo,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QBluetoothDeviceInfo,
    init_type_QBluetoothDeviceInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QBluetoothDeviceInfo,
    assign_QBluetoothDeviceInfo,
    array_QBluetoothDeviceInfo,
    copy_QBluetoothDeviceInfo,
    release_QBluetoothDeviceInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QBluetoothDeviceInfo,
    sizeof (::QBluetoothDeviceInfo),
};
