// ----------------------------------------------------------------------------
//
//  Copyright (C) 2023 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JBW8FILT_H
#define __JBW8FILT_H


#include <zita-jclient.h>
#include <stdint.h>
#include "bw8filter.h"


class Jbw8chan
{
private:

    friend class Jbw8filt;
    
    Jbw8chan (void);
    ~Jbw8chan (void);
    
    volatile int16_t   _nreq;
    volatile int16_t   _nack;
    int16_t            _mode;
    int16_t            _inp;
    float              _hpf;
    float              _lpf;
    Bw8filter          _hpfilt;
    Bw8filter          _lpfilt;
};


class Jbw8filt : public Jclient
{
public:

    Jbw8filt (const char *client_name, const char *server_name,
	      int ninp, int nout);
    virtual ~Jbw8filt (void);

    enum {  MAXINP = 100, MAXOUT = 100 };

    void set_filter (int inp, int out, float hpfreq, float lpfreq);

private:

    enum { HPF = 1, LPF = 2 };
    
    int  jack_process (int nframes);

    Jbw8chan  *_chanpar;
};


#endif
