// python wrapper for ttkTriangulationRequest
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTriangulationRequest.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTriangulationRequest(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTriangulationRequest_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTriangulationRequest_SIMPLEX_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTriangulationRequest.ttkTriangulationRequest.SIMPLEX", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkTriangulationRequest_SIMPLEX_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkTriangulationRequest_SIMPLEX_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTriangulationRequest_REQUEST_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTriangulationRequest.ttkTriangulationRequest.REQUEST", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkTriangulationRequest_REQUEST_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkTriangulationRequest_REQUEST_Type, static_cast<int>(val));
}


static PyObject *
PyttkTriangulationRequest_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTriangulationRequest::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTriangulationRequest::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTriangulationRequest *tempr = ttkTriangulationRequest::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTriangulationRequest *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTriangulationRequest::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTriangulationRequest::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTriangulationRequest::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_SetSimplexType_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplexType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplexType(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetSimplexType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkTriangulationRequest_SetSimplexType_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplexType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  typedef ttkTriangulationRequest::SIMPLEX temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkTriangulationRequest.SIMPLEX"))
  {
    if (ap.IsBound())
    {
      op->SetSimplexType(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetSimplexType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkTriangulationRequest_SetSimplexType_Methods[] = {
  {"SetSimplexType", PyttkTriangulationRequest_SetSimplexType_s1, METH_VARARGS,
   "@i"},
  {"SetSimplexType", PyttkTriangulationRequest_SetSimplexType_s2, METH_VARARGS,
   "@E ttkTriangulationRequest.SIMPLEX"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkTriangulationRequest_SetSimplexType(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkTriangulationRequest_SetSimplexType_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSimplexType");
  return nullptr;
}


static PyObject *
PyttkTriangulationRequest_GetSimplexType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSimplexType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkTriangulationRequest::SIMPLEX tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetSimplexType() :
      op->ttkTriangulationRequest::GetSimplexType());

    if (!ap.ErrorOccurred())
    {
      result = PyttkTriangulationRequest_SIMPLEX_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_SetSimplexIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplexIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplexIdentifier(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetSimplexIdentifier(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_GetSimplexIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSimplexIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSimplexIdentifier() :
      op->ttkTriangulationRequest::GetSimplexIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_SetRequestType_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRequestType(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetRequestType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkTriangulationRequest_SetRequestType_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  typedef ttkTriangulationRequest::REQUEST temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkTriangulationRequest.REQUEST"))
  {
    if (ap.IsBound())
    {
      op->SetRequestType(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetRequestType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkTriangulationRequest_SetRequestType_Methods[] = {
  {"SetRequestType", PyttkTriangulationRequest_SetRequestType_s1, METH_VARARGS,
   "@i"},
  {"SetRequestType", PyttkTriangulationRequest_SetRequestType_s2, METH_VARARGS,
   "@E ttkTriangulationRequest.REQUEST"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkTriangulationRequest_SetRequestType(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkTriangulationRequest_SetRequestType_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetRequestType");
  return nullptr;
}


static PyObject *
PyttkTriangulationRequest_GetRequestType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequestType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkTriangulationRequest::REQUEST tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetRequestType() :
      op->ttkTriangulationRequest::GetRequestType());

    if (!ap.ErrorOccurred())
    {
      result = PyttkTriangulationRequest_REQUEST_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_SetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepAllDataArrays(temp0);
    }
    else
    {
      op->ttkTriangulationRequest::SetKeepAllDataArrays(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationRequest_GetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationRequest *op = static_cast<ttkTriangulationRequest *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetKeepAllDataArrays() :
      op->ttkTriangulationRequest::GetKeepAllDataArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTriangulationRequest_Methods[] = {
  {"IsTypeOf", PyttkTriangulationRequest_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTriangulationRequest_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTriangulationRequest_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTriangulationRequest\nC++: static ttkTriangulationRequest *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTriangulationRequest_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTriangulationRequest\nC++: ttkTriangulationRequest *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTriangulationRequest_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTriangulationRequest_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSimplexType", PyttkTriangulationRequest_SetSimplexType, METH_VARARGS,
   "SetSimplexType(self, _arg:int) -> None\nC++: virtual void SetSimplexType(int _arg)\nSetSimplexType(self, _arg:SIMPLEX) -> None\nC++: virtual void SetSimplexType(SIMPLEX _arg)\n\n"},
  {"GetSimplexType", PyttkTriangulationRequest_GetSimplexType, METH_VARARGS,
   "GetSimplexType(self) -> SIMPLEX\nC++: virtual SIMPLEX GetSimplexType()\n\n"},
  {"SetSimplexIdentifier", PyttkTriangulationRequest_SetSimplexIdentifier, METH_VARARGS,
   "SetSimplexIdentifier(self, _arg:str) -> None\nC++: virtual void SetSimplexIdentifier(const std::string &_arg)\n\n"},
  {"GetSimplexIdentifier", PyttkTriangulationRequest_GetSimplexIdentifier, METH_VARARGS,
   "GetSimplexIdentifier(self) -> str\nC++: virtual std::string GetSimplexIdentifier()\n\n"},
  {"SetRequestType", PyttkTriangulationRequest_SetRequestType, METH_VARARGS,
   "SetRequestType(self, _arg:int) -> None\nC++: virtual void SetRequestType(int _arg)\nSetRequestType(self, _arg:REQUEST) -> None\nC++: virtual void SetRequestType(REQUEST _arg)\n\n"},
  {"GetRequestType", PyttkTriangulationRequest_GetRequestType, METH_VARARGS,
   "GetRequestType(self) -> REQUEST\nC++: virtual REQUEST GetRequestType()\n\n"},
  {"SetKeepAllDataArrays", PyttkTriangulationRequest_SetKeepAllDataArrays, METH_VARARGS,
   "SetKeepAllDataArrays(self, _arg:bool) -> None\nC++: virtual void SetKeepAllDataArrays(bool _arg)\n\n"},
  {"GetKeepAllDataArrays", PyttkTriangulationRequest_GetKeepAllDataArrays, METH_VARARGS,
   "GetKeepAllDataArrays(self) -> bool\nC++: virtual bool GetKeepAllDataArrays()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTriangulationRequest_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("simplex_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetSimplexType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetSimplexType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSimplexType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplex_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationRequest_GetSimplexType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetSimplexType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetSimplexType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSimplexType/SetSimplexType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplex_identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationRequest_GetSimplexIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetSimplexIdentifier(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetSimplexIdentifier(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSimplexIdentifier/SetSimplexIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("request_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetRequestType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetRequestType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRequestType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("request_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationRequest_GetRequestType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetRequestType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetRequestType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRequestType/SetRequestType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_all_data_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationRequest_GetKeepAllDataArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationRequest_SetKeepAllDataArrays(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationRequest_SetKeepAllDataArrays(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepAllDataArrays/SetKeepAllDataArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTriangulationRequest_Doc =
  "ttkTriangulationRequest - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\date April\n"
  "2017.\n\n"
  "TTK VTK-filter that wraps the triangulation processing package.\n\n"
  "VTK wrapping code for the ttk::Triangulation package.\n\n"
  "\\param Input Geometry, either 2D or 3D, either regular grid or\n"
  "triangulation (vtkDataSet)\n"
  "\\param Output Output geometry requested by the user (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::Triangulation\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTriangulationRequest_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTriangulationRequest.ttkTriangulationRequest", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTriangulationRequest_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTriangulationRequest_StaticNew()
{
  return ttkTriangulationRequest::New();
}

PyObject *PyttkTriangulationRequest_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTriangulationRequest_Type, PyttkTriangulationRequest_Methods,
    "ttkTriangulationRequest",
 &PyttkTriangulationRequest_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyttkTriangulationRequest_SIMPLEX_Type);
  // members of ttkTriangulationRequest::SIMPLEX
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkTriangulationRequest_SIMPLEX_Type.tp_dict = enumdict;

    typedef ttkTriangulationRequest::SIMPLEX cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[4] = {
      { "VERTEX", cxx_enum_type::VERTEX },
      { "EDGE", cxx_enum_type::EDGE },
      { "TRIANGLE", cxx_enum_type::TRIANGLE },
      { "TETRA", cxx_enum_type::TETRA },
    };

    for (int c = 0; c < 4; c++)
    {
      enumval = PyttkTriangulationRequest_SIMPLEX_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkTriangulationRequest_SIMPLEX_Type, "ttkTriangulationRequest.SIMPLEX");

  o = (PyObject *)&PyttkTriangulationRequest_SIMPLEX_Type;
  if (PyDict_SetItemString(d, "SIMPLEX", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyttkTriangulationRequest_REQUEST_Type);
  // members of ttkTriangulationRequest::REQUEST
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkTriangulationRequest_REQUEST_Type.tp_dict = enumdict;

    typedef ttkTriangulationRequest::REQUEST cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[6] = {
      { "COMPUTE_SIMPLEX", cxx_enum_type::COMPUTE_SIMPLEX },
      { "COMPUTE_FACET", cxx_enum_type::COMPUTE_FACET },
      { "COMPUTE_COFACET", cxx_enum_type::COMPUTE_COFACET },
      { "COMPUTE_STAR", cxx_enum_type::COMPUTE_STAR },
      { "COMPUTE_LINK", cxx_enum_type::COMPUTE_LINK },
      { "COMPUTE_BOUNDARY", cxx_enum_type::COMPUTE_BOUNDARY },
    };

    for (int c = 0; c < 6; c++)
    {
      enumval = PyttkTriangulationRequest_REQUEST_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkTriangulationRequest_REQUEST_Type, "ttkTriangulationRequest.REQUEST");

  o = (PyObject *)&PyttkTriangulationRequest_REQUEST_Type;
  if (PyDict_SetItemString(d, "REQUEST", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTriangulationRequest_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTriangulationRequest(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTriangulationRequest_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTriangulationRequest", o) != 0)
  {
    Py_DECREF(o);
  }

}

