/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSAudioTrackList.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDate.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
#include "JSMediaSource.h"
#include "JSMediaStream.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "JSTimeRanges.h"
#include "JSVideoPlaybackQuality.h"
#include "JSVideoTrackList.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

#if ENABLE(ENCRYPTED_MEDIA)
#include "JSEventListener.h"
#include "JSMediaKeys.h"
#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
#include "JSWebKitMediaKeys.h"
#endif

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_load);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_canPlayType);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_fastSeek);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getStartDate);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_play);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_pause);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setMediaKeys);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_addTextTrack);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setSinkId);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_error);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_src);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_src);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_srcObject);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_srcObject);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_currentSrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_crossOrigin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_crossOrigin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_networkState);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_preload);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_preload);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_buffered);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_seeking);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_currentTime);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_currentTime);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_paused);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_defaultPlaybackRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultPlaybackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_playbackRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_playbackRate);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_preservesPitch);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_preservesPitch);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_played);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_seekable);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_ended);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_autoplay);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_autoplay);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_loop);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_loop);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_controls);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_controls);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_volume);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_volume);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_muted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_muted);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_defaultMuted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultMuted);
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitAudioDecodedByteCount);
#endif
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitVideoDecodedByteCount);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_mediaKeys);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_onencrypted);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_onencrypted);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_onwaitingforkey);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_onwaitingforkey);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_audioTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_textTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_videoTracks);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_mediaGroup);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_mediaGroup);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_controller);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLMediaElement_controller);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLMediaElement_sinkId);
#endif

class JSHTMLMediaElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLMediaElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMediaElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMediaElementPrototype>(vm)) JSHTMLMediaElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMediaElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMediaElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMediaElementPrototype, JSHTMLMediaElementPrototype::Base);

using JSHTMLMediaElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLMediaElement>;

/* Hash table for constructor */

static const std::array<HashTableValue, 9> JSHTMLMediaElementConstructorTableValues {
    HashTableValue { "NETWORK_EMPTY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "NETWORK_IDLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "NETWORK_LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "NETWORK_NO_SOURCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "HAVE_NOTHING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "HAVE_METADATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "HAVE_CURRENT_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "HAVE_FUTURE_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "HAVE_ENOUGH_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

static_assert(HTMLMediaElement::NETWORK_EMPTY == 0, "NETWORK_EMPTY in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_IDLE == 1, "NETWORK_IDLE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_LOADING == 2, "NETWORK_LOADING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_NO_SOURCE == 3, "NETWORK_NO_SOURCE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_NOTHING == 0, "HAVE_NOTHING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_METADATA == 1, "HAVE_METADATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_CURRENT_DATA == 2, "HAVE_CURRENT_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_FUTURE_DATA == 3, "HAVE_FUTURE_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_ENOUGH_DATA == 4, "HAVE_ENOUGH_DATA in HTMLMediaElement does not match value from IDL");

template<> const ClassInfo JSHTMLMediaElementDOMConstructor::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementDOMConstructor) };

template<> JSValue JSHTMLMediaElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMediaElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLMediaElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMediaElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 60> JSHTMLMediaElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElementConstructor, 0 } },
    HashTableValue { "error"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_error, 0 } },
    HashTableValue { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_src, setJSHTMLMediaElement_src } },
    HashTableValue { "srcObject"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_srcObject, setJSHTMLMediaElement_srcObject } },
    HashTableValue { "currentSrc"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_currentSrc, 0 } },
    HashTableValue { "crossOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_crossOrigin, setJSHTMLMediaElement_crossOrigin } },
    HashTableValue { "networkState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_networkState, 0 } },
    HashTableValue { "preload"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_preload, setJSHTMLMediaElement_preload } },
    HashTableValue { "buffered"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_buffered, 0 } },
    HashTableValue { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_readyState, 0 } },
    HashTableValue { "seeking"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_seeking, 0 } },
    HashTableValue { "currentTime"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_currentTime, setJSHTMLMediaElement_currentTime } },
    HashTableValue { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_duration, 0 } },
    HashTableValue { "paused"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_paused, 0 } },
    HashTableValue { "defaultPlaybackRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_defaultPlaybackRate, setJSHTMLMediaElement_defaultPlaybackRate } },
    HashTableValue { "playbackRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_playbackRate, setJSHTMLMediaElement_playbackRate } },
    HashTableValue { "preservesPitch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_preservesPitch, setJSHTMLMediaElement_preservesPitch } },
    HashTableValue { "played"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_played, 0 } },
    HashTableValue { "seekable"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_seekable, 0 } },
    HashTableValue { "ended"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_ended, 0 } },
    HashTableValue { "autoplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_autoplay, setJSHTMLMediaElement_autoplay } },
    HashTableValue { "loop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_loop, setJSHTMLMediaElement_loop } },
    HashTableValue { "controls"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_controls, setJSHTMLMediaElement_controls } },
    HashTableValue { "volume"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_volume, setJSHTMLMediaElement_volume } },
    HashTableValue { "muted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_muted, setJSHTMLMediaElement_muted } },
    HashTableValue { "defaultMuted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_defaultMuted, setJSHTMLMediaElement_defaultMuted } },
#if ENABLE(MEDIA_STATISTICS)
    HashTableValue { "webkitAudioDecodedByteCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitAudioDecodedByteCount, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    HashTableValue { "webkitVideoDecodedByteCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitVideoDecodedByteCount, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    HashTableValue { "webkitKeys"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitKeys, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    HashTableValue { "mediaKeys"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_mediaKeys, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    HashTableValue { "onencrypted"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_onencrypted, setJSHTMLMediaElement_onencrypted } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    HashTableValue { "onwaitingforkey"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_onwaitingforkey, setJSHTMLMediaElement_onwaitingforkey } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "audioTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_audioTracks, 0 } },
    HashTableValue { "textTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_textTracks, 0 } },
    HashTableValue { "videoTracks"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_videoTracks, 0 } },
    HashTableValue { "mediaGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_mediaGroup, setJSHTMLMediaElement_mediaGroup } },
    HashTableValue { "controller"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_controller, setJSHTMLMediaElement_controller } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    HashTableValue { "webkitCurrentPlaybackTargetIsWireless"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    HashTableValue { "sinkId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLMediaElement_sinkId, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "load"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_load, 0 } },
    HashTableValue { "canPlayType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_canPlayType, 1 } },
    HashTableValue { "fastSeek"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_fastSeek, 1 } },
    HashTableValue { "getStartDate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_getStartDate, 0 } },
    HashTableValue { "play"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_play, 0 } },
    HashTableValue { "pause"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_pause, 0 } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    HashTableValue { "webkitSetMediaKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    HashTableValue { "setMediaKeys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_setMediaKeys, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "addTextTrack"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_addTextTrack, 1 } },
    HashTableValue { "getVideoPlaybackQuality"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality, 0 } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    HashTableValue { "webkitShowPlaybackTargetPicker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    HashTableValue { "setSinkId"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLMediaElementPrototypeFunction_setSinkId, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "NETWORK_EMPTY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "NETWORK_IDLE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "NETWORK_LOADING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "NETWORK_NO_SOURCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "HAVE_NOTHING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "HAVE_METADATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "HAVE_CURRENT_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "HAVE_FUTURE_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "HAVE_ENOUGH_DATA"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementPrototype) };

void JSHTMLMediaElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().legacyEncryptedMediaAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitSetMediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setMediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().wirelessPlaybackTargetAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitShowPlaybackTargetPicker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().exposeSpeakersEnabled && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().perElementSpeakerSelectionEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setSinkId"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().legacyEncryptedMediaAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "mediaKeys"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onencrypted"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().encryptedMediaAPIEnabled && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onwaitingforkey"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().wirelessPlaybackTargetAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitCurrentPlaybackTargetIsWireless"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().exposeSpeakersEnabled && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().perElementSpeakerSelectionEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sinkId"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElement) };

JSHTMLMediaElement::JSHTMLMediaElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMediaElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLMediaElement> JSHTMLMediaElement::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLMediaElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSHTMLMediaElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLMediaElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLMediaElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLMediaElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLMediaElement>(vm, globalObject);
}

JSValue JSHTMLMediaElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMediaElementDOMConstructor, DOMConstructorID::HTMLMediaElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMediaElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLMediaElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLMediaElement_errorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<MediaError>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.error())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_error, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_errorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_srcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::srcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_srcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_srcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_srcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_srcObjectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLInterface<MediaStream>, IDLInterface<MediaSource>, IDLInterface<Blob>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.srcObject())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_srcObject, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_srcObjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_srcObjectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLUnion<IDLInterface<MediaStream>, IDLInterface<MediaSource>, IDLInterface<Blob>>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSrcObject(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_srcObject, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_srcObjectSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_currentSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.currentSrc())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_currentSrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_currentSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_crossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, throwScope, impl.crossOrigin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_crossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_crossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::crossoriginAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_crossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_networkStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.networkState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_networkState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_networkStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_preloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.preload())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_preload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_preloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_preloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPreload(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_preload, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_preloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_bufferedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffered())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_buffered, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_bufferedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_seekingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.seeking())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_seeking, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_seekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_currentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.currentTimeForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_currentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_currentTimeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCurrentTimeForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_currentTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_currentTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_durationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_pausedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.paused())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_paused, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_pausedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_defaultPlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.defaultPlaybackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_defaultPlaybackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_defaultPlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_defaultPlaybackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultPlaybackRate(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultPlaybackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_defaultPlaybackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_playbackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.playbackRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_playbackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_playbackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackRate(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_playbackRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_playbackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_preservesPitchGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.preservesPitch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_preservesPitch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_preservesPitchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_preservesPitchSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPreservesPitch(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_preservesPitch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_preservesPitchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_playedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.played())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_played, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_playedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_seekableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.seekable())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_seekable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_seekableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_endedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ended())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_ended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_endedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_autoplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autoplayAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_autoplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_autoplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_autoplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_autoplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_autoplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_loopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::loopAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_loopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_loopSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::loopAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_loop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_loopSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_controlsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.controls())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_controlsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_controlsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setControls(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_controls, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_controlsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_volumeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.volume())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_volume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_volumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_volumeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setVolume(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_volume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_volumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_mutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.muted())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_mutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMuted(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_mutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_defaultMutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::mutedAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_defaultMuted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_defaultMutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_defaultMutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::mutedAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_defaultMuted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_defaultMutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElement_webkitAudioDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitAudioDecodedByteCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitAudioDecodedByteCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitAudioDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElement_webkitVideoDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitVideoDecodedByteCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitVideoDecodedByteCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitVideoDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_webkitKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<WebKitMediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.webkitKeys())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitKeys, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_mediaKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mediaKeys())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_mediaKeys, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mediaKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_onencryptedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().encryptedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_onencrypted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_onencryptedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElement_onencryptedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().encryptedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_onencrypted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_onencryptedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElement_onwaitingforkeyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().waitingforkeyEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_onwaitingforkey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_onwaitingforkeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElement_onwaitingforkeySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().waitingforkeyEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_onwaitingforkey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_onwaitingforkeySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSValue jsHTMLMediaElement_audioTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAudioTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_audioTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_audioTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_textTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TextTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureTextTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_textTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_textTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_videoTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VideoTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureVideoTracks())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_videoTracks, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_videoTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_mediaGroupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_mediaGroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_mediaGroupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_mediaGroupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_mediaGroup, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_mediaGroupSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLMediaElement_controllerGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controllerForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_controller, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_controllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLMediaElement_controllerSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "HTMLMediaElement"_s, "controller"_s, "MediaController"_s); });
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setControllerForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLMediaElement_controller, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElement_controllerSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWirelessGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitCurrentPlaybackTargetIsWireless())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWireless, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_webkitCurrentPlaybackTargetIsWirelessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static inline JSValue jsHTMLMediaElement_sinkIdGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.audioOutputHashedDeviceId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLMediaElement_sinkId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElement_sinkIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_loadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.load(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_load, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_loadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_canPlayTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.canPlayType(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_canPlayType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_canPlayTypeBody>(*lexicalGlobalObject, *callFrame, "canPlayType");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_fastSeekBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto timeConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (timeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fastSeek(timeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_fastSeek, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_fastSeekBody>(*lexicalGlobalObject, *callFrame, "fastSeek");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_getStartDateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDate>(*lexicalGlobalObject, throwScope, impl.getStartDate())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getStartDate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_getStartDateBody>(*lexicalGlobalObject, *callFrame, "getStartDate");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_playBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.play(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_play, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_playBody>(*lexicalGlobalObject, *callFrame, "play");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_pauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pause(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_pause, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_pauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaKeysConversionResult = convert<IDLNullable<IDLInterface<WebKitMediaKeys>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys"_s, "HTMLMediaElement"_s, "webkitSetMediaKeys"_s, "WebKitMediaKeys"_s); });
    if (mediaKeysConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitSetMediaKeys(mediaKeysConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_webkitSetMediaKeysBody>(*lexicalGlobalObject, *callFrame, "webkitSetMediaKeys");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_setMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaKeysConversionResult = convert<IDLNullable<IDLInterface<MediaKeys>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys"_s, "HTMLMediaElement"_s, "setMediaKeys"_s, "MediaKeys"_s); });
    if (mediaKeysConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setMediaKeys(mediaKeysConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setMediaKeys, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_setMediaKeysBody>(*lexicalGlobalObject, *callFrame, "setMediaKeys");
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_addTextTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto kindConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (kindConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto labelConversionResult = convertOptionalWithDefault<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLAtomStringAdaptor<IDLDOMString>> { return Converter<IDLAtomStringAdaptor<IDLDOMString>>::ReturnType { emptyAtom() }; });
    if (labelConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto languageConversionResult = convertOptionalWithDefault<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLAtomStringAdaptor<IDLDOMString>> { return Converter<IDLAtomStringAdaptor<IDLDOMString>>::ReturnType { emptyAtom() }; });
    if (languageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TextTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addTextTrack(kindConversionResult.releaseReturnValue(), labelConversionResult.releaseReturnValue(), languageConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_addTextTrack, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_addTextTrackBody>(*lexicalGlobalObject, *callFrame, "addTextTrack");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQualityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<VideoPlaybackQuality>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getVideoPlaybackQuality())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQuality, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_getVideoPlaybackQualityBody>(*lexicalGlobalObject, *callFrame, "getVideoPlaybackQuality");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPickerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitShowPlaybackTargetPicker(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPicker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_webkitShowPlaybackTargetPickerBody>(*lexicalGlobalObject, *callFrame, "webkitShowPlaybackTargetPicker");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunction_setSinkIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto deviceIdConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (deviceIdConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setAudioOutputDevice(deviceIdConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLMediaElementPrototypeFunction_setSinkId, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunction_setSinkIdBody>(*lexicalGlobalObject, *callFrame, "setSinkId");
}

#endif

JSC::GCClient::IsoSubspace* JSHTMLMediaElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLMediaElement, UseCustomHeapCellType::No>(vm, "JSHTMLMediaElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLMediaElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLMediaElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLMediaElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLMediaElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLMediaElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLMediaElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsHTMLMediaElement = jsCast<JSHTMLMediaElement*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsHTMLMediaElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLMediaElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLMediaElement = static_cast<JSHTMLMediaElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLMediaElement->protectedWrapped().ptr(), jsHTMLMediaElement);
}

HTMLMediaElement* JSHTMLMediaElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLMediaElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
