/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAngle.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGAnglePrototypeFunction_newValueSpecifiedUnits);
static JSC_DECLARE_HOST_FUNCTION(jsSVGAnglePrototypeFunction_convertToSpecifiedUnits);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGAngleConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAngle_unitType);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAngle_value);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGAngle_value);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAngle_valueInSpecifiedUnits);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGAngle_valueInSpecifiedUnits);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAngle_valueAsString);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGAngle_valueAsString);

class JSSVGAnglePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnglePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnglePrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnglePrototype>(vm)) JSSVGAnglePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnglePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnglePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnglePrototype, JSSVGAnglePrototype::Base);

using JSSVGAngleDOMConstructor = JSDOMConstructorNotConstructable<JSSVGAngle>;

/* Hash table for constructor */

static const std::array<HashTableValue, 5> JSSVGAngleConstructorTableValues {
    HashTableValue { "SVG_ANGLETYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_ANGLETYPE_UNSPECIFIED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_ANGLETYPE_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_ANGLETYPE_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_ANGLETYPE_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

static_assert(SVGAngleValue::SVG_ANGLETYPE_UNKNOWN == 0, "SVG_ANGLETYPE_UNKNOWN in SVGAngleValue does not match value from IDL");
static_assert(SVGAngleValue::SVG_ANGLETYPE_UNSPECIFIED == 1, "SVG_ANGLETYPE_UNSPECIFIED in SVGAngleValue does not match value from IDL");
static_assert(SVGAngleValue::SVG_ANGLETYPE_DEG == 2, "SVG_ANGLETYPE_DEG in SVGAngleValue does not match value from IDL");
static_assert(SVGAngleValue::SVG_ANGLETYPE_RAD == 3, "SVG_ANGLETYPE_RAD in SVGAngleValue does not match value from IDL");
static_assert(SVGAngleValue::SVG_ANGLETYPE_GRAD == 4, "SVG_ANGLETYPE_GRAD in SVGAngleValue does not match value from IDL");

template<> const ClassInfo JSSVGAngleDOMConstructor::s_info = { "SVGAngle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAngleDOMConstructor) };

template<> JSValue JSSVGAngleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAngleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGAngle"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGAngle::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGAngle::info(), JSSVGAngleConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 12> JSSVGAnglePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAngleConstructor, 0 } },
    HashTableValue { "unitType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAngle_unitType, 0 } },
    HashTableValue { "value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAngle_value, setJSSVGAngle_value } },
    HashTableValue { "valueInSpecifiedUnits"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAngle_valueInSpecifiedUnits, setJSSVGAngle_valueInSpecifiedUnits } },
    HashTableValue { "valueAsString"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAngle_valueAsString, setJSSVGAngle_valueAsString } },
    HashTableValue { "newValueSpecifiedUnits"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnglePrototypeFunction_newValueSpecifiedUnits, 2 } },
    HashTableValue { "convertToSpecifiedUnits"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGAnglePrototypeFunction_convertToSpecifiedUnits, 1 } },
    HashTableValue { "SVG_ANGLETYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_ANGLETYPE_UNSPECIFIED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_ANGLETYPE_DEG"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_ANGLETYPE_RAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_ANGLETYPE_GRAD"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
};

const ClassInfo JSSVGAnglePrototype::s_info = { "SVGAngle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnglePrototype) };

void JSSVGAnglePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAngle::info(), JSSVGAnglePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGAngle::s_info = { "SVGAngle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAngle) };

JSSVGAngle::JSSVGAngle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAngle>&& impl)
    : JSDOMWrapper<SVGAngle>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGAngle>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGAngle::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGAnglePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGAnglePrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGAngle::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAngle>(vm, globalObject);
}

JSValue JSSVGAngle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAngleDOMConstructor, DOMConstructorID::SVGAngle>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAngle::destroy(JSC::JSCell* cell)
{
    JSSVGAngle* thisObject = static_cast<JSSVGAngle*>(cell);
    thisObject->JSSVGAngle::~JSSVGAngle();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAngleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnglePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAngle::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGAngle_unitTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.unitType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAngle_unitType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::get<jsSVGAngle_unitTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGAngle_valueGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.valueForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAngle_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::get<jsSVGAngle_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGAngle_valueSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGAngle_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::set<setJSSVGAngle_valueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGAngle_valueInSpecifiedUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.valueInSpecifiedUnits())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAngle_valueInSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::get<jsSVGAngle_valueInSpecifiedUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGAngle_valueInSpecifiedUnitsSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueInSpecifiedUnits(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGAngle_valueInSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::set<setJSSVGAngle_valueInSpecifiedUnitsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGAngle_valueAsStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.valueAsString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAngle_valueAsString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::get<jsSVGAngle_valueAsStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGAngle_valueAsStringSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAngle& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueAsString(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGAngle_valueAsString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAngle>::set<setJSSVGAngle_valueAsStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGAnglePrototypeFunction_newValueSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAngle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto valueInSpecifiedUnitsConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (valueInSpecifiedUnitsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.newValueSpecifiedUnits(unitTypeConversionResult.releaseReturnValue(), valueInSpecifiedUnitsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnglePrototypeFunction_newValueSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAngle>::call<jsSVGAnglePrototypeFunction_newValueSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "newValueSpecifiedUnits");
}

static inline JSC::EncodedJSValue jsSVGAnglePrototypeFunction_convertToSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGAngle>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.convertToSpecifiedUnits(unitTypeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGAnglePrototypeFunction_convertToSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGAngle>::call<jsSVGAnglePrototypeFunction_convertToSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "convertToSpecifiedUnits");
}

JSC::GCClient::IsoSubspace* JSSVGAngle::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGAngle, UseCustomHeapCellType::No>(vm, "JSSVGAngle"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGAngle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGAngle = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGAngle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGAngle = std::forward<decltype(space)>(space); }
    );
}

void JSSVGAngle::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAngle*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGAngleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGAngleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAngle = static_cast<JSSVGAngle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAngle->protectedWrapped().ptr(), jsSVGAngle);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGAngle@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8SVGAngleE[]; }
#endif
template<std::same_as<SVGAngle> T>
static inline void verifyVTable(SVGAngle* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGAngle@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8SVGAngleE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGAngle has subclasses. If SVGAngle has subclasses that get passed
        // to toJS() we currently require SVGAngle you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGAngle>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SVGAngle>(impl.ptr());
#endif
    return createWrapper<SVGAngle>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGAngle& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGAngle* JSSVGAngle::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAngle*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
