/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureASTC.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLCompressedTextureASTCPrototypeFunction_getSupportedProfiles);

class JSWebGLCompressedTextureASTCPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLCompressedTextureASTCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureASTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureASTCPrototype>(vm)) JSWebGLCompressedTextureASTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureASTCPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureASTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLCompressedTextureASTCPrototype, JSWebGLCompressedTextureASTCPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 29> JSWebGLCompressedTextureASTCPrototypeTableValues {
    HashTableValue { "getSupportedProfiles"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLCompressedTextureASTCPrototypeFunction_getSupportedProfiles, 0 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_4x4_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B0 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_5x4_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B1 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_5x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B2 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_6x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B3 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_6x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B4 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_8x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B5 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_8x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B6 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_8x8_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B7 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_10x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B8 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_10x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93B9 } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_10x8_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93BA } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_10x10_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93BB } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_12x10_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93BC } },
    HashTableValue { "COMPRESSED_RGBA_ASTC_12x12_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93BD } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D0 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D1 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D2 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D3 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D4 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D5 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D6 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D7 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D8 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93D9 } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93DA } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93DB } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93DC } },
    HashTableValue { "COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x93DD } },
};

const ClassInfo JSWebGLCompressedTextureASTCPrototype::s_info = { "WebGLCompressedTextureASTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureASTCPrototype) };

void JSWebGLCompressedTextureASTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureASTC::info(), JSWebGLCompressedTextureASTCPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLCompressedTextureASTC::s_info = { "WebGLCompressedTextureASTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLCompressedTextureASTC) };

JSWebGLCompressedTextureASTC::JSWebGLCompressedTextureASTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureASTC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureASTC>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLCompressedTextureASTC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLCompressedTextureASTC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLCompressedTextureASTCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLCompressedTextureASTCPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLCompressedTextureASTC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureASTC>(vm, globalObject);
}

void JSWebGLCompressedTextureASTC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureASTC* thisObject = static_cast<JSWebGLCompressedTextureASTC*>(cell);
    thisObject->JSWebGLCompressedTextureASTC::~JSWebGLCompressedTextureASTC();
}

static inline JSC::EncodedJSValue jsWebGLCompressedTextureASTCPrototypeFunction_getSupportedProfilesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLCompressedTextureASTC>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSupportedProfiles())));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLCompressedTextureASTCPrototypeFunction_getSupportedProfiles, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLCompressedTextureASTC>::call<jsWebGLCompressedTextureASTCPrototypeFunction_getSupportedProfilesBody>(*lexicalGlobalObject, *callFrame, "getSupportedProfiles");
}

JSC::GCClient::IsoSubspace* JSWebGLCompressedTextureASTC::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLCompressedTextureASTC, UseCustomHeapCellType::No>(vm, "JSWebGLCompressedTextureASTC"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLCompressedTextureASTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLCompressedTextureASTC = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLCompressedTextureASTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLCompressedTextureASTC = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLCompressedTextureASTC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLCompressedTextureASTC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLCompressedTextureASTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLCompressedTextureASTC = jsCast<JSWebGLCompressedTextureASTC*>(handle.slot()->asCell());
    auto& owner = jsWebGLCompressedTextureASTC->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsWebGLCompressedTextureASTC"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLCompressedTextureASTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureASTC = static_cast<JSWebGLCompressedTextureASTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLCompressedTextureASTC->protectedWrapped().ptr(), jsWebGLCompressedTextureASTC);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureASTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLCompressedTextureASTCE[]; }
#endif
template<std::same_as<WebGLCompressedTextureASTC> T>
static inline void verifyVTable(WebGLCompressedTextureASTC* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLCompressedTextureASTC@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26WebGLCompressedTextureASTCE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLCompressedTextureASTC has subclasses. If WebGLCompressedTextureASTC has subclasses that get passed
        // to toJS() we currently require WebGLCompressedTextureASTC you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLCompressedTextureASTC>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLCompressedTextureASTC>(impl.ptr());
#endif
    return createWrapper<WebGLCompressedTextureASTC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLCompressedTextureASTC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLCompressedTextureASTC* JSWebGLCompressedTextureASTC::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureASTC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
