﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DeviceFarm {
namespace Model {

/**
 * <p>A JSON object that specifies the paths where the artifacts generated by the
 * customer's tests, on the device or in the test environment, are pulled from.</p>
 * <p>Specify <code>deviceHostPaths</code> and optionally specify either
 * <code>iosPaths</code> or <code>androidPaths</code>.</p> <p>For web app tests,
 * you can specify both <code>iosPaths</code> and
 * <code>androidPaths</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CustomerArtifactPaths">AWS
 * API Reference</a></p>
 */
class CustomerArtifactPaths {
 public:
  AWS_DEVICEFARM_API CustomerArtifactPaths() = default;
  AWS_DEVICEFARM_API CustomerArtifactPaths(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEVICEFARM_API CustomerArtifactPaths& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEVICEFARM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Comma-separated list of paths on the iOS device where the artifacts generated
   * by the customer's tests are pulled from.</p>
   */
  inline const Aws::Vector<Aws::String>& GetIosPaths() const { return m_iosPaths; }
  inline bool IosPathsHasBeenSet() const { return m_iosPathsHasBeenSet; }
  template <typename IosPathsT = Aws::Vector<Aws::String>>
  void SetIosPaths(IosPathsT&& value) {
    m_iosPathsHasBeenSet = true;
    m_iosPaths = std::forward<IosPathsT>(value);
  }
  template <typename IosPathsT = Aws::Vector<Aws::String>>
  CustomerArtifactPaths& WithIosPaths(IosPathsT&& value) {
    SetIosPaths(std::forward<IosPathsT>(value));
    return *this;
  }
  template <typename IosPathsT = Aws::String>
  CustomerArtifactPaths& AddIosPaths(IosPathsT&& value) {
    m_iosPathsHasBeenSet = true;
    m_iosPaths.emplace_back(std::forward<IosPathsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Comma-separated list of paths on the Android device where the artifacts
   * generated by the customer's tests are pulled from.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAndroidPaths() const { return m_androidPaths; }
  inline bool AndroidPathsHasBeenSet() const { return m_androidPathsHasBeenSet; }
  template <typename AndroidPathsT = Aws::Vector<Aws::String>>
  void SetAndroidPaths(AndroidPathsT&& value) {
    m_androidPathsHasBeenSet = true;
    m_androidPaths = std::forward<AndroidPathsT>(value);
  }
  template <typename AndroidPathsT = Aws::Vector<Aws::String>>
  CustomerArtifactPaths& WithAndroidPaths(AndroidPathsT&& value) {
    SetAndroidPaths(std::forward<AndroidPathsT>(value));
    return *this;
  }
  template <typename AndroidPathsT = Aws::String>
  CustomerArtifactPaths& AddAndroidPaths(AndroidPathsT&& value) {
    m_androidPathsHasBeenSet = true;
    m_androidPaths.emplace_back(std::forward<AndroidPathsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Comma-separated list of paths in the test execution environment where the
   * artifacts generated by the customer's tests are pulled from.</p>
   */
  inline const Aws::Vector<Aws::String>& GetDeviceHostPaths() const { return m_deviceHostPaths; }
  inline bool DeviceHostPathsHasBeenSet() const { return m_deviceHostPathsHasBeenSet; }
  template <typename DeviceHostPathsT = Aws::Vector<Aws::String>>
  void SetDeviceHostPaths(DeviceHostPathsT&& value) {
    m_deviceHostPathsHasBeenSet = true;
    m_deviceHostPaths = std::forward<DeviceHostPathsT>(value);
  }
  template <typename DeviceHostPathsT = Aws::Vector<Aws::String>>
  CustomerArtifactPaths& WithDeviceHostPaths(DeviceHostPathsT&& value) {
    SetDeviceHostPaths(std::forward<DeviceHostPathsT>(value));
    return *this;
  }
  template <typename DeviceHostPathsT = Aws::String>
  CustomerArtifactPaths& AddDeviceHostPaths(DeviceHostPathsT&& value) {
    m_deviceHostPathsHasBeenSet = true;
    m_deviceHostPaths.emplace_back(std::forward<DeviceHostPathsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_iosPaths;

  Aws::Vector<Aws::String> m_androidPaths;

  Aws::Vector<Aws::String> m_deviceHostPaths;
  bool m_iosPathsHasBeenSet = false;
  bool m_androidPathsHasBeenSet = false;
  bool m_deviceHostPathsHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
