/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindBundle;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryComboBoxWithButtons
extends JPanel {
    @NotNull
    private final ComponentWithBrowseButton<ComboBox<String>> myDirectoryComboBox;
    private volatile boolean myUpdating;
    boolean myRecursive;
    Runnable myCallback;

    public DirectoryComboBoxWithButtons(@NotNull Project project) {
        if (project == null) {
            DirectoryComboBoxWithButtons.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myDirectoryComboBox = new ComponentWithBrowseButton((JComponent)new ComboBox(200), null);
        this.myUpdating = false;
        this.myRecursive = true;
        final ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.addActionListener(e -> {
            if (this.myUpdating) {
                return;
            }
            VirtualFile directory = this.getDirectory();
            ComboBox source = (ComboBox)e.getSource();
            if (directory == null) {
                source.putClientProperty((Object)"JComponent.outline", (Object)"error");
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(SSRBundle.message("popup.content.directory", new Object[0]), AllIcons.General.BalloonError, MessageType.ERROR.getPopupBackground(), null).createBalloon();
                balloon.show(new RelativePoint((Component)source, new Point(source.getWidth() / 2, 0)), Balloon.Position.above);
                source.requestFocus();
            } else {
                source.putClientProperty((Object)"JComponent.outline", null);
            }
            if (this.myCallback != null && directory != null) {
                this.myCallback.run();
            }
        });
        comboBox.setEditable(true);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setForcedToUseIdeaFileChooser(true);
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            FileChooserFactory.getInstance().installFileCompletion((JTextField)editorComponent, descriptor, true, null);
        }
        comboBox.setMaximumRowCount(8);
        this.myDirectoryComboBox.addBrowseFolderListener(project, descriptor, (TextComponentAccessor)new TextComponentAccessor<ComboBox<String>>(this){

            public String getText(ComboBox comboBox2) {
                return comboBox2.getEditor().getItem().toString();
            }

            public void setText(ComboBox component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                comboBox.getEditor().setItem(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons$1", "setText"));
            }
        });
        RecursiveAction recursiveDirectoryAction = new RecursiveAction();
        int mnemonicModifiers = ClientSystemInfo.isMac() ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)this.myDirectoryComboBox);
        this.add((Component)this.myDirectoryComboBox, "Center");
        this.add((Component)FindPopupPanel.createToolbar((AnAction[])new AnAction[]{recursiveDirectoryAction}), "East");
    }

    public ComboBox<String> getComboBox() {
        return (ComboBox)this.myDirectoryComboBox.getChildComponent();
    }

    public void setCallback(Runnable callback) {
        this.myCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentDirectories(@NotNull List<@NlsSafe String> recentDirectories) {
        if (recentDirectories == null) {
            DirectoryComboBoxWithButtons.$$$reportNull$$$0(1);
        }
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        this.myUpdating = true;
        try {
            comboBox.removeAllItems();
            for (int i = recentDirectories.size() - 1; i >= 0; --i) {
                comboBox.addItem((Object)recentDirectories.get(i));
            }
        }
        finally {
            this.myUpdating = false;
        }
    }

    public void setDirectory(@Nullable VirtualFile directory) {
        if (directory == null) {
            return;
        }
        String url = directory.getPresentableUrl();
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.getEditor().setItem(url);
        ((ComboBox)this.myDirectoryComboBox.getChildComponent()).setSelectedItem((Object)url);
    }

    @Nullable
    public VirtualFile getDirectory() {
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        String directoryName = (String)comboBox.getSelectedItem();
        if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null || !virtualFile.isDirectory() ? null : virtualFile;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    public void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setRecentDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RecursiveAction
    extends ToggleAction {
        RecursiveAction() {
            super(FindBundle.messagePointer((String)"find.scope.directory.recursive.checkbox", (Object[])new Object[0]), FindBundle.messagePointer((String)"find.recursively.hint", (Object[])new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                RecursiveAction.$$$reportNull$$$0(0);
            }
            return DirectoryComboBoxWithButtons.this.myRecursive;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RecursiveAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                RecursiveAction.$$$reportNull$$$0(2);
            }
            DirectoryComboBoxWithButtons.this.myRecursive = state;
            DirectoryComboBoxWithButtons.this.myCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons$RecursiveAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons$RecursiveAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

