/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.ArtifactDownloadResult;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenAttachSourcesProvider;", "Lcom/intellij/codeInsight/AttachSourcesProvider;", "<init>", "()V", "getActions", "", "Lcom/intellij/codeInsight/AttachSourcesProvider$AttachSourcesAction;", "orderEntries", "", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "psiFile", "Lcom/intellij/psi/PsiFile;", "cleanUpUnresolvedSourceFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "mavenIds", "Lorg/jetbrains/idea/maven/model/MavenId;", "isTargetFile", "", "name", "", "type", "Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;", "findArtifacts", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "mavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getMavenProjects", "CoroutineService", "intellij.maven"})
public final class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter(orderEntries, (String)"orderEntries");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Collection<MavenProject> projects = this.getMavenProjects(psiFile);
        if (projects.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return this.findArtifacts(projects, orderEntries).isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)new AttachSourcesProvider.AttachSourcesAction(psiFile, this, orderEntries){
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ MavenAttachSourcesProvider this$0;
            final /* synthetic */ List<LibraryOrderEntry> $orderEntries;
            {
                this.$psiFile = $psiFile;
                this.this$0 = $receiver;
                this.$orderEntries = $orderEntries;
            }

            public String getName() {
                String string = MavenProjectBundle.message("maven.action.download.sources", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getBusyText() {
                String string = MavenProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public ActionCallback perform(List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                Intrinsics.checkNotNullParameter(orderEntriesContainingFile, (String)"orderEntriesContainingFile");
                Project project = this.$psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                ComponentManager $this$service$iv = (ComponentManager)project2;
                boolean $i$f$service = false;
                Class<CoroutineService> serviceClass$iv = CoroutineService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                CoroutineScope cs = ((CoroutineService)object).getCoroutineScope();
                ActionCallback resultWrapper = new ActionCallback();
                BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(resultWrapper, project2, this.this$0, this.$orderEntries, this.$psiFile, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int label;
                    final /* synthetic */ ActionCallback $resultWrapper;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ MavenAttachSourcesProvider this$0;
                    final /* synthetic */ List<LibraryOrderEntry> $orderEntries;
                    final /* synthetic */ PsiFile $psiFile;
                    {
                        this.$resultWrapper = $resultWrapper;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$orderEntries = $orderEntries;
                        this.$psiFile = $psiFile;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(org.jetbrains.idea.maven.utils.MavenAttachSourcesProvider com.intellij.psi.PsiFile ), ()Ljava/util/Collection;)((MavenAttachSourcesProvider)this.this$0, (PsiFile)this.$psiFile), (Continuation)((Continuation)this));
                                if (v0 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if ((mavenProjects = (Collection)v0).isEmpty()) {
                                    this.$resultWrapper.setRejected();
                                    return Unit.INSTANCE;
                                }
                                manager = MavenProjectsManager.getInstance(this.$project);
                                artifacts = MavenAttachSourcesProvider.access$findArtifacts(this.this$0, mavenProjects, this.$orderEntries);
                                if (artifacts.isEmpty()) {
                                    this.$resultWrapper.setRejected();
                                    return Unit.INSTANCE;
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)mavenProjects);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)manager);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)artifacts);
                                this.label = 2;
                                v1 = manager.downloadArtifacts(mavenProjects, artifacts, true, false, (Continuation)this);
                                if (v1 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl35
                            }
                            case 2: {
                                artifacts = (Collection)this.L$2;
                                manager = (MavenProjectsManager)this.L$1;
                                mavenProjects = (Collection)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl35:
                                // 2 sources

                                downloadResult = (ArtifactDownloadResult)v1;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)mavenProjects);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)manager);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)artifacts);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)downloadResult);
                                this.label = 3;
                                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(downloadResult, this.this$0, this.$project, this.$resultWrapper, null){
                                    int label;
                                    final /* synthetic */ ArtifactDownloadResult $downloadResult;
                                    final /* synthetic */ MavenAttachSourcesProvider this$0;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ ActionCallback $resultWrapper;
                                    {
                                        this.$downloadResult = $downloadResult;
                                        this.this$0 = $receiver;
                                        this.$project = $project;
                                        this.$resultWrapper = $resultWrapper;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                if (!this.$downloadResult.unresolvedSources.isEmpty()) {
                                                    HtmlBuilder builder2 = new HtmlBuilder();
                                                    builder2.append(MavenProjectBundle.message("sources.not.found.for", new Object[0]));
                                                    Iterator<T> iterator = ((Iterable)this.$downloadResult.unresolvedSources).iterator();
                                                    int n = 0;
                                                    while (iterator.hasNext()) {
                                                        int count = n++;
                                                        MavenId each = (MavenId)iterator.next();
                                                        if (count > 5) {
                                                            builder2.append((HtmlChunk)HtmlChunk.br()).append(MavenProjectBundle.message("and.more", new Object[0]));
                                                            break;
                                                        }
                                                        builder2.append((HtmlChunk)HtmlChunk.br()).append(each.getDisplayString());
                                                    }
                                                    MavenAttachSourcesProvider.access$cleanUpUnresolvedSourceFiles(this.this$0, this.$project, this.$downloadResult.unresolvedSources);
                                                    Notifications.Bus.notify((Notification)new Notification("Maven", MavenProjectBundle.message("maven.sources.cannot.download", new Object[0]), builder2.wrapWithHtmlBody().toString(), NotificationType.WARNING), (Project)this.$project);
                                                }
                                                if (this.$downloadResult.resolvedSources.isEmpty()) {
                                                    this.$resultWrapper.setRejected();
                                                } else {
                                                    this.$resultWrapper.setDone();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v2 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl52
                            }
                            case 3: {
                                downloadResult = (ArtifactDownloadResult)this.L$3;
                                artifacts = (Collection)this.L$2;
                                manager = (MavenProjectsManager)this.L$1;
                                mavenProjects = (Collection)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl52:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Collection invokeSuspend$lambda$0(MavenAttachSourcesProvider this$0, PsiFile $psiFile) {
                        return MavenAttachSourcesProvider.access$getMavenProjects(this$0, $psiFile);
                    }
                }), (int)3, null);
                return resultWrapper;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpUnresolvedSourceFiles(Project project, Collection<? extends MavenId> mavenIds) {
        for (MavenId mavenId : mavenIds) {
            Path parentFile;
            if (MavenUtil.INSTANCE.getRepositoryParentFile(project, mavenId) == null) continue;
            try {
                AutoCloseable autoCloseable = Files.list(parentFile);
                Throwable throwable = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    boolean bl = false;
                    paths.filter(arg_0 -> MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles$lambda$0$1(arg_0 -> MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles$lambda$0$0(this, arg_0), arg_0)).forEach(arg_0 -> MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles$lambda$0$3(MavenAttachSourcesProvider::cleanUpUnresolvedSourceFiles$lambda$0$2, arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.warn(parentFile + " cannot be listed", (Throwable)e);
            }
        }
    }

    private final boolean isTargetFile(String name, MavenExtraArtifactType type) {
        return StringsKt.contains$default((CharSequence)name, (CharSequence)("-" + type.getDefaultClassifier()), (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)name, (CharSequence)("." + type.getDefaultExtension()), (boolean)false, (int)2, null);
    }

    private final Collection<MavenArtifact> findArtifacts(Collection<MavenProject> mavenProjects, List<? extends LibraryOrderEntry> orderEntries) {
        Collection artifacts = new HashSet();
        for (MavenProject each : mavenProjects) {
            for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
                MavenArtifact artifact = MavenRootModelAdapter.findArtifact(each, libraryOrderEntry.getLibrary());
                if (artifact == null || Intrinsics.areEqual((Object)"system", (Object)artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    private final Collection<MavenProject> getMavenProjects(PsiFile psiFile) {
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Collection result2 = new ArrayList();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject = MavenProjectsManager.getInstance(project2).findProject(each.getOwnerModule());
            if (mavenProject == null) continue;
            result2.add(mavenProject);
        }
        return result2;
    }

    private static final boolean cleanUpUnresolvedSourceFiles$lambda$0$0(MavenAttachSourcesProvider this$0, Path it) {
        return this$0.isTargetFile(((Object)it.getFileName()).toString(), MavenExtraArtifactType.SOURCES);
    }

    private static final boolean cleanUpUnresolvedSourceFiles$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit cleanUpUnresolvedSourceFiles$lambda$0$2(Path it) {
        try {
            FileUtil.delete((Path)it);
        }
        catch (IOException e) {
            MavenLog.LOG.warn(it + " not deleted", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void cleanUpUnresolvedSourceFiles$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Collection access$findArtifacts(MavenAttachSourcesProvider $this, Collection mavenProjects, List orderEntries) {
        return $this.findArtifacts(mavenProjects, orderEntries);
    }

    public static final /* synthetic */ void access$cleanUpUnresolvedSourceFiles(MavenAttachSourcesProvider $this, Project project, Collection mavenIds) {
        $this.cleanUpUnresolvedSourceFiles(project, mavenIds);
    }

    public static final /* synthetic */ Collection access$getMavenProjects(MavenAttachSourcesProvider $this, PsiFile psiFile) {
        return $this.getMavenProjects(psiFile);
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenAttachSourcesProvider$CoroutineService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.maven"})
    private static final class CoroutineService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

