/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.common.deployment;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@ConfigRoot
@ConfigMapping(prefix="quarkus.smallrye-openapi")
public interface SmallRyeOpenApiConfig {
    @WithDefault(value="openapi")
    public String path();

    public Optional<Path> storeSchemaDirectory();

    @WithDefault(value="openapi")
    public String storeSchemaFileName();

    @WithDefault(value="false")
    public boolean alwaysRunFilter();

    @WithDefault(value="false")
    public boolean ignoreStaticDocument();

    @WithName(value="management.enabled")
    @WithDefault(value="true")
    public boolean managementEnabled();

    public Optional<List<Path>> additionalDocsDirectory();

    public Optional<SecurityScheme> securityScheme();

    @WithDefault(value="SecurityScheme")
    public String securitySchemeName();

    @WithDefault(value="Authentication")
    public String securitySchemeDescription();

    @ConfigDocMapKey(value="extension-name")
    public Map<String, String> securitySchemeExtensions();

    @WithDefault(value="true")
    public boolean autoAddSecurityRequirement();

    @WithDefault(value="true")
    public boolean autoAddTags();

    @WithDefault(value="true")
    public boolean autoAddBadRequestResponse();

    @WithDefault(value="true")
    public boolean autoAddOperationSummary();

    public Optional<Boolean> autoAddServer();

    @WithDefault(value="true")
    public boolean autoAddSecurity();

    @WithDefault(value="false")
    public boolean autoAddOpenApiEndpoint();

    public Optional<String> apiKeyParameterIn();

    public Optional<String> apiKeyParameterName();

    @WithDefault(value="basic")
    public String basicSecuritySchemeValue();

    @WithDefault(value="bearer")
    public String jwtSecuritySchemeValue();

    @WithDefault(value="JWT")
    public String jwtBearerFormat();

    @WithDefault(value="bearer")
    public String oauth2SecuritySchemeValue();

    @WithDefault(value="Opaque")
    public String oauth2BearerFormat();

    public Optional<String> oidcOpenIdConnectUrl();

    public Optional<String> oauth2ImplicitRefreshUrl();

    public Optional<String> oauth2ImplicitAuthorizationUrl();

    public Optional<String> oauth2ImplicitTokenUrl();

    public Optional<String> openApiVersion();

    public Optional<String> infoTitle();

    public Optional<String> infoVersion();

    public Optional<String> infoDescription();

    public Optional<String> infoTermsOfService();

    public Optional<String> infoContactEmail();

    public Optional<String> infoContactName();

    public Optional<String> infoContactUrl();

    public Optional<String> infoLicenseName();

    public Optional<String> infoLicenseUrl();

    public Optional<OperationIdStrategy> operationIdStrategy();

    @WithDefault(value="true")
    public boolean mergeSchemaExamples();

    default public Map<String, String> getValidSecuritySchemeExtensions() {
        return this.securitySchemeExtensions().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith("x-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static enum OperationIdStrategy {
        METHOD,
        CLASS_METHOD,
        PACKAGE_CLASS_METHOD;

    }

    public static enum SecurityScheme {
        apiKey,
        basic,
        jwt,
        oauth2,
        oidc,
        oauth2Implicit;

    }
}

