/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodElement;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.impl.BackportUtil;
import io.github.dmlloyd.classfile.impl.BufferedCodeBuilder;
import io.github.dmlloyd.classfile.impl.TerminalMethodBuilder;
import java.util.Objects;
import java.util.function.Consumer;

public final class ChainedMethodBuilder
implements MethodBuilder {
    final TerminalMethodBuilder terminal;
    final Consumer<MethodElement> consumer;

    public ChainedMethodBuilder(MethodBuilder downstream, Consumer<MethodElement> consumer) {
        TerminalMethodBuilder terminalMethodBuilder;
        this.consumer = consumer;
        if (downstream instanceof ChainedMethodBuilder) {
            ChainedMethodBuilder cb = (ChainedMethodBuilder)downstream;
            terminalMethodBuilder = cb.terminal;
        } else {
            TerminalMethodBuilder tb;
            terminalMethodBuilder = downstream instanceof TerminalMethodBuilder ? (tb = (TerminalMethodBuilder)downstream) : (TerminalMethodBuilder)BackportUtil.throwAsObj(IllegalStateException::new);
        }
        this.terminal = terminalMethodBuilder;
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        this.consumer.accept(Objects.requireNonNull(element));
        return this;
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        this.consumer.accept(this.terminal.bufferedCodeBuilder(null).run(handler).toModel());
        return this;
    }

    @Override
    public MethodBuilder transformCode(CodeModel code, CodeTransform transform) {
        BufferedCodeBuilder builder = this.terminal.bufferedCodeBuilder(code);
        builder.transform(code, transform);
        this.consumer.accept(builder.toModel());
        return this;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }
}

