/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.RestartWorkflowTask;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;

final class DefaultWorkflowExecutionContext
implements WorkflowExecutionContext {
    private static final Logger log = Logger.getLogger(DefaultWorkflowExecutionContext.class);
    private final String resourceId;
    private final String executionId;
    private final Workflow workflow;
    private final WorkflowEvent event;
    private final KeycloakSession session;
    private final WorkflowStep step;
    private boolean completed;

    DefaultWorkflowExecutionContext(KeycloakSession session, Workflow workflow, WorkflowEvent event) {
        this(session, workflow, event, null, UUID.randomUUID().toString(), event.getResourceId());
    }

    DefaultWorkflowExecutionContext(KeycloakSession session, Workflow workflow, WorkflowEvent event, WorkflowStateProvider.ScheduledStep step) {
        this(session, workflow, event, null, step.executionId(), event.getResourceId());
    }

    DefaultWorkflowExecutionContext(KeycloakSession session, Workflow workflow, WorkflowStateProvider.ScheduledStep step) {
        this(session, workflow, null, step.stepId(), step.executionId(), step.resourceId());
    }

    DefaultWorkflowExecutionContext(KeycloakSession session, DefaultWorkflowExecutionContext context) {
        this(session, context.getWorkflow(), context.getEvent(), context.getCurrentStepId(), context.getExecutionId(), context.getResourceId());
        this.completed = context.isCompleted();
    }

    DefaultWorkflowExecutionContext(KeycloakSession session, DefaultWorkflowExecutionContext context, WorkflowStep step) {
        this(session, context.getWorkflow(), context.getEvent(), step.getId(), context.getExecutionId(), context.getResourceId());
        this.completed = context.isCompleted();
    }

    private DefaultWorkflowExecutionContext(KeycloakSession session, Workflow workflow, WorkflowEvent event, String stepId, String executionId, String resourceId) {
        this.session = session;
        this.workflow = workflow;
        this.event = event;
        this.step = stepId != null ? workflow.getStepById(stepId) : null;
        this.executionId = executionId;
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public WorkflowEvent getEvent() {
        return this.event;
    }

    public WorkflowStep getNextStep() {
        return this.workflow.getSteps(this.step.getId()).skip(1L).findFirst().orElse(null);
    }

    String getExecutionId() {
        return this.executionId;
    }

    Workflow getWorkflow() {
        return this.workflow;
    }

    WorkflowStep getStep() {
        return this.step;
    }

    boolean isCompleted() {
        return this.completed;
    }

    void complete() {
        this.completed = true;
    }

    void restart(int position) {
        new RestartWorkflowTask(this, position).run(this.session);
    }

    KeycloakSession getSession() {
        return this.session;
    }

    private String getCurrentStepId() {
        return this.step != null ? this.step.getId() : null;
    }
}

